/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.model.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.lopymine.mtd.atlas.AtlasSprite;
import net.lopymine.mtd.extension.DilationExtension;
import net.lopymine.mtd.extension.ModelTransformExtension;
import net.lopymine.mtd.model.base.MCuboid;
import net.lopymine.mtd.model.base.MModelCollection;
import net.lopymine.mtd.model.bb.BBModel;
import net.lopymine.mtd.model.bb.ModelState;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5605;
import net.minecraft.class_630;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MModel
extends class_630 {
    private class_809 transformation = class_809.field_4301;
    private final Map<String, MModel> mChildren;
    private final List<MModel> mChildrenModels;
    private final List<MCuboid> mCuboids;
    private final ModelState state;
    private final String name;
    private boolean skipRendering = false;
    @Nullable
    private MModel parent;
    @Nullable
    private class_2960 location;
    @Nullable
    private AtlasSprite builtinTexture;

    public MModel(List<MCuboid> mCuboids, Map<String, MModel> mChildren, ModelState state, String name, @Nullable AtlasSprite builtinTexture) {
        super(mCuboids.stream().map(MCuboid::asCuboid).toList(), mChildren.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MModel)((Object)((Object)e.getValue()))).asModelPart())));
        this.state = state;
        this.name = name;
        this.mChildren = mChildren;
        this.mChildrenModels = new ArrayList<MModel>(mChildren.values());
        this.mChildrenModels.forEach(mmodel -> mmodel.setParent(this));
        this.mCuboids = mCuboids;
        this.builtinTexture = builtinTexture;
    }

    public MModel initAfterBuild(BBModel model) {
        this.setLocation(model.getLocation());
        this.setTransformation(model.getTransformation());
        return this;
    }

    public void setLocation(@NotNull class_2960 location) {
        this.location = location;
        this.mChildren.forEach((modelName, model) -> model.setLocation(location));
    }

    public void method_22699(class_4587 matrices, class_4588 vertices, int light, int overlay, int color) {
    }

    public MModelCollection findModels(String suffix) {
        ArrayList<MModel> list = new ArrayList<MModel>();
        for (Map.Entry<String, MModel> entry : this.mChildren.entrySet()) {
            String key = entry.getKey();
            MModel model = entry.getValue();
            if (!key.endsWith(suffix) || model == null || model.getState() != ModelState.GROUP) continue;
            list.add(model);
        }
        for (MModel value : this.mChildrenModels) {
            list.addAll(value.findModels(suffix).getModels());
        }
        return new MModelCollection(list, suffix);
    }

    public class_630 asModelPart() {
        return this;
    }

    public void draw(class_4587 matrices, class_4597 provider, class_1059 atlas, class_1921 atlasRenderLayer, AtlasSprite mainSprite, Map<String, AtlasSprite> requestedParts, int light, int overlay, int color) {
        AtlasSprite currentSpriteId;
        AtlasSprite providedSprite = requestedParts.get(this.getName());
        if (this.skipRendering && providedSprite == null || !this.field_3665 || this.mCuboids.isEmpty() && this.mChildren.isEmpty()) {
            return;
        }
        AtlasSprite atlasSprite = this.builtinTexture == null ? (providedSprite == null ? mainSprite : providedSprite) : (currentSpriteId = this.builtinTexture);
        if (currentSpriteId == null) {
            return;
        }
        matrices.method_22903();
        this.method_22703(matrices);
        if (!this.field_38456 && !this.mCuboids.isEmpty()) {
            class_1058 currentSprite = atlas.method_4608(currentSpriteId.getSpriteId());
            class_4588 consumer = currentSprite.method_24108(provider.getBuffer(atlasRenderLayer));
            this.method_22702(matrices.method_23760(), consumer, light, overlay, color);
        }
        for (MModel model : this.mChildrenModels) {
            model.draw(matrices, provider, atlas, atlasRenderLayer, currentSpriteId, requestedParts, light, overlay, color);
        }
        matrices.method_22909();
    }

    private int getCountOfParents() {
        return this.parent == null ? 0 : this.parent.getCountOfParents() + 1;
    }

    private String getHierarchyLine(int countOfParents) {
        if (countOfParents == 0) {
            return "";
        }
        String tab = "   ";
        String root = "\u2514\u2500\u2500";
        return tab.repeat(countOfParents - 1) + root;
    }

    public void logHierarchy(Logger logger) {
        int countOfParents = this.getCountOfParents();
        String hierarchyLine = this.getHierarchyLine(countOfParents);
        String dataHierarchyLine = this.getHierarchyLine(countOfParents + 1);
        String main = "%s %s".formatted(hierarchyLine, this.toString());
        String transform = "%s Transform: [%s]".formatted(dataHierarchyLine, ModelTransformExtension.asString(this.method_32084()));
        String scale = "%s Scale: [%s %s %s]".formatted(dataHierarchyLine, Float.valueOf(this.field_37938), Float.valueOf(this.field_37939), Float.valueOf(this.field_37940));
        logger.info(main);
        logger.info(transform);
        logger.info(scale);
        String cuboidHierarchyLine = this.getHierarchyLine(countOfParents + 1);
        String cuboidDataHierarchyLine = this.getHierarchyLine(countOfParents + 1 + 1);
        for (MCuboid mCuboid : this.mCuboids) {
            class_5605 dilation = mCuboid.getDilation();
            String cuboidMain = "%s %s".formatted(cuboidHierarchyLine, this.toString());
            String cuboidFrom = "%s From: [%s %s %s]".formatted(cuboidDataHierarchyLine, Float.valueOf(mCuboid.field_3645), Float.valueOf(mCuboid.field_3644), Float.valueOf(mCuboid.field_3643));
            String cuboidTo = "%s To: [%s %s %s]".formatted(cuboidDataHierarchyLine, Float.valueOf(mCuboid.field_3648), Float.valueOf(mCuboid.field_3647), Float.valueOf(mCuboid.field_3646));
            String cuboidDilation = "%s Dilation: [%s %s %s]".formatted(cuboidDataHierarchyLine, Float.valueOf(DilationExtension.getRadiusX(dilation)), Float.valueOf(DilationExtension.getRadiusY(dilation)), Float.valueOf(DilationExtension.getRadiusZ(dilation)));
            logger.info(cuboidMain);
            logger.info(cuboidFrom);
            logger.info(cuboidTo);
            logger.info(cuboidDilation);
        }
        for (MModel mModel : this.mChildrenModels) {
            mModel.logHierarchy(logger);
        }
    }

    public void logSize(Logger logger) {
        class_238 box = this.getBox();
        logger.info("Union Model Size:");
        logger.info("Size: [{}, {}, {}]", new Object[]{Math.abs(box.field_1323 - box.field_1320), Math.abs(box.field_1322 - box.field_1325), Math.abs(box.field_1321 - box.field_1324)});
        logger.info("From: [{}, {}, {}]", new Object[]{box.field_1323, box.field_1322, box.field_1321});
        logger.info("To:   [{}, {}, {}]", new Object[]{box.field_1320, box.field_1325, box.field_1324});
    }

    public List<MModel> getHierarchyList() {
        ArrayList<MModel> hierarchy = new ArrayList<MModel>();
        hierarchy.add(this);
        if (this.parent != null) {
            hierarchy.addAll(this.parent.getHierarchyList());
        }
        return hierarchy;
    }

    public class_238 getBox() {
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = 0.0f;
        float maxY = 0.0f;
        float maxZ = 0.0f;
        for (class_630.class_628 class_6282 : this.mCuboids) {
            minX = Math.min(minX, class_6282.field_3645);
            minY = Math.min(minY, class_6282.field_3644);
            minZ = Math.min(minZ, class_6282.field_3643);
            maxX = Math.max(maxX, class_6282.field_3648);
            maxY = Math.max(maxY, class_6282.field_3647);
            maxZ = Math.max(maxZ, class_6282.field_3646);
        }
        class_238 box = new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        for (MModel value : this.mChildren.values()) {
            class_238 size = value.getBox();
            box = box.method_991(size);
        }
        return box;
    }

    public String toString() {
        return "%s [%s]".formatted(this.getName(), this.getState().name().toUpperCase());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MModel)) {
            return false;
        }
        MModel that = (MModel)((Object)obj);
        if (that == this) {
            return true;
        }
        return Objects.equals(this.getLocation(), that.getLocation());
    }

    public int hashCode() {
        return this.getLocation() == null ? super.hashCode() : this.getLocation().hashCode();
    }

    public class_809 getTransformation() {
        return this.transformation;
    }

    public Map<String, MModel> getMChildren() {
        return this.mChildren;
    }

    public List<MModel> getMChildrenModels() {
        return this.mChildrenModels;
    }

    public List<MCuboid> getMCuboids() {
        return this.mCuboids;
    }

    public ModelState getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSkipRendering() {
        return this.skipRendering;
    }

    @Nullable
    public MModel getParent() {
        return this.parent;
    }

    @Nullable
    public class_2960 getLocation() {
        return this.location;
    }

    @Nullable
    public AtlasSprite getBuiltinTexture() {
        return this.builtinTexture;
    }

    public void setSkipRendering(boolean skipRendering) {
        this.skipRendering = skipRendering;
    }

    public void setParent(@Nullable MModel parent) {
        this.parent = parent;
    }

    public void setBuiltinTexture(@Nullable AtlasSprite builtinTexture) {
        this.builtinTexture = builtinTexture;
    }

    private void setTransformation(class_809 transformation) {
        this.transformation = transformation;
    }
}

