/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.gui.widget.tag;

import java.util.List;
import net.lopymine.mtd.MyTotemDoll;
import net.lopymine.mtd.tag.Tag;
import net.lopymine.mtd.tag.manager.TagsManager;
import net.lopymine.mtd.utils.DrawUtils;
import net.lopymine.mtd.utils.tooltip.IRequestableTooltipScreen;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;

public class TagButtonWidget
extends class_4185 {
    public static final class_2960 INACTIVE_TEXTURE = MyTotemDoll.id("textures/gui/tag_menu/button_inactive.png");
    public static final class_8666 TEXTURES = new class_8666(MyTotemDoll.id("textures/gui/tag_menu/button_pressed.png"), MyTotemDoll.id("textures/gui/tag_menu/button_unpressed.png"), MyTotemDoll.id("textures/gui/tag_menu/button_pressed_hovered.png"), MyTotemDoll.id("textures/gui/tag_menu/button_unpressed_hovered.png"));
    private Tag tag;
    private String text;
    private class_2960 icon;
    private boolean pressed;
    @Nullable
    private class_2561 tooltipText;
    private boolean canBeHovered = true;

    public TagButtonWidget(Tag tag, int x, int y, TagPressAction pressAction) {
        super(x, y, 14, 14, class_2561.method_30163((String)""), widget -> pressAction.onPress((TagButtonWidget)widget), class_4185.field_40754);
        this.tag = tag;
        this.text = String.valueOf(tag.getTag());
        this.icon = TagsManager.getTagIcon(this.text.charAt(0));
    }

    public void method_25306() {
        this.pressed = !this.pressed;
        super.method_25306();
    }

    public void setPressed(boolean pressed) {
        this.setPressed(pressed, false);
    }

    public void setPressed(boolean enabled, boolean callback) {
        this.pressed = enabled;
        if (callback) {
            this.field_22767.onPress((class_4185)this);
        }
    }

    public void setTooltip(@Nullable class_2561 text) {
        this.tooltipText = text;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        this.renderButton(context, this.method_46426(), this.method_46427());
        this.requestTooltip();
    }

    protected void renderButton(class_332 context, int x, int y) {
        this.renderBackground(context, x, y);
        this.renderIcon(context, x, y);
    }

    protected void renderIcon(class_332 context, int x, int y) {
        DrawUtils.drawTexture(context, this.icon, x + this.method_25368() / 2 - 5, y + this.method_25364() / 2 - 5, 0.0f, 0.0f, 10, 10, 10, 10);
    }

    protected void renderBackground(class_332 context, int x, int y) {
        class_2960 texture = !this.field_22763 ? INACTIVE_TEXTURE : TEXTURES.method_52729(this.isPressed(), this.method_49606());
        DrawUtils.drawTexture(context, texture, x, y, 0.0f, 0.0f, this.field_22758, this.field_22759, this.field_22758, this.field_22759);
    }

    public void requestTooltip() {
        class_310 client = class_310.method_1551();
        class_437 screen = client.field_1755;
        if (!this.method_49606()) {
            return;
        }
        class_5684 component = this.getTooltipComponent();
        if (component == null) {
            return;
        }
        if (!(screen instanceof IRequestableTooltipScreen)) {
            return;
        }
        IRequestableTooltipScreen tooltipScreen = (IRequestableTooltipScreen)screen;
        tooltipScreen.myTotemDoll$requestTooltip((c, x, y, d) -> DrawUtils.drawTooltip(c, List.of(component), x, y));
    }

    @Nullable
    protected class_5684 getTooltipComponent() {
        if (this.tooltipText == null) {
            return null;
        }
        return class_5684.method_32662((class_5481)this.tooltipText.method_30937());
    }

    public boolean over(double mouseX, double mouseY) {
        return this.field_22763 && this.field_22764 && mouseX >= (double)this.method_46426() && mouseY >= (double)this.method_46427() && mouseX < (double)(this.method_46426() + this.method_25368()) && mouseY < (double)(this.method_46427() + this.method_25364());
    }

    public boolean method_49606() {
        return super.method_49606() && this.isCanBeHovered();
    }

    public Tag getTag() {
        return this.tag;
    }

    public String getText() {
        return this.text;
    }

    public class_2960 getIcon() {
        return this.icon;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    @Nullable
    public class_2561 getTooltipText() {
        return this.tooltipText;
    }

    public boolean isCanBeHovered() {
        return this.canBeHovered;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setIcon(class_2960 icon) {
        this.icon = icon;
    }

    public void setTooltipText(@Nullable class_2561 tooltipText) {
        this.tooltipText = tooltipText;
    }

    public void setCanBeHovered(boolean canBeHovered) {
        this.canBeHovered = canBeHovered;
    }

    @FunctionalInterface
    public static interface TagPressAction {
        public void onPress(TagButtonWidget var1);
    }
}

