/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.gui.widget.tag;

import java.util.Optional;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.config.MyTotemDollConfig;
import net.lopymine.mtd.doll.data.TotemDollData;
import net.lopymine.mtd.doll.manager.StandardTotemDollManager;
import net.lopymine.mtd.doll.renderer.TotemDollRenderer;
import net.lopymine.mtd.gui.tooltip.preview.TotemDollPreviewTooltipData;
import net.lopymine.mtd.gui.widget.tag.TagButtonWidget;
import net.lopymine.mtd.tag.CustomModelTag;
import net.lopymine.mtd.tag.Tag;
import net.lopymine.mtd.tag.manager.TagsManager;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;

public class CustomModelTagButtonWidget
extends TagButtonWidget {
    @Nullable
    private final class_2960 model;
    private TotemDollData data;
    @Nullable
    private TotemDollData tooltipData;
    private boolean tooltipDataActive = false;

    public CustomModelTagButtonWidget(Tag tag, int x, int y, TagButtonWidget.TagPressAction pressAction) {
        super(tag, x, y, pressAction);
        this.model = Optional.ofNullable(TagsManager.getCustomModelIdsTags().get(Character.valueOf(tag.getTag()))).map(CustomModelTag::getModelId).orElse(null);
        this.data = StandardTotemDollManager.getStandardDoll().copy();
    }

    public void updateData(TotemDollData data) {
        if (this.model == null || this.data == data || data == null) {
            return;
        }
        this.data = data.copy();
        this.data.setStandardMModel(this.model);
    }

    @Override
    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_48579(context, mouseX, mouseY, delta);
        if (!this.tooltipDataActive) {
            this.tooltipData = null;
        }
        this.tooltipDataActive = false;
    }

    @Override
    protected void renderIcon(class_332 context, int x, int y) {
        context.method_44379(this.method_46426() + 1, this.method_46427() + 1, this.method_46426() + this.method_25368() - 1, this.method_46427() + this.method_25364() - 1);
        TotemDollRenderer.renderPreview(context, x, y, this.method_25368(), this.method_25364(), Math.min(this.method_25368(), this.method_25364()), this.getData().refreshAndApplyRenderProperties());
        context.method_44380();
    }

    @Override
    @Nullable
    public class_5684 getTooltipComponent() {
        if (this.model == null) {
            return class_5684.method_32662((class_5481)class_2561.method_30163((String)"Unknown Model").method_30937());
        }
        if (this.tooltipData == null) {
            this.tooltipData = this.data.copy();
            this.tooltipData.setStandardMModel(this.data.getRenderProperties().getStandardMModel());
        }
        this.tooltipDataActive = true;
        return class_5684.method_32663((class_5632)new TotemDollPreviewTooltipData(this.tooltipData, this.model));
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        int amount = (int)verticalAmount > 0 ? 1 : -1;
        MyTotemDollConfig config = MyTotemDollClient.getConfig();
        if (class_437.method_25442()) {
            config.setBetterTagMenuTooltipSize(class_3532.method_15340((int)(config.getBetterTagMenuTooltipSize() + amount * 2), (int)60, (int)500));
            return true;
        }
        if (class_437.method_25441()) {
            config.setTagMenuTooltipModelScale(class_3532.method_15363((float)(config.getTagMenuTooltipModelScale() + (float)amount / 12.0f), (float)0.1f, (float)10.0f));
            return true;
        }
        return false;
    }

    public void setData(TotemDollData data) {
        this.data = data;
    }

    public void setTooltipData(@Nullable TotemDollData tooltipData) {
        this.tooltipData = tooltipData;
    }

    public void setTooltipDataActive(boolean tooltipDataActive) {
        this.tooltipDataActive = tooltipDataActive;
    }

    @Nullable
    public class_2960 getModel() {
        return this.model;
    }

    public TotemDollData getData() {
        return this.data;
    }

    @Nullable
    public TotemDollData getTooltipData() {
        return this.tooltipData;
    }

    public boolean isTooltipDataActive() {
        return this.tooltipDataActive;
    }
}

