/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.gui.widget;

import java.util.Objects;
import net.lopymine.mtd.MyTotemDoll;
import net.lopymine.mtd.doll.data.TotemDollData;
import net.lopymine.mtd.doll.manager.StandardTotemDollManager;
import net.lopymine.mtd.doll.renderer.TotemDollRenderer;
import net.lopymine.mtd.model.base.MModel;
import net.lopymine.mtd.model.bb.manager.BlockBenchModelManager;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;

public class TotemDollModelPreviewWidget
extends class_339 {
    private final float size;
    private final TotemDollData data;
    private boolean loading;
    private boolean failedLoading;

    public TotemDollModelPreviewWidget(int x, int y, float size) {
        super(x, y, (int)size, (int)size, class_2561.method_30163((String)""));
        this.size = size;
        this.data = StandardTotemDollManager.getStandardDoll().copy();
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364());
        if (this.loading) {
            this.renderLoadingText(context);
        } else {
            this.renderPreview(context);
        }
        context.method_44380();
    }

    protected void renderLoadingText(class_332 context) {
        int halfOfSize = (int)this.size / 2;
        class_327 textRenderer = class_310.method_1551().field_1772;
        class_2561 class_25612 = this.getLoadingText(class_156.method_658());
        int n = this.method_46426() + halfOfSize;
        int n2 = this.method_46427() + halfOfSize;
        Objects.requireNonNull(textRenderer);
        context.method_27534(textRenderer, class_25612, n, n2 - 9 / 2, -1);
    }

    protected void renderPreview(class_332 context) {
        TotemDollRenderer.renderPreview(context, this.method_46426(), this.method_46427(), (int)this.getSize(), (int)this.getSize(), this.getSize(), this.getData().refreshAndApplyRenderProperties());
    }

    public void updateModel(class_2960 id) {
        this.loading = true;
        BlockBenchModelManager.getModelAsyncAsResponse(id, response -> {
            if (!response.isEmpty()) {
                MModel value = (MModel)((Object)((Object)response.value()));
                this.loading = false;
                this.updateModel(value);
            } else {
                this.failedLoading = true;
            }
        });
    }

    public void updateModel(MModel model) {
        this.data.setStandardMModel(model);
    }

    private class_2561 getLoadingText(long tick) {
        if (this.failedLoading) {
            return MyTotemDoll.text("text.loading.failed", new Object[0]);
        }
        int i = (int)(tick / 300L % 4L);
        return MyTotemDoll.text("text.loading.%s".formatted(i), new Object[0]);
    }

    protected void method_47399(class_6382 builder) {
    }

    public float getSize() {
        return this.size;
    }

    public TotemDollData getData() {
        return this.data;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public boolean isFailedLoading() {
        return this.failedLoading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public void setFailedLoading(boolean failedLoading) {
        this.failedLoading = failedLoading;
    }
}

