/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.doll.manager;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.lopymine.mtd.MyTotemDoll;
import net.lopymine.mtd.atlas.manager.MyTotemDollAtlasSpriteManager;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.config.MyTotemDollConfig;
import net.lopymine.mtd.config.totem.TotemDollSkinType;
import net.lopymine.mtd.doll.data.LoadingState;
import net.lopymine.mtd.doll.data.TotemDollData;
import net.lopymine.mtd.doll.data.TotemDollSprites;
import net.lopymine.mtd.skin.provider.extended.MojangSkinProvider;
import net.lopymine.mtd.utils.texture.FailedAction;
import net.lopymine.mtd.utils.texture.PlayerSkinUtils;
import net.lopymine.mtd.utils.texture.SuccessAction;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardTotemDollManager {
    @Nullable
    private static TotemDollData DEFAULT_DOLL;

    @NotNull
    public static TotemDollData getStandardDoll() {
        if (DEFAULT_DOLL == null) {
            return StandardTotemDollManager.initializeStandardDollData();
        }
        return DEFAULT_DOLL;
    }

    public static TotemDollData initializeStandardDollData() {
        DEFAULT_DOLL = StandardTotemDollManager.overrideWithConfigValues(StandardTotemDollManager.loadStandardDoll());
        return DEFAULT_DOLL;
    }

    public static TotemDollData updateDoll(boolean recreateModel) {
        TotemDollData standardDoll = StandardTotemDollManager.getStandardDoll();
        StandardTotemDollManager.overrideWithConfigValues(standardDoll);
        standardDoll.setShouldRecreateStandardModel(recreateModel);
        return standardDoll.refreshAndApplyRenderProperties();
    }

    public static TotemDollData overrideWithConfigValues(TotemDollData data) {
        MyTotemDollConfig config = MyTotemDollClient.getConfig();
        data.getStandardSprites().setStandardArmsType(config.getStandardTotemDollArmsType());
        return data;
    }

    @NotNull
    public static TotemDollData loadStandardDoll() {
        MyTotemDollConfig config = MyTotemDollClient.getConfig();
        TotemDollSkinType totemDollSkin = config.getStandardTotemDollSkinType();
        String data = config.getStandardTotemDollSkinValue();
        if (totemDollSkin == TotemDollSkinType.STEVE || totemDollSkin == TotemDollSkinType.HOLDING_PLAYER || data == null || data.isEmpty()) {
            return StandardTotemDollManager.getSteveDoll();
        }
        return switch (totemDollSkin) {
            case TotemDollSkinType.PLAYER -> StandardTotemDollManager.loadPlayerSkin(data);
            case TotemDollSkinType.URL_SKIN -> StandardTotemDollManager.loadUrlSkin(data);
            case TotemDollSkinType.FILE_SKIN -> StandardTotemDollManager.loadFileSkin(data);
            default -> StandardTotemDollManager.getSteveDoll();
        };
    }

    @NotNull
    public static TotemDollData getSteveDoll() {
        TotemDollData totemDollData = TotemDollData.create(null);
        totemDollData.getStandardSprites().setState(LoadingState.DOWNLOADED);
        return totemDollData;
    }

    public static TotemDollData loadFileSkin(@NotNull String data) {
        TotemDollData totemDollData = TotemDollData.create(null);
        TotemDollSprites textures = totemDollData.getStandardSprites();
        textures.setState(LoadingState.DOWNLOADING);
        CompletableFuture.runAsync(() -> {
            class_2960 id = MyTotemDoll.getDollTextureId("file/%s".formatted(Math.abs(data.hashCode())));
            try (InputStream inputStream = Files.newInputStream(Path.of(data, new String[0]), new OpenOption[0]);){
                class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);
                MyTotemDollAtlasSpriteManager.registerSpecialSkinSprite(id, nativeImage, true, sprite -> {
                    textures.setSkinSprite(sprite);
                    textures.setState(LoadingState.DOWNLOADED);
                });
            }
            catch (NoSuchFileException e) {
                textures.setState(LoadingState.CRITICAL_ERROR);
            }
            catch (Exception e) {
                MyTotemDollClient.LOGGER.error("Failed to load skin from file at \"{}\":", (Object)data, (Object)e);
                textures.setState(LoadingState.CRITICAL_ERROR);
            }
        });
        return totemDollData;
    }

    public static TotemDollData loadUrlSkin(@NotNull String data) {
        TotemDollData totemDollData = TotemDollData.create(null);
        TotemDollSprites textures = totemDollData.getStandardSprites();
        textures.setState(LoadingState.DOWNLOADING);
        CompletableFuture.runAsync(() -> {
            class_2960 id = MyTotemDoll.getDollTextureId("url/%s".formatted(Math.abs(data.hashCode())));
            FailedAction onFailed = throwable -> {
                textures.setState(LoadingState.CRITICAL_ERROR);
                MyTotemDollClient.LOGGER.warn("Failed to download standard doll url skin:", throwable);
            };
            SuccessAction onSuccess = sprite -> {
                textures.setSkinSprite(sprite);
                textures.setState(LoadingState.DOWNLOADED);
            };
            PlayerSkinUtils.downloadSkin(data, id, onSuccess, onFailed, false);
        });
        return totemDollData;
    }

    public static TotemDollData loadPlayerSkin(@NotNull String data) {
        if (MojangSkinProvider.getInstance().canProcess(data)) {
            TotemDollData totemDollData = MojangSkinProvider.getInstance().createNewDoll(data);
            MojangSkinProvider.getInstance().loadDoll(data, true, totemDollData);
            return totemDollData;
        }
        return StandardTotemDollManager.getSteveDoll();
    }
}

