/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.config.other.simple;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SimpleEntry<K, V>
implements Comparable<SimpleEntry<K, V>> {
    private K key;
    private V value;

    public static <V, K> SimpleEntry<K, V> of(Map.Entry<K, V> entry) {
        return new SimpleEntry<K, V>(entry.getKey(), entry.getValue());
    }

    public SimpleEntry<K, V> setKey(K key) {
        this.key = key;
        return this;
    }

    public SimpleEntry<K, V> setValue(V value) {
        this.value = value;
        return this;
    }

    @Override
    public int compareTo(@NotNull SimpleEntry<K, V> o) {
        return o.getKey().toString().compareTo(this.key.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleEntry)) {
            return false;
        }
        SimpleEntry that = (SimpleEntry)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public SimpleEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }
}

