/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.client.command.reload;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.lopymine.mtd.api.MojangAPI;
import net.lopymine.mtd.client.command.builder.CommandTextBuilder;
import net.lopymine.mtd.doll.manager.TotemDollManager;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class RefreshCommand {
    @Nullable
    private static CompletableFuture<Float> currentRefreshingFuture;

    public static LiteralArgumentBuilder<FabricClientCommandSource> getInstance() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"refresh").then(ClientCommandManager.literal((String)"all").executes(RefreshCommand::reloadAll))).then(ClientCommandManager.literal((String)"player").then(ClientCommandManager.argument((String)"nickname", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(TotemDollManager.getAllLoadedKeys(), (SuggestionsBuilder)builder)).executes(RefreshCommand::reloadForPlayer)));
    }

    private static int reloadAll(CommandContext<FabricClientCommandSource> context) {
        if (currentRefreshingFuture != null) {
            return 0;
        }
        class_2561 startFeedback = CommandTextBuilder.startBuilder("command.refresh.all.start", new Object[0]).build();
        ((FabricClientCommandSource)context.getSource()).sendFeedback(startFeedback);
        currentRefreshingFuture = TotemDollManager.reload(seconds -> {
            class_2561 endFeedback = CommandTextBuilder.startBuilder("command.refresh.all.end", seconds).build();
            ((FabricClientCommandSource)context.getSource()).sendFeedback(endFeedback);
            currentRefreshingFuture = null;
        });
        MojangAPI.useFallbackAPI = false;
        return 1;
    }

    private static int reloadForPlayer(CommandContext<FabricClientCommandSource> context) {
        if (currentRefreshingFuture != null) {
            return 0;
        }
        String nickname = StringArgumentType.getString(context, (String)"nickname");
        class_2561 startFeedback = CommandTextBuilder.startBuilder("command.refresh.player.start", nickname).build();
        ((FabricClientCommandSource)context.getSource()).sendFeedback(startFeedback);
        currentRefreshingFuture = TotemDollManager.reload(nickname, seconds -> {
            class_2561 feedback = CommandTextBuilder.startBuilder("command.refresh.player.end", nickname, seconds).build();
            ((FabricClientCommandSource)context.getSource()).sendFeedback(feedback);
            currentRefreshingFuture = null;
        });
        return 1;
    }
}

