/*
 * Decompiled with CFR 0.152.
 */
package dlovin.signtools.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;

public class ReflectionUtils {
    public static Object getPrivateFieldValueByType(Object o, Class<?> objectClasstype, Class<?> fieldClasstype) {
        return ReflectionUtils.getPrivateFieldValueByType(o, objectClasstype, fieldClasstype, 0);
    }

    public static Object getPrivateFieldValueByType(Object o, Class<?> objectClasstype, Class<?> fieldClasstype, int index) {
        Class<?> objectClass = o != null ? o.getClass() : objectClasstype;
        while (!objectClass.equals(objectClasstype) && objectClass.getSuperclass() != null) {
            objectClass = objectClass.getSuperclass();
        }
        int counter = 0;
        Field[] fields = objectClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fieldClasstype.equals(fields[i].getType())) continue;
            if (counter == index) {
                try {
                    fields[i].setAccessible(true);
                    return fields[i].get(o);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++counter;
        }
        return null;
    }

    public static Object getPrivateFieldValue(@NotNull Object o, Class<?> fieldClasstype) {
        Class<?> objectClass = o.getClass();
        Field[] fields = objectClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fieldClasstype.equals(fields[i].getType())) continue;
            try {
                fields[i].setAccessible(true);
                return fields[i].get(o);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Method getFirstMethodWithParams(@NotNull Object object, Class<?> ... params) {
        return ReflectionUtils.getMethodWithParams(object, 0, params);
    }

    public static Method getMethodWithParams(@NotNull Object object, int index, Class<?> ... params) {
        return ReflectionUtils.getMethodWithParamsInClass(object.getClass(), index, 0, params);
    }

    private static Method getMethodWithParamsInClass(Class<?> objectClass, int index, int count, Class<?> ... params) {
        for (Method method : objectClass.getDeclaredMethods()) {
            Class<?>[] methodParams = method.getParameterTypes();
            if (methodParams.length != params.length) continue;
            boolean match = true;
            for (int i = 0; i < methodParams.length; ++i) {
                if (methodParams[i] == params[i]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            if (count == index) {
                method.setAccessible(true);
                return method;
            }
            ++count;
        }
        if (objectClass.getSuperclass() != null) {
            return ReflectionUtils.getMethodWithParamsInClass(objectClass.getSuperclass(), index, count, params);
        }
        return null;
    }

    private static Method getFirstMethodWithParamsInClass(Class<?> objectClass, Class<?> ... params) {
        for (Method method : objectClass.getDeclaredMethods()) {
            Class<?>[] methodParams = method.getParameterTypes();
            if (methodParams.length != params.length) continue;
            boolean match = true;
            for (int i = 0; i < methodParams.length; ++i) {
                if (methodParams[i] == params[i]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            method.setAccessible(true);
            return method;
        }
        if (objectClass.getSuperclass() != null) {
            return ReflectionUtils.getFirstMethodWithParamsInClass(objectClass.getSuperclass(), params);
        }
        return null;
    }
}

