/*
 * Decompiled with CFR 0.152.
 */
package dlovin.signtools.handlers;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.signtools.SignTools;
import dlovin.signtools.gui.widgets.CustomButton;
import dlovin.signtools.reference.Translation;
import dlovin.signtools.utils.ReflectionUtils;
import dlovin.signtools.utils.SignUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2478;
import net.minecraft.class_2551;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_4597;
import net.minecraft.class_4719;
import net.minecraft.class_7743;
import net.minecraft.class_7744;
import net.minecraft.class_7919;
import net.minecraft.class_8242;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class GuiHandler {
    private static class_2960 SIGN = new class_2960("minecraft", "textures/entity/signs/oak.png");
    private static int offset = 0;
    private static int hangingOffset = 0;
    private static Method offsetMethod;
    private static Method signRenderer;
    private static final Vector3f scale;

    public static void initGui(class_7743 gui) {
        offsetMethod = ReflectionUtils.getMethodWithParams(gui, 1, class_332.class, class_2680.class);
        signRenderer = ReflectionUtils.getFirstMethodWithParams(gui, class_332.class, class_2680.class);
        class_2625 sign = (class_2625)ReflectionUtils.getPrivateFieldValueByType(gui, class_7743.class, class_2625.class);
        class_4719 type = ((class_2478)sign.method_11010().method_26204()).method_24025();
        SIGN = new class_2960("minecraft", "textures/entity/signs/" + type.comp_1299() + ".png");
        offset = sign.method_11010().method_26204() instanceof class_2551 || gui instanceof class_7744 ? 35 : 0;
        hangingOffset = gui instanceof class_7744 ? 32 : 0;
        ArrayList<CustomButton> btns = new ArrayList<CustomButton>();
        btns.add(new CustomButton(gui.field_22789 / 2 + 10 + class_310.method_1551().field_1772.method_1727(gui.method_25440().getString()) / 2, 37, 16, 16, 12, 2, true, SignTools.showTools() ? new class_2960("minecraft", "textures/item/barrier.png") : new class_2960("minecraft", "textures/item/" + type.comp_1299() + "_sign.png"), SignTools.showTools() ? Translation.HIDE_TOOLS : Translation.SHOW_TOOLS, b -> GuiHandler.showTools(b, gui, type), class_7919.method_47407((class_2561)(SignTools.showTools() ? Translation.HIDE_TOOLS : Translation.SHOW_TOOLS))));
        for (int i = 0; i < 4; ++i) {
            int finalI = i;
            btns.add(new CustomButton(gui.field_22789 / 2 - 81, 71 + i * 10 + offset, 9, 9, new class_2960(SignTools.modid, "textures/gui/widgets/cut_icon.png"), Translation.CUT, b -> GuiHandler.cutSignLine(finalI, gui), class_7919.method_47407((class_2561)Translation.CUT)));
            btns.add(new CustomButton(gui.field_22789 / 2 - 70, 71 + i * 10 + offset, 9, 9, new class_2960(SignTools.modid, "textures/gui/widgets/copy_icon.png"), Translation.COPY, b -> GuiHandler.copySignLine(finalI, gui), class_7919.method_47407((class_2561)Translation.COPY)));
            if (i != 3) {
                btns.add(new CustomButton(gui.field_22789 / 2 - 59, 71 + i * 10 + offset, 9, 9, new class_2960(SignTools.modid, "textures/gui/widgets/down_icon.png"), Translation.DOWN, b -> GuiHandler.moveLineDown(finalI, gui), class_7919.method_47407((class_2561)Translation.DOWN)));
            }
            if (i != 0) {
                btns.add(new CustomButton(gui.field_22789 / 2 + 50, 71 + i * 10 + offset, 9, 9, new class_2960(SignTools.modid, "textures/gui/widgets/up_icon.png"), Translation.UP, b -> GuiHandler.moveLineUp(finalI, gui), class_7919.method_47407((class_2561)Translation.UP)));
            }
            btns.add(new CustomButton(gui.field_22789 / 2 + 61, 71 + i * 10 + offset, 9, 9, new class_2960(SignTools.modid, "textures/gui/widgets/paste_icon.png"), Translation.PASTE, b -> GuiHandler.pasteSignLine(finalI, gui), class_7919.method_47407((class_2561)Translation.PASTE)));
        }
        btns.add(new CustomButton(gui.field_22789 / 2 - 75, 125 + offset, 60, 16, Translation.COPY_SIGN, b -> GuiHandler.copySign(gui), true, false));
        btns.add(new CustomButton(gui.field_22789 / 2 + 15, 125 + offset, 60, 16, Translation.PASTE_SIGN, b -> GuiHandler.pasteSign(gui), true, true));
        gui.method_25396().addAll(btns);
        if (SignUtils.isAutoPaste()) {
            GuiHandler.pasteSign(gui);
        }
    }

    private static void offset(class_332 context, class_7743 signScreen, class_2625 sign) {
        if (offsetMethod != null) {
            try {
                offsetMethod.invoke((Object)signScreen, context, sign.method_11010());
            }
            catch (IllegalAccessException | InvocationTargetException ignored) {
                GuiHandler.defaultOffset(context, signScreen.field_22789);
            }
        } else {
            GuiHandler.defaultOffset(context, signScreen.field_22789);
        }
    }

    private static void background(class_332 context, class_7743 signScreen, class_2625 sign) {
        if (signRenderer != null) {
            try {
                signRenderer.invoke((Object)signScreen, context, sign.method_11010());
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                GuiHandler.renderSignBackground(context);
            }
        } else {
            GuiHandler.renderSignBackground(context);
        }
    }

    public static void render(class_7743 gui, class_332 context, int mouseX, int mouseY, float ptick) {
        context.method_51448().method_22903();
        if (SignTools.showTools()) {
            GuiHandler.renderBufferSign(context, gui);
            class_310 mc = class_310.method_1551();
            class_327 font = mc.field_1772;
            String message = Translation.BUFFER_TEXT.getString();
            int text_width = font.method_1727(message);
            int width = gui.field_22789;
            context.method_27535(font, (class_2561)class_2561.method_43470((String)(message + class_124.field_1080 + SignUtils.getTextBuffer())), width / 2 - 15 - text_width, 56 + offset - hangingOffset, 0xFFFFFF);
        }
        gui.method_25396().forEach(w -> {
            if (w instanceof CustomButton) {
                ((class_4185)w).method_25394(context, mouseX, mouseY, ptick);
            }
        });
        context.method_51448().method_22909();
    }

    private static void renderBufferSign(class_332 context, class_7743 signScreen) {
        class_308.method_24210();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        class_2625 sign = GuiHandler.getSign(signScreen);
        context.method_51448().method_22903();
        context.method_51448().method_46416(128.0f, 0.0f, 16.0f);
        context.method_51448().method_22903();
        GuiHandler.offset(context, signScreen, sign);
        context.method_51448().method_22903();
        GuiHandler.background(context, signScreen, sign);
        context.method_51448().method_22909();
        context.method_51448().method_22903();
        GuiHandler.renderSignText(context, signScreen, sign);
        context.method_51448().method_22909();
        context.method_51448().method_22909();
        context.method_51448().method_22909();
        class_308.method_24211();
    }

    private static void defaultOffset(class_332 context, int width) {
        context.method_51448().method_46416((float)width / 2.0f, 90.0f + (float)offset, 5.0f);
    }

    private static void renderSignBackground(class_332 context) {
        context.method_25293(SIGN, -48, -24, 96, 48, 2.0f, 2.0f, 24, 12, 64, 32);
    }

    private static void renderSignText(class_332 context, class_7743 screen, class_2625 sign) {
        class_327 font = class_310.method_1551().field_1772;
        context.method_51448().method_46416(0.0f, 0.0f, 4.0f);
        context.method_51448().method_22905(scale.x(), scale.y(), scale.z());
        int textColor = sign.method_49853().method_49872().method_16357();
        int yPos = 4 * sign.method_45469() / 2;
        String title = Translation.BUFFER_SIGN.getString();
        if (font.method_1726()) {
            title = font.method_1721(title);
        }
        int xPos = -font.method_1727(title) / 2;
        context.method_51433(font, title, xPos, -14 - yPos - hangingOffset, 0xFFFFFF, false);
        for (int i = 0; i < 4; ++i) {
            String s = SignUtils.getLine(i);
            if (s == null) continue;
            if (font.method_1726()) {
                s = font.method_1721(s);
            }
            xPos = -font.method_1727(s) / 2;
            context.method_51433(font, s, xPos, i * sign.method_45469() - yPos, textColor, false);
        }
    }

    private static void renderSignText(class_332 context, class_4597.class_4598 bufferSource, class_7743 screen, class_2625 sign) {
        class_327 font = class_310.method_1551().field_1772;
        context.method_51448().method_46416(0.0f, 0.0f, 4.0f);
        context.method_51448().method_22905(scale.x(), scale.y(), scale.z());
        int textColor = sign.method_49853().method_49872().method_16357();
        int yPos = 4 * sign.method_45469() / 2;
        Matrix4f matrix4f = context.method_51448().method_23760().method_23761();
        String title = Translation.BUFFER_TEXT.getString();
        if (font.method_1726()) {
            title = font.method_1721(title);
        }
        float xPos = -font.method_1727(title) / 2;
        font.method_27522(title, xPos, -14.0f - (float)yPos, 0xFFFFFF, true, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0, false);
        for (int i = 0; i < 4; ++i) {
            String s = SignUtils.getLine(i);
            if (s == null) continue;
            if (font.method_1726()) {
                s = font.method_1721(s);
            }
            xPos = -font.method_1727(s) / 2;
            font.method_27522(s, xPos, (float)(i * sign.method_45469() - yPos), textColor, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0, false);
        }
        bufferSource.method_22993();
    }

    private static void showTools(class_4185 b, class_7743 gui, class_4719 type) {
        boolean bool = !SignTools.getConfig().isShowTools();
        gui.method_25396().forEach(w -> {
            if (w instanceof CustomButton) {
                ((CustomButton)((Object)w)).setTools(bool);
            }
        });
        if (bool) {
            ((CustomButton)b).setIcon(new class_2960("minecraft", "textures/item/barrier.png"));
            b.method_25355(Translation.HIDE_TOOLS);
        } else {
            ((CustomButton)b).setIcon(new class_2960("minecraft", "textures/item/" + type.comp_1299() + "_sign.png"));
            b.method_25355(Translation.SHOW_TOOLS);
        }
        SignTools.toggleTools(bool);
        b.method_47400(class_7919.method_47407((class_2561)b.method_25369()));
    }

    private static void copySignLine(int index, class_7743 gui) {
        class_2625 sign = (class_2625)ReflectionUtils.getPrivateFieldValueByType(gui, class_7743.class, class_2625.class);
        SignUtils.setTextBuffer(sign.method_49844(GuiHandler.player()).method_49859(index, true).getString());
    }

    private static void pasteSignLine(int index, class_7743 gui) {
        String[] messages = (String[])ReflectionUtils.getPrivateFieldValueByType(gui, class_7743.class, String[].class);
        class_2625 sign = (class_2625)ReflectionUtils.getPrivateFieldValueByType(gui, class_7743.class, class_2625.class);
        messages[index] = SignUtils.getTextBuffer();
        boolean facing = sign.method_49834(GuiHandler.player());
        sign.method_49840(GuiHandler.getSignText(sign, facing).method_49857(index, (class_2561)class_2561.method_43470((String)messages[index])), facing);
    }

    private static void moveLineDown(int index, class_7743 gui) {
        String[] messages = (String[])ReflectionUtils.getPrivateFieldValueByType(gui, class_7743.class, String[].class);
        class_2625 sign = (class_2625)ReflectionUtils.getPrivateFieldValueByType(gui, class_7743.class, class_2625.class);
        SignUtils.moveDown(messages, index);
        boolean facing = sign.method_49834(GuiHandler.player());
        sign.method_49840(GuiHandler.getSignText(sign, facing).method_49857(index, (class_2561)class_2561.method_43470((String)messages[index])), facing);
        sign.method_49840(GuiHandler.getSignText(sign, facing).method_49857(index + 1, (class_2561)class_2561.method_43470((String)messages[index + 1])), facing);
    }

    private static void moveLineUp(int index, class_7743 gui) {
        String[] messages = (String[])ReflectionUtils.getPrivateFieldValueByType(gui, class_7743.class, String[].class);
        class_2625 sign = (class_2625)ReflectionUtils.getPrivateFieldValueByType(gui, class_7743.class, class_2625.class);
        SignUtils.moveUp(messages, index);
        boolean facing = sign.method_49834(GuiHandler.player());
        sign.method_49840(GuiHandler.getSignText(sign, facing).method_49857(index, (class_2561)class_2561.method_43470((String)messages[index])), facing);
        sign.method_49840(GuiHandler.getSignText(sign, facing).method_49857(index - 1, (class_2561)class_2561.method_43470((String)messages[index - 1])), facing);
    }

    private static void cutSignLine(int index, class_7743 gui) {
        String[] messages = (String[])ReflectionUtils.getPrivateFieldValueByType(gui, class_7743.class, String[].class);
        class_2625 sign = (class_2625)ReflectionUtils.getPrivateFieldValueByType(gui, class_7743.class, class_2625.class);
        boolean facing = sign.method_49834(GuiHandler.player());
        SignUtils.setTextBuffer(GuiHandler.getSignText(sign, facing).method_49859(index, true).getString());
        messages[index] = "";
        sign.method_49840(GuiHandler.getSignText(sign, facing).method_49857(index, (class_2561)class_2561.method_43470((String)messages[index])), facing);
    }

    private static void pasteSign(class_7743 gui) {
        String[] messages = (String[])ReflectionUtils.getPrivateFieldValueByType(gui, class_7743.class, String[].class);
        class_2625 sign = (class_2625)ReflectionUtils.getPrivateFieldValueByType(gui, class_7743.class, class_2625.class);
        String[] buffer = SignUtils.getLines();
        boolean facing = sign.method_49834(GuiHandler.player());
        class_8242 text = GuiHandler.getSignText(sign, facing);
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = buffer[i];
            sign.method_49840(text.method_49858(i, (class_2561)class_2561.method_43470((String)buffer[i]), (class_2561)class_2561.method_43470((String)buffer[i])), facing);
        }
    }

    private static void copySign(class_7743 gui) {
        String[] messages = (String[])ReflectionUtils.getPrivateFieldValueByType(gui, class_7743.class, String[].class);
        for (int i = 0; i < messages.length; ++i) {
            SignUtils.setLine(i, messages[i]);
        }
    }

    private static class_2625 getSign(class_7743 screen) {
        return (class_2625)ReflectionUtils.getPrivateFieldValueByType(screen, class_7743.class, class_2625.class);
    }

    private static class_1657 player() {
        return class_310.method_1551().field_1724;
    }

    private static class_8242 getSignText(class_2625 sign, boolean facing) {
        return sign.method_49843(facing);
    }

    static {
        scale = new Vector3f(1.0f, 1.0f, 1.0f);
    }
}

