/*
 * Decompiled with CFR 0.152.
 */
package dlovin.signtools.config;

import dlovin.signtools.SignTools;
import dlovin.signtools.config.SignToolsConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static File file;
    private static SignToolsConfig config;

    private static void prepareConfigFile() {
        if (file != null) {
            return;
        }
        file = new File(FabricLoader.getInstance().getConfigDir().toString(), SignTools.modid + ".json");
    }

    public static SignToolsConfig initializeConfig() {
        if (config != null) {
            return config;
        }
        config = new SignToolsConfig();
        ConfigManager.load();
        return config;
    }

    public static void save() {
        ConfigManager.prepareConfigFile();
        String jsonString = SignTools.GSON.toJson((Object)config);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save SignTools configuration file");
            e.printStackTrace();
        }
    }

    private static void load() {
        ConfigManager.prepareConfigFile();
        try {
            BufferedReader br;
            SignToolsConfig parsed;
            if (!file.exists()) {
                ConfigManager.save();
            }
            if (file.exists() && (parsed = (SignToolsConfig)SignTools.GSON.fromJson((Reader)(br = new BufferedReader(new FileReader(file))), SignToolsConfig.class)) != null) {
                config = parsed;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't load SignTools configuration file; reverting to defaults");
            e.printStackTrace();
        }
    }

    public static SignToolsConfig getConfig() {
        if (config == null) {
            config = new SignToolsConfig();
        }
        return config;
    }
}

