/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.renderer;

import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.impl.renderer.BasePreviewRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ModPreviewRenderer
extends BasePreviewRenderer {
    private static final class_2960 DEFAULT_TEXTURE_LIGHT = new class_2960("shulkerboxtooltip", "textures/gui/shulker_box_tooltip.png");
    public static final ModPreviewRenderer INSTANCE = new ModPreviewRenderer();

    ModPreviewRenderer() {
        super(18, 18, 8, 8);
    }

    @Override
    public int getWidth() {
        return 14 + Math.min(this.getMaxRowSize(), this.getInvSize()) * 18;
    }

    @Override
    public int getHeight() {
        return 14 + (int)Math.ceil((double)this.getInvSize() / (double)this.getMaxRowSize()) * 18;
    }

    private void setColor() {
        ColorKey key = this.config.useColors() ? this.provider.getWindowColorKey(this.previewContext) : ColorKey.DEFAULT;
        float[] color = key.rgbComponents();
        RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
    }

    private class_2960 getTexture() {
        if (this.textureOverride != null) {
            return this.textureOverride;
        }
        return DEFAULT_TEXTURE_LIGHT;
    }

    private void drawBackground(int x, int y, class_332 context) {
        int s;
        int size;
        int invSize = this.getInvSize();
        int xOffset = 7;
        int yOffset = 7;
        int rowTexYPos = 7;
        int rowSize = Math.min(this.getMaxRowSize(), invSize);
        int rowWidth = rowSize * 18;
        this.setColor();
        class_2960 texture = this.getTexture();
        for (size = rowSize; size > 0; size -= 9) {
            s = Math.min(size, 9);
            context.method_25291(texture, x + xOffset, y, 0, 7.0f, 0.0f, s * 18, 7, 256, 256);
            xOffset += s * 18;
        }
        while (invSize > 0) {
            xOffset = 7;
            context.method_25291(texture, x, y + yOffset, 0, 0.0f, (float)rowTexYPos, 7, 18, 256, 256);
            for (int rSize = rowSize; rSize > 0; rSize -= 9) {
                s = Math.min(rSize, 9);
                context.method_25291(texture, x + xOffset, y + yOffset, 0, 7.0f, (float)rowTexYPos, s * 18, 18, 256, 256);
                xOffset += s * 18;
            }
            context.method_25291(texture, x + xOffset, y + yOffset, 0, 169.0f, (float)rowTexYPos, 7, 18, 256, 256);
            yOffset += 18;
            invSize -= rowSize;
            rowTexYPos = rowTexYPos >= 43 ? 7 : rowTexYPos + 18;
        }
        xOffset = 7;
        for (size = rowSize; size > 0; size -= 9) {
            s = Math.min(size, 9);
            context.method_25291(texture, x + xOffset, y + yOffset, 0, 7.0f, 61.0f, s * 18, 7, 256, 256);
            xOffset += s * 18;
        }
        context.method_25291(texture, x, y, 0, 0.0f, 0.0f, 7, 7, 256, 256);
        context.method_25291(texture, x + rowWidth + 7, y, 0, 169.0f, 0.0f, 7, 7, 256, 256);
        context.method_25291(texture, x + rowWidth + 7, y + yOffset, 0, 169.0f, 61.0f, 7, 7, 256, 256);
        context.method_25291(texture, x, y + yOffset, 0, 0.0f, 61.0f, 7, 7, 256, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void draw(int x, int y, class_332 context, class_327 textRenderer, int mouseX, int mouseY) {
        if (this.items.isEmpty() || this.previewType == PreviewType.NO_PREVIEW) {
            return;
        }
        RenderSystem.enableDepthTest();
        this.drawBackground(x, y, context);
        this.drawItems(x, y, context, textRenderer);
        this.drawInnerTooltip(x, y, context, textRenderer, mouseX, mouseY);
    }
}

