/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerOptions;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotImageHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import net.minecraft.class_5251;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

final class ScreenshotWidget
extends class_339
implements AutoCloseable,
ScreenshotImageHolder {
    private final ManageScreenshotsScreen mainScreen;
    private final class_310 client;
    private final Context ctx;
    private File screenshotFile;
    private CompletableFuture<class_1011> image;
    @Nullable
    private class_1043 texture;
    private float bgOpacity = 0.0f;
    private int baseY;

    public ScreenshotWidget(ManageScreenshotsScreen mainScreen, int x, int y, int width, int height, Context ctx, File screenshotFile) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)screenshotFile.getName()));
        this.mainScreen = mainScreen;
        this.client = mainScreen.client();
        this.baseY = y;
        this.ctx = ctx;
        this.screenshotFile = screenshotFile;
        this.image = this.getImage(screenshotFile);
    }

    void updateBaseY(int baseY) {
        this.baseY = baseY;
        this.method_46419(this.baseY);
    }

    void updateY(int scrollY) {
        this.method_46419(this.baseY - scrollY);
    }

    void setHeight(int height) {
        this.field_22759 = height;
    }

    void updateScreenshotFile(File screenshotFile) {
        this.screenshotFile = screenshotFile;
        if (this.texture != null) {
            this.texture.close();
        } else if (this.image != null) {
            this.image.thenAcceptAsync(image -> {
                if (image != null) {
                    image.close();
                }
            }, (Executor)this.client);
        }
        this.texture = null;
        this.image = this.getImage(screenshotFile);
    }

    File getScreenshotFile() {
        return this.screenshotFile;
    }

    void updateHoverState(int mouseX, int mouseY, int viewportY, int viewportBottom, boolean updateHoverState) {
        this.field_22762 = updateHoverState && mouseX >= this.method_46426() && mouseY >= Math.max(this.method_46427(), viewportY) && mouseX < this.method_46426() + this.field_22758 && mouseY < Math.min(this.method_46427() + this.field_22759, viewportBottom);
        int maxOpacity = (Integer)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.SCREENSHOT_ELEMENT_BACKGROUND_OPACITY, (Object)100);
        if (maxOpacity > 0 && this.field_22762) {
            if (this.bgOpacity < (float)maxOpacity / 100.0f) {
                this.bgOpacity = Math.min((float)maxOpacity / 100.0f, this.bgOpacity + 0.05f);
            }
        } else if (this.bgOpacity > 0.0f) {
            this.bgOpacity = Math.max(0.0f, this.bgOpacity - 0.05f);
        }
    }

    void render(class_332 context, int mouseX, int mouseY, float delta, int viewportY, int viewportBottom) {
        this.renderBackground(context, mouseX, mouseY, viewportY, viewportBottom);
        int spacing = 2;
        class_1043 image = this.texture();
        if (image != null && image.method_4525() != null) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (int)image.method_4624());
            RenderSystem.enableBlend();
            int renderY = Math.max(this.method_46427() + 2, viewportY);
            int imgHeight = (int)((double)this.field_22759 / 1.08 - 6.0);
            int topOffset = Math.max(0, viewportY - this.method_46427() - 2);
            int bottomOffset = Math.max(0, this.method_46427() + 2 + imgHeight - viewportBottom);
            int topV = topOffset * image.method_4525().method_4323() / imgHeight;
            int bottomV = bottomOffset * image.method_4525().method_4323() / imgHeight;
            ScreenshotWidget.drawTexture(context, this.method_46426() + 2, renderY, this.field_22758 - 4, imgHeight - topOffset - bottomOffset, 0, topV, image.method_4525().method_4307(), image.method_4525().method_4323() - topV - bottomV, image.method_4525().method_4307(), image.method_4525().method_4323());
            RenderSystem.disableBlend();
        }
        float scaleFactor = (float)(this.client.method_22683().method_4502() / 96) / (float)this.ctx.screenshotsPerRow();
        int textY = this.method_46427() + (int)((double)this.field_22759 / 1.08) - 2;
        if (textY > viewportY) {
            float f = textY;
            Objects.requireNonNull(this.client.field_1772);
            if (f + scaleFactor * 9.0f < (float)viewportBottom) {
                class_4587 matrices = context.method_51448();
                matrices.method_22903();
                matrices.method_46416((float)this.method_46426() + (float)this.field_22758 / 2.0f, (float)textY, 0.0f);
                matrices.method_22905(scaleFactor, scaleFactor, scaleFactor);
                class_2561 message = this.method_25369();
                float centerX = -this.client.field_1772.method_27525((class_5348)this.method_25369()) / 2;
                int textColor = ManageScreenshotsScreen.CONFIG.get(ScreenshotViewerOptions.SCREENSHOT_ELEMENT_TEXT_COLOR).map(class_5251::method_27716).orElse(0xFFFFFF);
                context.method_51439(this.client.field_1772, message, (int)centerX, 0, textColor, ((Boolean)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.RENDER_SCREENSHOT_ELEMENT_FONT_SHADOW, (Object)true)).booleanValue());
                matrices.method_22909();
            }
        }
    }

    public static void drawTexture(class_332 context, int x, int y, int width, int height, int u, int v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        int x2 = x + width;
        int y2 = y + height;
        float u1 = (float)u / (float)textureWidth;
        float u2 = ((float)u + (float)regionWidth) / (float)textureWidth;
        float v1 = (float)v / (float)textureHeight;
        float v2 = ((float)v + (float)regionHeight) / (float)textureHeight;
        Matrix4f matrix4f = context.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, (float)x, (float)y, 0.0f).method_22913(u1, v1).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x, (float)y2, 0.0f).method_22913(u1, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, 0.0f).method_22913(u2, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y, 0.0f).method_22913(u2, v1).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void renderBackground(class_332 context, int mouseX, int mouseY, int viewportY, int viewportBottom) {
        int renderY = Math.max(this.method_46427(), viewportY);
        int renderHeight = Math.min(this.method_46427() + this.field_22759, viewportBottom);
        context.method_25294(this.method_46426(), renderY, this.method_46426() + this.field_22758, renderHeight, class_5253.class_5254.method_27764((int)((int)(this.bgOpacity * 255.0f)), (int)255, (int)255, (int)255));
    }

    private void onClick() {
        this.mainScreen.enlargeScreenshot(this);
    }

    private void onRightClick(double mouseX, double mouseY) {
        this.mainScreen.showScreenshotProperties(mouseX, mouseY, this);
    }

    private CompletableFuture<class_1011> getImage(File file) {
        return CompletableFuture.supplyAsync(() -> {
            class_1011 class_10112;
            FileInputStream inputStream = new FileInputStream(file);
            try {
                class_10112 = class_1011.method_4309((InputStream)inputStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    ManageScreenshotsScreen.LOGGER.error("Failed to load screenshot: {}", (Object)file.getName(), (Object)e);
                    return null;
                }
            }
            ((InputStream)inputStream).close();
            return class_10112;
        }, class_156.method_18349());
    }

    @Nullable
    public class_1043 texture() {
        class_1011 nativeImage;
        if (this.texture != null) {
            return this.texture;
        }
        if (this.image == null) {
            this.image = this.getImage(this.screenshotFile);
        }
        if (this.image.isDone() && (nativeImage = this.image.join()) != null) {
            this.texture = new class_1043(nativeImage);
            return this.texture;
        }
        return null;
    }

    @Override
    public int indexInList() {
        return this.ctx.currentIndex(this);
    }

    @Override
    public int imageId() {
        class_1043 texture = this.texture();
        return texture != null ? texture.method_4624() : 0;
    }

    @Override
    @Nullable
    public class_1011 image() {
        if (this.image == null) {
            this.image = this.getImage(this.screenshotFile);
        }
        return this.image.getNow(null);
    }

    public class_2561 method_25369() {
        return this.screenshotFile == null ? super.method_25369() : class_2561.method_43470((String)this.screenshotFile.getName());
    }

    public void method_25354(class_1144 soundManager) {
        soundManager.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_49606()) {
            this.method_25354(this.client.method_1483());
            if (button == 0) {
                this.onClick();
            }
            if (button == 1) {
                this.onRightClick(mouseX, mouseY);
            }
            return true;
        }
        return false;
    }

    protected boolean method_25361(double mouseX, double mouseY) {
        return false;
    }

    public boolean method_49606() {
        return this.field_22762;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.method_49606();
    }

    protected void method_47399(class_6382 builder) {
    }

    @Override
    public void close() {
        if (this.texture != null) {
            this.texture.close();
        } else if (this.image != null) {
            this.image.thenAcceptAsync(image -> {
                if (image != null) {
                    image.close();
                }
            }, (Executor)this.client);
        }
        this.image = null;
        this.texture = null;
    }

    static interface Context {
        public int screenshotsPerRow();

        public int currentIndex(ScreenshotWidget var1);

        public static Context create(final IntSupplier screenshotsPerRow, final ToIntFunction<ScreenshotWidget> currentIndex) {
            return new Context(){

                @Override
                public int screenshotsPerRow() {
                    return screenshotsPerRow.getAsInt();
                }

                @Override
                public int currentIndex(ScreenshotWidget widget) {
                    return currentIndex.applyAsInt(widget);
                }
            };
        }
    }
}

