/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import io.github.lgatodu47.catconfig.CatConfig;
import io.github.lgatodu47.catconfigmc.screen.ConfigListener;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewer;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerOptions;
import io.github.lgatodu47.screenshot_viewer.screen.ScreenshotViewerConfigScreen;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.EnlargedScreenshotScreen;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotList;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotPropertiesMenu;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotWidget;
import java.io.File;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import net.minecraft.class_8000;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ManageScreenshotsScreen
extends class_437
implements ConfigListener {
    static final CatConfig CONFIG = ScreenshotViewer.getInstance().getConfig();
    static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960 CONFIG_BUTTON_TEXTURE = new class_2960("screenshot_viewer", "textures/gui/config_button.png");
    private static final class_2960 REFRESH_BUTTON_TEXTURE = new class_2960("screenshot_viewer", "textures/gui/refresh_button.png");
    private static final class_2960 ASCENDING_ORDER_BUTTON_TEXTURE = new class_2960("screenshot_viewer", "textures/gui/ascending_order_button.png");
    private static final class_2960 DESCENDING_ORDER_BUTTON_TEXTURE = new class_2960("screenshot_viewer", "textures/gui/descending_order_button.png");
    private static final class_2960 OPEN_FOLDER_BUTTON_TEXTURE = new class_2960("screenshot_viewer", "textures/gui/open_folder_button.png");
    private final class_437 parent;
    private final EnlargedScreenshotScreen enlargedScreenshot;
    private final ScreenshotPropertiesMenu screenshotProperties;
    private ScreenshotList list;
    @Nullable
    private File enlargedScreenshotFile;
    private float screenshotScaleAnimation;
    private boolean isCtrlDown;

    public ManageScreenshotsScreen(class_437 parent) {
        super(ScreenshotViewer.translatable("screen", "manage_screenshots"));
        this.parent = parent;
        this.enlargedScreenshot = new EnlargedScreenshotScreen();
        this.screenshotProperties = new ScreenshotPropertiesMenu(this::client, () -> this.field_22789, () -> this.field_22790);
    }

    public ManageScreenshotsScreen(class_437 parent, @Nullable File enlargedScreenshotFile) {
        this(parent);
        this.enlargedScreenshotFile = enlargedScreenshotFile;
    }

    class_310 client() {
        return this.field_22787;
    }

    public void method_25393() {
        if (this.screenshotProperties != null) {
            this.screenshotProperties.tick();
        }
    }

    protected void method_25426() {
        if (this.field_22787 == null) {
            return;
        }
        int spacing = 8;
        int btnHeight = 20;
        this.enlargedScreenshot.method_25423(this.field_22787, this.field_22789, this.field_22790);
        int contentWidth = this.field_22789 - 24;
        int contentHeight = this.field_22790 - 40 - 20;
        if (this.list == null) {
            this.list = new ScreenshotList(this, 12, 24, this.field_22789 - 24, this.field_22790 - 40 - 20);
            this.list.init();
        } else {
            this.list.updateSize(contentWidth, contentHeight);
            this.list.updateChildren();
        }
        this.method_25429((class_364)this.list);
        int btnY = this.field_22790 - 8 - 20;
        int btnSize = 20;
        int bigBtnWidth = 200;
        this.method_37063((class_364)new ExtendedTexturedButtonWidget(2, 2, 20, 20, 0, 0, 20, CONFIG_BUTTON_TEXTURE, 32, 64, button -> this.field_22787.method_1507((class_437)new ScreenshotViewerConfigScreen(this)), ScreenshotViewer.translatable("screen", "button.config"), ScreenshotViewer.translatable("screen", "button.config")).offsetTooltip());
        this.method_37063((class_364)new ExtendedTexturedButtonWidget(8, btnY, 20, 20, 0, 0, 20, null, 32, 64, button -> {
            if (this.list != null) {
                this.list.invertOrder();
            }
        }, null, ScreenshotViewer.translatable("screen", "button.order")){

            @Override
            @Nullable
            protected class_2561 getTooltipText() {
                return ManageScreenshotsScreen.this.list == null ? null : ScreenshotViewer.translatable("screen", ManageScreenshotsScreen.this.list.isInvertedOrder() ? "button.order.descending" : "button.order.ascending");
            }

            @Override
            @Nullable
            public class_2960 getTexture() {
                return ManageScreenshotsScreen.this.list == null ? null : (ManageScreenshotsScreen.this.list.isInvertedOrder() ? DESCENDING_ORDER_BUTTON_TEXTURE : ASCENDING_ORDER_BUTTON_TEXTURE);
            }
        });
        this.method_37063((class_364)new ExtendedTexturedButtonWidget(36, btnY, 20, 20, 0, 0, 20, OPEN_FOLDER_BUTTON_TEXTURE, 32, 64, btn -> class_156.method_668().method_672((File)CONFIG.getOrFallback(ScreenshotViewerOptions.SCREENSHOTS_FOLDER, ScreenshotViewer::getVanillaScreenshotsFolder)), ScreenshotViewer.translatable("screen", "button.screenshot_folder"), ScreenshotViewer.translatable("screen", "button.screenshot_folder")));
        this.method_37063((class_364)new ExtendedButtonWidget((this.field_22789 - 200) / 2, btnY, 200, 20, class_5244.field_24334, button -> this.method_25419()));
        this.method_37063((class_364)new ExtendedTexturedButtonWidget(this.field_22789 - 8 - 20, btnY, 20, 20, 0, 0, 20, REFRESH_BUTTON_TEXTURE, 32, 64, button -> this.list.init(), ScreenshotViewer.translatable("screen", "button.refresh"), ScreenshotViewer.translatable("screen", "button.refresh")));
        if (this.enlargedScreenshotFile != null) {
            this.list.findByFileName(this.enlargedScreenshotFile).ifPresentOrElse(this::enlargeScreenshot, () -> LOGGER.warn("Tried to enlarge screenshot with a path '{}' that could not be located in the screenshots folder!", (Object)this.enlargedScreenshotFile.getAbsolutePath()));
            this.enlargedScreenshotFile = null;
        }
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.enlargedScreenshot.method_25410(client, width, height);
        this.screenshotProperties.hide();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        if (this.list != null) {
            this.list.render(context, mouseX, mouseY, delta, !this.enlargedScreenshot.renders() && !this.screenshotProperties.renders());
        }
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        class_2561 text = ScreenshotViewer.translatable("screen", "screenshot_manager.zoom");
        context.method_27535(this.field_22793, text, this.field_22789 - this.field_22793.method_27525((class_5348)text) - 8, 8, this.isCtrlDown ? 1629753 : 15780386);
        super.method_25394(context, mouseX, mouseY, delta);
        this.screenshotProperties.method_25394(context, mouseX, mouseY, delta);
        if (this.enlargedScreenshot.renders()) {
            float animationTime = 1.0f;
            if (((Boolean)CONFIG.getOrFallback(ScreenshotViewerOptions.ENABLE_SCREENSHOT_ENLARGEMENT_ANIMATION, (Object)true)).booleanValue() && this.screenshotScaleAnimation < 1.0f) {
                animationTime = (float)(1.0 - Math.pow(1.0f - (this.screenshotScaleAnimation += 0.03f), 3.0));
            }
            class_4587 matrices = context.method_51448();
            matrices.method_22903();
            matrices.method_46416(0.0f, 0.0f, 1.0f);
            this.enlargedScreenshot.method_25420(context);
            matrices.method_46416((float)this.enlargedScreenshot.field_22789 / 2.0f * (1.0f - animationTime), (float)this.enlargedScreenshot.field_22790 / 2.0f * (1.0f - animationTime), 0.0f);
            matrices.method_22905(animationTime, animationTime, animationTime);
            this.enlargedScreenshot.method_25394(context, mouseX, mouseY, delta);
            matrices.method_22909();
        } else {
            if (this.screenshotScaleAnimation > 0.0f) {
                this.screenshotScaleAnimation = 0.0f;
            }
            if (!this.screenshotProperties.renders()) {
                for (class_364 element : this.method_25396()) {
                    if (!(element instanceof CustomHoverState)) continue;
                    CustomHoverState hover = (CustomHoverState)element;
                    hover.updateHoveredState(mouseX, mouseY);
                }
            }
        }
    }

    void enlargeScreenshot(ScreenshotImageHolder showing) {
        this.enlargedScreenshot.show(showing, this.list);
    }

    void showScreenshotProperties(double mouseX, double mouseY, ScreenshotWidget widget) {
        this.screenshotProperties.show((int)mouseX, (int)mouseY, () -> this.list.removeEntry(widget), widget.getScreenshotFile(), widget::updateScreenshotFile);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25404(keyCode, scanCode, modifiers);
        }
        this.isCtrlDown = keyCode == 341 || keyCode == 345;
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_16803(keyCode, scanCode, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_16803(keyCode, scanCode, modifiers);
        }
        if (this.isCtrlDown) {
            this.isCtrlDown = false;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25400(chr, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25400(chr, modifiers);
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25401(mouseX, mouseY, amount);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25401(mouseX, mouseY, amount);
        }
        if (this.list != null) {
            if (this.isCtrlDown) {
                this.list.updateScreenshotsPerRow(amount);
                return true;
            }
            return this.list.method_25401(mouseX, mouseY, amount);
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25402(mouseX, mouseY, button);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25406(mouseX, mouseY, button);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25406(mouseX, mouseY, button);
        }
        if (this.list != null) {
            return this.list.method_25406(mouseX, mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public Optional<class_364> method_19355(double mouseX, double mouseY) {
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_19355(mouseX, mouseY);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_19355(mouseX, mouseY);
        }
        return super.method_19355(mouseX, mouseY);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void method_25432() {
        this.list.close();
    }

    public void configUpdated() {
        this.list.onConfigUpdate();
    }

    private static class ExtendedTexturedButtonWidget
    extends class_344
    implements CustomHoverState {
        @Nullable
        private final class_2960 texture;
        private final int u;
        private final int v;
        private final int hoveredVOffset;
        private final int textureWidth;
        private final int textureHeight;
        @Nullable
        private final class_2561 tooltip;
        private boolean offsetTooltip;

        ExtendedTexturedButtonWidget(int x, int y, int width, int height, int u, int v, int hoveredVOffset, @Nullable class_2960 texture, int textureWidth, int textureHeight, class_4185.class_4241 pressAction, @Nullable class_2561 tooltip, class_2561 text) {
            super(x, y, width, height, u, v, hoveredVOffset, class_4185.field_22757, textureWidth, textureHeight, pressAction, text);
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.u = u;
            this.v = v;
            this.hoveredVOffset = hoveredVOffset;
            this.texture = texture;
            this.tooltip = tooltip;
            if (tooltip != null) {
                this.method_47400(class_7919.method_47407((class_2561)tooltip));
            }
        }

        ExtendedTexturedButtonWidget offsetTooltip() {
            this.offsetTooltip = true;
            return this;
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            if (!this.field_22764) {
                return;
            }
            this.method_48579(context, mouseX, mouseY, delta);
            this.applyTooltip();
        }

        private void applyTooltip() {
            class_437 screen;
            class_2561 tooltipText = this.getTooltipText();
            if (tooltipText != null && this.method_49606() && (screen = class_310.method_1551().field_1755) != null) {
                screen.method_47412(class_7919.method_47407((class_2561)tooltipText), this.method_47937(), this.method_25370());
            }
        }

        @Nullable
        protected class_2561 getTooltipText() {
            return this.tooltip;
        }

        protected class_8000 method_47937() {
            return this.offsetTooltip ? (screen_width, screen_height, x, y, w, h) -> super.method_47937().method_47944(screen_width, screen_height, x, y + this.field_22759, w, h) : super.method_47937();
        }

        @Nullable
        public class_2960 getTexture() {
            return this.texture;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            class_2960 texture = this.getTexture();
            if (texture == null) {
                context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0xFFFFFF);
            } else {
                int vOffset = this.v;
                if (!this.method_37303()) {
                    vOffset += this.hoveredVOffset * 2;
                } else if (this.method_49606()) {
                    vOffset += this.hoveredVOffset;
                }
                RenderSystem.enableDepthTest();
                context.method_25290(texture, this.method_46426(), this.method_46427(), (float)this.u, (float)vOffset, this.field_22758, this.field_22759, this.textureWidth, this.textureHeight);
            }
        }

        @Override
        public void updateHoveredState(int mouseX, int mouseY) {
            this.field_22762 = mouseX >= this.method_46426() && mouseY >= this.method_46427() && mouseX < this.method_46426() + this.field_22758 && mouseY < this.method_46427() + this.field_22759;
        }
    }

    private static final class ExtendedButtonWidget
    extends class_4185
    implements CustomHoverState {
        ExtendedButtonWidget(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress) {
            super(x, y, width, height, message, onPress, Supplier::get);
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            if (!this.field_22764) {
                return;
            }
            this.method_48579(context, mouseX, mouseY, delta);
        }

        @Override
        public void updateHoveredState(int mouseX, int mouseY) {
            this.field_22762 = mouseX >= this.method_46426() && mouseY >= this.method_46427() && mouseX < this.method_46426() + this.field_22758 && mouseY < this.method_46427() + this.field_22759;
        }
    }

    private static interface CustomHoverState {
        public void updateHoveredState(int var1, int var2);
    }
}

