/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.player;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.event.EventBus;
import net.luckperms.api.event.EventSubscription;
import net.luckperms.api.event.node.NodeAddEvent;
import net.luckperms.api.event.node.NodeClearEvent;
import net.luckperms.api.event.node.NodeMutateEvent;
import net.luckperms.api.event.node.NodeRemoveEvent;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.event.Event;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.event.player.PlayerPermissionUpdateEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0006\u0010!\u001a\u00020\u0011J\u0006\u0010\"\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lsu/plo/voice/server/player/LuckPermsListener;", "", "voiceServer", "Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;Ljava/util/concurrent/ScheduledExecutorService;)V", "luckPerms", "Lnet/luckperms/api/LuckPerms;", "permissionChanges", "", "", "Ljava/util/concurrent/ScheduledFuture;", "subscriptions", "", "Lnet/luckperms/api/event/EventSubscription;", "onLpPermissionChange", "", "player", "Lsu/plo/voice/api/server/player/VoicePlayer;", "permission", "onNodeAdd", "event", "Lnet/luckperms/api/event/node/NodeAddEvent;", "onNodeClear", "Lnet/luckperms/api/event/node/NodeClearEvent;", "onNodeMutate", "Lnet/luckperms/api/event/node/NodeMutateEvent;", "node", "Lnet/luckperms/api/node/Node;", "onNodeRemove", "Lnet/luckperms/api/event/node/NodeRemoveEvent;", "onPermissionChange", "subscribe", "unsubscribe", "Companion", "server-common"})
public final class LuckPermsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlasmoBaseVoiceServer voiceServer;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final LuckPerms luckPerms;
    @NotNull
    private final List<EventSubscription<?>> subscriptions;
    @NotNull
    private final Map<String, ScheduledFuture<?>> permissionChanges;

    public LuckPermsListener(@NotNull PlasmoBaseVoiceServer voiceServer, @NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(executor, "executor");
        this.voiceServer = voiceServer;
        this.executor = executor;
        Object object = LuckPermsProvider.get();
        Intrinsics.checkNotNullExpressionValue(object, "get()");
        this.luckPerms = object;
        this.subscriptions = new ArrayList();
        object = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue(object, "newHashMap()");
        this.permissionChanges = (Map)object;
    }

    public final void subscribe() {
        EventBus eventBus = this.luckPerms.getEventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "luckPerms.eventBus");
        EventBus luckPermsBus = eventBus;
        eventBus = luckPermsBus.subscribe(NodeAddEvent.class, this::onNodeAdd);
        Intrinsics.checkNotNullExpressionValue(eventBus, "luckPermsBus.subscribe(\n\u2026    ::onNodeAdd\n        )");
        this.subscriptions.add((EventSubscription<?>)eventBus);
        eventBus = luckPermsBus.subscribe(NodeRemoveEvent.class, this::onNodeRemove);
        Intrinsics.checkNotNullExpressionValue(eventBus, "luckPermsBus.subscribe(\n\u2026 ::onNodeRemove\n        )");
        this.subscriptions.add((EventSubscription<?>)eventBus);
        eventBus = luckPermsBus.subscribe(NodeClearEvent.class, this::onNodeClear);
        Intrinsics.checkNotNullExpressionValue(eventBus, "luckPermsBus.subscribe(\n\u2026  ::onNodeClear\n        )");
        this.subscriptions.add((EventSubscription<?>)eventBus);
    }

    public final void unsubscribe() {
        Iterable $this$forEach$iv = this.subscriptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventSubscription it = (EventSubscription)element$iv;
            boolean bl = false;
            it.close();
        }
    }

    private final void onNodeAdd(NodeAddEvent event) {
        NodeMutateEvent nodeMutateEvent = (NodeMutateEvent)event;
        Node node = event.getNode();
        Intrinsics.checkNotNullExpressionValue(node, "event.node");
        this.onNodeMutate(nodeMutateEvent, node);
    }

    private final void onNodeRemove(NodeRemoveEvent event) {
        NodeMutateEvent nodeMutateEvent = (NodeMutateEvent)event;
        Node node = event.getNode();
        Intrinsics.checkNotNullExpressionValue(node, "event.node");
        this.onNodeMutate(nodeMutateEvent, node);
    }

    private final void onNodeClear(NodeClearEvent event) {
        Set set = event.getNodes();
        Intrinsics.checkNotNullExpressionValue(set, "event.nodes");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            NodeMutateEvent nodeMutateEvent = (NodeMutateEvent)event;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.onNodeMutate(nodeMutateEvent, it);
        }
    }

    private final void onNodeMutate(NodeMutateEvent event, Node node) {
        if (event.isUser()) {
            User user = (User)event.getTarget();
            VoicePlayer voicePlayer = this.voiceServer.getPlayerManager().getPlayerById(user.getUniqueId(), false).orElse(null);
            if (voicePlayer == null) {
                return;
            }
            VoicePlayer player = voicePlayer;
            if (!player.hasVoiceChat()) {
                return;
            }
            String string = node.getKey();
            Intrinsics.checkNotNullExpressionValue(string, "node.key");
            this.onLpPermissionChange(player, string);
        } else if (event.isGroup()) {
            Group group = (Group)event.getTarget();
            Collection<?> player = this.voiceServer.getPlayerManager().getPlayers();
            Intrinsics.checkNotNullExpressionValue(player, "voiceServer.playerManager.players");
            Iterable $this$forEach$iv = player;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VoicePlayer player2 = (VoicePlayer)element$iv;
                boolean bl = false;
                if (!player2.getInstance().hasPermission(Intrinsics.stringPlus("group.", group.getName()))) continue;
                Intrinsics.checkNotNullExpressionValue(player2, "player");
                String string = node.getKey();
                Intrinsics.checkNotNullExpressionValue(string, "node.key");
                this.onLpPermissionChange(player2, string);
            }
        }
    }

    private final synchronized void onLpPermissionChange(VoicePlayer player, String permission) {
        ScheduledFuture<?> future;
        String playerPermissionKey = player.getInstance().getUUID().toString() + '_' + permission;
        ScheduledFuture<?> scheduledFuture = future = this.permissionChanges.get(playerPermissionKey);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        String string = player.getInstance().getUUID().toString() + '_' + permission;
        ScheduledFuture<?> scheduledFuture2 = this.executor.schedule(() -> LuckPermsListener.onLpPermissionChange$lambda-3(this, player, permission), 100L, TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture2, "executor.schedule(\n     \u2026it.MILLISECONDS\n        )");
        this.permissionChanges.put(string, scheduledFuture2);
    }

    private final void onPermissionChange(VoicePlayer player, String permission) {
        this.voiceServer.getEventBus().call((Event)new PlayerPermissionUpdateEvent(player, permission));
        this.permissionChanges.remove(player.getInstance().getUUID().toString() + '_' + permission);
    }

    private static final void onLpPermissionChange$lambda-3(LuckPermsListener this$0, VoicePlayer $player, String $permission) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($permission, "$permission");
        this$0.onPermissionChange($player, $permission);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lsu/plo/voice/server/player/LuckPermsListener$Companion;", "", "()V", "hasLuckPerms", "", "server-common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean hasLuckPerms() {
            boolean bl;
            try {
                Class.forName("net.luckperms.api.LuckPermsProvider");
                bl = true;
            }
            catch (Exception _) {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

