/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.connection;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.server.BaseVoiceServer;

public abstract class BaseServerServiceChannelHandler {
    protected final BaseVoiceServer voiceServer;

    protected void handlePacket(@NotNull VoiceServerPlayer player, byte[] data) throws IOException {
        if (this.voiceServer.getConfig().host().forwardingSecret() == null) {
            return;
        }
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])data);
        byte[] signature = PacketUtil.readBytes(input, 32);
        try {
            byte[] aesEncryptionKey = PacketUtil.readBytes(input, 64);
            SecretKeySpec key = new SecretKeySpec(PacketUtil.getUUIDBytes(this.voiceServer.getConfig().host().forwardingSecret()), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(key);
            mac.update(aesEncryptionKey, 0, aesEncryptionKey.length);
            if (!MessageDigest.isEqual(signature, mac.doFinal())) {
                BaseVoice.LOGGER.warn("Received invalid AES key signature from player " + player.getInstance().getUUID());
                return;
            }
            this.voiceServer.updateAesEncryptionKey(aesEncryptionKey);
            ByteArrayDataOutput output = ByteStreams.newDataOutput();
            PacketUtil.writeBytes(output, signature);
            player.getInstance().sendPacket("plasmo:voice/v2/service", output.toByteArray());
            BaseVoice.DEBUG_LOGGER.log("Received AES key from proxy server", new Object[0]);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
    }

    public BaseServerServiceChannelHandler(BaseVoiceServer voiceServer) {
        this.voiceServer = voiceServer;
    }
}

