/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.command;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.server.command.MinecraftCommand;
import su.plo.lib.api.server.command.MinecraftCommandSource;
import su.plo.lib.api.server.entity.MinecraftServerPlayerEntity;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.server.BaseVoiceServer;

public final class VoiceReconnectCommand
implements MinecraftCommand {
    private final BaseVoiceServer voiceServer;

    @Override
    public void execute(@NotNull MinecraftCommandSource source, @NotNull String[] arguments) {
        if (!(source instanceof MinecraftServerPlayerEntity)) {
            source.sendMessage(MinecraftTextComponent.translatable("pv.error.player_only_command", new Object[0]));
            return;
        }
        MinecraftServerPlayerEntity player = (MinecraftServerPlayerEntity)source;
        VoiceServerPlayer voicePlayer = (VoiceServerPlayer)this.voiceServer.getPlayerManager().getPlayerById(player.getUUID()).orElseThrow(() -> new IllegalStateException("how?"));
        source.sendMessage(MinecraftTextComponent.translatable("pv.command.reconnect.message", new Object[0]));
        this.voiceServer.getUdpConnectionManager().removeConnection(voicePlayer);
        this.voiceServer.getTcpConnectionManager().requestPlayerInfo(voicePlayer);
    }

    @Override
    public boolean hasPermission(@NotNull MinecraftCommandSource source, @Nullable String[] arguments) {
        return source.hasPermission("pv.reconnect");
    }

    public VoiceReconnectCommand(BaseVoiceServer voiceServer) {
        this.voiceServer = voiceServer;
    }
}

