/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.command;

import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.server.command.MinecraftCommand;
import su.plo.lib.api.server.command.MinecraftCommandSource;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.server.BaseVoiceServer;

public final class VoiceListCommand
implements MinecraftCommand {
    private final BaseVoiceServer voiceServer;

    @Override
    public void execute(@NotNull MinecraftCommandSource source, @NotNull String[] arguments) {
        List players = this.voiceServer.getPlayerManager().getPlayers().stream().filter(VoicePlayer::hasVoiceChat).map(player -> player.getInstance().getName()).sorted().collect(Collectors.toList());
        source.sendMessage(MinecraftTextComponent.translatable("pv.command.list.message", players.size(), this.voiceServer.getPlayerManager().getPlayers().size(), players.size() > 0 ? String.join((CharSequence)", ", players) : MinecraftTextComponent.translatable("pv.command.list.empty", new Object[0])));
    }

    @Override
    public boolean hasPermission(@NotNull MinecraftCommandSource source, @Nullable String[] arguments) {
        return source.hasPermission("pv.list");
    }

    public VoiceListCommand(BaseVoiceServer voiceServer) {
        this.voiceServer = voiceServer;
    }
}

