/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.source;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.audio.line.BaseServerSourceLine;
import su.plo.voice.api.server.audio.source.ServerAudioSource;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;

public abstract class BaseServerAudioSource<S extends SourceInfo>
implements ServerAudioSource<S> {
    protected final AddonContainer addon;
    protected final UUID id;
    @Nullable
    protected final CodecInfo decoderInfo;
    protected final BaseServerSourceLine line;
    @Nullable
    protected String name;
    protected boolean iconVisible = true;
    protected int angle;
    protected boolean stereo;
    protected final AtomicBoolean dirty = new AtomicBoolean(true);
    protected final AtomicInteger state = new AtomicInteger(1);
    protected final List<Predicate<VoicePlayer>> filters = new CopyOnWriteArrayList<Predicate<VoicePlayer>>();

    protected BaseServerAudioSource(@NotNull AddonContainer addon, @NotNull UUID id, @NotNull BaseServerSourceLine line, @Nullable CodecInfo decoderInfo, boolean stereo) {
        this.addon = addon;
        this.id = id;
        this.line = line;
        this.decoderInfo = decoderInfo;
        this.stereo = stereo;
    }

    @Override
    public int getState() {
        return this.state.get();
    }

    @Override
    public synchronized void setStereo(boolean stereo) {
        if (this.stereo != stereo) {
            this.stereo = stereo;
            this.setDirty();
            this.increaseSourceState();
        }
    }

    @Override
    public synchronized void setIconVisible(boolean visible) {
        if (this.iconVisible != visible) {
            this.iconVisible = visible;
            this.setDirty();
            this.increaseSourceState();
        }
    }

    @Override
    public void setName(@Nullable String name) {
        if (!Objects.equals(this.name, name)) {
            this.name = name;
            this.setDirty();
            this.increaseSourceState();
        }
    }

    @Override
    public void addFilter(Predicate<VoicePlayer> filter2) {
        if (this.filters.contains(filter2)) {
            throw new IllegalArgumentException("Filter already exist");
        }
        this.filters.add(filter2);
    }

    @Override
    public void removeFilter(Predicate<VoicePlayer> filter2) {
        this.filters.remove(filter2);
    }

    @Override
    @NotNull
    public Collection<Predicate<VoicePlayer>> getFilters() {
        return this.filters;
    }

    @Override
    public void clearFilters() {
        this.filters.clear();
    }

    @Override
    public void setDirty() {
        this.dirty.set(true);
    }

    @Override
    public boolean matchFilters(@NotNull VoicePlayer player) {
        for (Predicate<VoicePlayer> filter2 : this.filters) {
            if (filter2.test(player)) continue;
            return false;
        }
        return true;
    }

    protected void increaseSourceState() {
        this.state.updateAndGet(operand -> {
            int value = operand + 1;
            return value > 127 ? -128 : value;
        });
    }

    @Override
    public AddonContainer getAddon() {
        return this.addon;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public BaseServerSourceLine getLine() {
        return this.line;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isIconVisible() {
        return this.iconVisible;
    }

    @Override
    public void setAngle(int angle) {
        this.angle = angle;
    }
}

