/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.capture;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.server.player.MinecraftServerPlayer;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.audio.capture.ServerActivation;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;
import su.plo.voice.proto.data.audio.codec.CodecInfo;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u0002B}\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0010\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\u0006\u0010\u0015\u001a\u00020\r\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0006H\u0016J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\rH\u0016J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020'H\u0016J\u0013\u0010/\u001a\u00020\u00102\b\u00100\u001a\u0004\u0018\u000101H\u0096\u0002J\b\u00102\u001a\u00020\u0004H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000603H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001704H\u0016J\b\u00105\u001a\u00020\rH\u0016J\u0010\u00106\u001a\u00020'2\u0006\u00107\u001a\u00020\u001eH\u0016J\u0010\u00108\u001a\u00020'2\u0006\u00109\u001a\u00020\u001aH\u0016J\u0010\u0010:\u001a\u00020'2\u0006\u0010;\u001a\u00020!H\u0016J\u0010\u0010<\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0006H\u0016J\u0016\u0010=\u001a\u00020'2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010>\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010?\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001cR\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006@"}, d2={"Lsu/plo/voice/server/audio/capture/VoiceServerActivation;", "Lsu/plo/voice/proto/data/audio/capture/VoiceActivation;", "Lsu/plo/voice/api/server/audio/capture/ServerActivation;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "name", "", "translation", "icon", "permissions", "", "distances", "", "", "defaultDistance", "proximity", "", "transitive", "stereoSupported", "encoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "weight", "requirements", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$Requirements;", "(Lsu/plo/voice/api/addon/AddonContainer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/util/List;IZZZLsu/plo/voice/proto/data/audio/codec/CodecInfo;ILsu/plo/voice/api/server/audio/capture/ServerActivation$Requirements;)V", "activationEndListeners", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$PlayerActivationEndListener;", "getActivationEndListeners", "()Ljava/util/Set;", "activationListeners", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$PlayerActivationListener;", "getActivationListeners", "activationStartListeners", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$PlayerActivationStartListener;", "getActivationStartListeners", "getPermissions", "getRequirements", "()Lsu/plo/voice/api/server/audio/capture/ServerActivation$Requirements;", "addPermission", "", "permission", "checkDistance", "distance", "checkPermissions", "serverPlayer", "Lsu/plo/lib/api/server/player/MinecraftServerPlayer;", "clearPermissions", "equals", "o", "", "getAddon", "", "Ljava/util/Optional;", "hashCode", "onPlayerActivation", "activationListener", "onPlayerActivationEnd", "activationEndListener", "onPlayerActivationStart", "activationStartListener", "removePermission", "setDistances", "setProximity", "setTransitive", "server-common"})
public final class VoiceServerActivation
extends VoiceActivation
implements ServerActivation {
    @NotNull
    private final AddonContainer addon;
    @Nullable
    private final ServerActivation.Requirements requirements;
    @NotNull
    private final Set<String> permissions;
    @NotNull
    private final Set<ServerActivation.PlayerActivationListener> activationListeners;
    @NotNull
    private final Set<ServerActivation.PlayerActivationStartListener> activationStartListeners;
    @NotNull
    private final Set<ServerActivation.PlayerActivationEndListener> activationEndListeners;

    public VoiceServerActivation(@NotNull AddonContainer addon, @NotNull String name, @NotNull String translation, @NotNull String icon, @NotNull Set<String> permissions, @NotNull List<Integer> distances, int defaultDistance, boolean proximity, boolean transitive, boolean stereoSupported, @Nullable CodecInfo encoderInfo, int weight, @Nullable ServerActivation.Requirements requirements) {
        Intrinsics.checkNotNullParameter(addon, "addon");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(translation, "translation");
        Intrinsics.checkNotNullParameter(icon, "icon");
        Intrinsics.checkNotNullParameter(permissions, "permissions");
        Intrinsics.checkNotNullParameter(distances, "distances");
        super(name, translation, icon, distances, defaultDistance, proximity, stereoSupported, transitive, encoderInfo, weight);
        this.addon = addon;
        this.requirements = requirements;
        Set set = Sets.newConcurrentHashSet();
        Intrinsics.checkNotNullExpressionValue(set, "newConcurrentHashSet()");
        this.activationListeners = set;
        set = Sets.newConcurrentHashSet();
        Intrinsics.checkNotNullExpressionValue(set, "newConcurrentHashSet()");
        this.activationStartListeners = set;
        set = Sets.newConcurrentHashSet();
        Intrinsics.checkNotNullExpressionValue(set, "newConcurrentHashSet()");
        this.activationEndListeners = set;
        this.transitive = transitive;
        this.permissions = permissions;
    }

    @Nullable
    public final ServerActivation.Requirements getRequirements() {
        return this.requirements;
    }

    @NotNull
    public final Set<String> getPermissions() {
        return this.permissions;
    }

    @NotNull
    public final Set<ServerActivation.PlayerActivationListener> getActivationListeners() {
        return this.activationListeners;
    }

    @NotNull
    public final Set<ServerActivation.PlayerActivationStartListener> getActivationStartListeners() {
        return this.activationStartListeners;
    }

    @NotNull
    public final Set<ServerActivation.PlayerActivationEndListener> getActivationEndListeners() {
        return this.activationEndListeners;
    }

    @Override
    public void addPermission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter(permission, "permission");
        this.permissions.add(permission);
    }

    @Override
    public void removePermission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter(permission, "permission");
        this.permissions.remove(permission);
    }

    @Override
    public void clearPermissions() {
        this.permissions.clear();
    }

    @Override
    public boolean checkPermissions(@NotNull MinecraftServerPlayer serverPlayer) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(serverPlayer, "serverPlayer");
            Iterable $this$any$iv = this.permissions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!serverPlayer.hasPermission(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void setDistances(@NotNull List<Integer> distances) {
        Intrinsics.checkNotNullParameter(distances, "distances");
        this.distances = (List)Preconditions.checkNotNull(distances);
    }

    @Override
    public boolean checkDistance(int distance) {
        if (this.distances.size() == 0) {
            return true;
        }
        if (this.distances.size() == 2) {
            Integer n = (Integer)this.distances.get(0);
            int n2 = -1;
            if (n != null && n == n2) {
                boolean bl;
                if (1 <= distance) {
                    Object e = this.distances.get(1);
                    Intrinsics.checkNotNullExpressionValue(e, "distances[1]");
                    bl = distance <= ((Number)e).intValue();
                } else {
                    bl = false;
                }
                return bl;
            }
        }
        return this.distances.contains(distance);
    }

    @Override
    public void setTransitive(boolean transitive) {
        this.transitive = transitive;
    }

    @Override
    public void setProximity(boolean proximity) {
        this.proximity = proximity;
    }

    @Override
    @NotNull
    public AddonContainer getAddon() {
        return this.addon;
    }

    @Override
    @NotNull
    public Optional<ServerActivation.Requirements> getRequirements() {
        Optional<ServerActivation.Requirements> optional = Optional.ofNullable(this.requirements);
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(requirements)");
        return optional;
    }

    @Override
    @NotNull
    public Collection<String> getPermissions() {
        return this.permissions;
    }

    @Override
    public void onPlayerActivation(@NotNull ServerActivation.PlayerActivationListener activationListener) {
        Intrinsics.checkNotNullParameter(activationListener, "activationListener");
        this.activationListeners.add(activationListener);
    }

    @Override
    public void onPlayerActivationStart(@NotNull ServerActivation.PlayerActivationStartListener activationStartListener) {
        Intrinsics.checkNotNullParameter(activationStartListener, "activationStartListener");
        this.activationStartListeners.add(activationStartListener);
    }

    @Override
    public void onPlayerActivationEnd(@NotNull ServerActivation.PlayerActivationEndListener activationEndListener) {
        Intrinsics.checkNotNullParameter(activationEndListener, "activationEndListener");
        this.activationEndListeners.add(activationEndListener);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return o == this || super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

