/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.udp;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketRegistry;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.udp.PacketUdp;
import su.plo.voice.proto.packets.udp.bothbound.CustomPacket;
import su.plo.voice.proto.packets.udp.bothbound.PingPacket;
import su.plo.voice.proto.packets.udp.clientbound.SelfAudioInfoPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.proto.packets.udp.serverbound.PlayerAudioPacket;

public class PacketUdpCodec {
    private static final int MAGIC_NUMBER = 1318061289;
    private static final PacketRegistry PACKETS = new PacketRegistry();

    public static byte[] replaceSecret(byte[] data, UUID secret) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        PacketUtil.writeUUID(out, secret);
        System.arraycopy(out.toByteArray(), 0, data, 5, 16);
        return data;
    }

    public static byte[] encode(Packet<?> packet, UUID secret) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        int type = PACKETS.getType(packet);
        if (type < 0) {
            return null;
        }
        out.writeInt(1318061289);
        out.writeByte(type);
        PacketUtil.writeUUID(out, secret);
        out.writeLong(System.currentTimeMillis());
        try {
            packet.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    public static Optional<PacketUdp> decode(ByteArrayDataInput in) throws IOException {
        if (in.readInt() != 1318061289) {
            return Optional.empty();
        }
        Packet<?> packet = PACKETS.byType(in.readByte());
        if (packet != null) {
            UUID secret = PacketUtil.readUUID(in);
            long timestamp = in.readLong();
            return Optional.of(new PacketUdp(secret, timestamp, packet, in));
        }
        return Optional.empty();
    }

    private PacketUdpCodec() {
    }

    static {
        int lastPacketId = 0;
        PACKETS.register(++lastPacketId, PingPacket.class);
        PACKETS.register(++lastPacketId, PlayerAudioPacket.class);
        PACKETS.register(++lastPacketId, SourceAudioPacket.class);
        PACKETS.register(++lastPacketId, SelfAudioInfoPacket.class);
        PACKETS.register(256, CustomPacket.class);
    }
}

