/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render.voice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_640;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.chat.MinecraftLiteralText;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.texture.ModPlayerSkins;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.api.client.audio.line.ClientSourceLine;
import su.plo.voice.api.client.audio.source.ClientAudioSource;
import su.plo.voice.api.client.audio.source.ClientSelfSourceInfo;
import su.plo.voice.api.client.config.overlay.OverlayPosition;
import su.plo.voice.api.client.config.overlay.OverlaySourceState;
import su.plo.voice.api.client.config.overlay.OverlayStyle;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.event.render.HudRenderEvent;
import su.plo.voice.client.render.voice.RenderSourceInfo;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Pair;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.comparisons.ComparisonsKt;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.data.audio.source.DirectSourceInfo;
import su.plo.voice.proto.data.audio.source.PlayerSourceInfo;
import su.plo.voice.proto.data.audio.source.SelfSourceInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.data.player.MinecraftGameProfile;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UMatrixStack;
import su.plo.voice.universal.UResolution;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J0\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020&H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lsu/plo/voice/client/render/voice/OverlayRenderer;", "", "voiceClient", "Lsu/plo/voice/api/client/PlasmoVoiceClient;", "config", "Lsu/plo/voice/client/config/VoiceClientConfig;", "(Lsu/plo/voice/api/client/PlasmoVoiceClient;Lsu/plo/voice/client/config/VoiceClientConfig;)V", "calcPositionX", "", "x", "calcPositionY", "y", "getSourcePlayer", "Lsu/plo/voice/proto/data/player/MinecraftGameProfile;", "sourceInfo", "Lsu/plo/voice/proto/data/audio/source/SourceInfo;", "getSourceSenderId", "Ljava/util/UUID;", "getSourceSenderName", "Lsu/plo/lib/api/chat/MinecraftTextComponent;", "sourceLine", "Lsu/plo/voice/api/client/audio/line/ClientSourceLine;", "loadSkin", "Lnet/minecraft/resources/ResourceLocation;", "playerId", "playerName", "", "gameProfile", "onHudRender", "", "event", "Lsu/plo/voice/client/event/render/HudRenderEvent;", "renderEntry", "stack", "Lsu/plo/voice/universal/UMatrixStack;", "position", "Lsu/plo/voice/api/client/config/overlay/OverlayPosition;", "index", "Lsu/plo/voice/client/render/voice/RenderSourceInfo;", "Companion", "client"})
public final class OverlayRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlasmoVoiceClient voiceClient;
    @NotNull
    private final VoiceClientConfig config;
    private static final int ENTRY_HEIGHT = 16;
    private static final int MAX_TEXT_WIDTH = 40;

    public OverlayRenderer(@NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config) {
        Intrinsics.checkNotNullParameter(voiceClient, "voiceClient");
        Intrinsics.checkNotNullParameter(config, "config");
        this.voiceClient = voiceClient;
        this.config = config;
    }

    @EventSubscribe
    public final void onHudRender(@NotNull HudRenderEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(this.voiceClient.getServerInfo().isPresent() && this.voiceClient.getUdpClientManager().getClient().isPresent() && class_310.method_1551().field_1724 != null && ((Boolean)this.config.getOverlay().getOverlayEnabled().value()).booleanValue())) {
            return;
        }
        OverlayPosition position = (OverlayPosition)((Object)this.config.getOverlay().getOverlayPosition().value());
        int renderedIndex = 0;
        for (ClientSourceLine sourceLine : this.voiceClient.getSourceLineManager().getLines()) {
            OverlaySourceState sourceState = (OverlaySourceState)((Object)this.config.getOverlay().getSourceStates().getState(sourceLine).value());
            if (sourceState == OverlaySourceState.OFF || sourceState == OverlaySourceState.NEVER) continue;
            Iterator iterator2 = Lists.newArrayList();
            Intrinsics.checkNotNullExpressionValue(iterator2, "newArrayList()");
            List toRender = (List)((Object)iterator2);
            if (sourceLine.hasPlayers() && sourceState == OverlaySourceState.ALWAYS) {
                Object $this$onHudRender_u24lambda_u2d1;
                Object object;
                Object object2;
                Collection<MinecraftGameProfile> collection;
                HashMap hashMap = Maps.newHashMap();
                Intrinsics.checkNotNullExpressionValue(hashMap, "newHashMap()");
                Map toRenderByPlayerId = hashMap;
                Intrinsics.checkNotNull(sourceLine.getPlayers());
                Intrinsics.checkNotNullExpressionValue(collection, "sourceLine.players!!");
                Iterable iterable = collection;
                boolean $i$f$sortedBy = false;
                for (MinecraftGameProfile minecraftGameProfile : CollectionsKt.sortedWith(iterable, new Comparator(){

                    public final int compare(T a, T b) {
                        MinecraftGameProfile it = (MinecraftGameProfile)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (MinecraftGameProfile)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
                    }
                })) {
                    object2 = minecraftGameProfile.getId();
                    Intrinsics.checkNotNullExpressionValue(object2, "player.id");
                    UUID uUID = object2;
                    object2 = MinecraftTextComponent.literal(minecraftGameProfile.getName());
                    Intrinsics.checkNotNullExpressionValue(object2, "literal(player.name)");
                    RenderSourceInfo renderSourceInfo = new RenderSourceInfo(uUID, (MinecraftTextComponent)object2, minecraftGameProfile, false);
                    object2 = toRenderByPlayerId;
                    object = minecraftGameProfile.getId();
                    Intrinsics.checkNotNullExpressionValue(object, "player.id");
                    object2.put(object, renderSourceInfo);
                    toRender.add(new Pair<UUID, RenderSourceInfo>(minecraftGameProfile.getId(), renderSourceInfo));
                }
                for (ClientSelfSourceInfo clientSelfSourceInfo : this.voiceClient.getSourceManager().getSelfSourceInfos()) {
                    boolean bl;
                    object2 = clientSelfSourceInfo.getSelfSourceInfo();
                    Intrinsics.checkNotNullExpressionValue(object2, "selfSource.selfSourceInfo");
                    Object selfSourceInfo = object2;
                    if (!Intrinsics.areEqual(((SelfSourceInfo)selfSourceInfo).getSourceInfo().getLineId(), sourceLine.getId()) || (RenderSourceInfo)toRenderByPlayerId.get(((SelfSourceInfo)selfSourceInfo).getPlayerId()) == null) continue;
                    $this$onHudRender_u24lambda_u2d1 = object;
                    boolean bl2 = false;
                    ClientActivation clientActivation = this.voiceClient.getActivationManager().getActivationById(((SelfSourceInfo)selfSourceInfo).getActivationId()).orElse(null);
                    ((RenderSourceInfo)$this$onHudRender_u24lambda_u2d1).setActivated(clientActivation == null ? false : (bl = clientActivation.isActive()));
                }
                for (ClientAudioSource<?> clientAudioSource : this.voiceClient.getSourceManager().getSourcesByLineId(sourceLine.getId())) {
                    DirectSourceInfo sourceInfo;
                    if (!clientAudioSource.canHear() || ((object = clientAudioSource.getSourceInfo()) instanceof DirectSourceInfo ? (DirectSourceInfo)object : null) == null) continue;
                    sourceInfo = sourceInfo;
                    object = toRenderByPlayerId;
                    MinecraftGameProfile minecraftGameProfile = sourceInfo.getSender();
                    $this$onHudRender_u24lambda_u2d1 = minecraftGameProfile == null ? null : minecraftGameProfile.getId();
                    RenderSourceInfo renderSourceInfo = (RenderSourceInfo)object.get($this$onHudRender_u24lambda_u2d1);
                    if (renderSourceInfo == null) continue;
                    Object $this$onHudRender_u24lambda_u2d2 = object = renderSourceInfo;
                    boolean bl = false;
                    ((RenderSourceInfo)$this$onHudRender_u24lambda_u2d2).setActivated(true);
                }
            } else {
                for (ClientAudioSource clientAudioSource : this.voiceClient.getSourceManager().getSourcesByLineId(sourceLine.getId())) {
                    if (!clientAudioSource.canHear()) continue;
                    UUID uUID = this.getSourceSenderId((SourceInfo)clientAudioSource.getSourceInfo());
                    UUID uUID2 = this.getSourceSenderId((SourceInfo)clientAudioSource.getSourceInfo());
                    Object s = clientAudioSource.getSourceInfo();
                    Intrinsics.checkNotNullExpressionValue(sourceLine, "sourceLine");
                    toRender.add(new Pair<UUID, RenderSourceInfo>(uUID, new RenderSourceInfo(uUID2, this.getSourceSenderName((SourceInfo)s, sourceLine), this.getSourcePlayer((SourceInfo)clientAudioSource.getSourceInfo()), true)));
                }
            }
            iterator2 = toRender.iterator();
            while (iterator2.hasNext()) {
                RenderSourceInfo renderSourceInfo = (RenderSourceInfo)((Pair)iterator2.next()).component2();
                UMatrixStack uMatrixStack = event.getStack();
                Intrinsics.checkNotNullExpressionValue(uMatrixStack, "event.stack");
                Intrinsics.checkNotNullExpressionValue(sourceLine, "sourceLine");
                Intrinsics.checkNotNullExpressionValue((Object)position, "position");
                int n = renderedIndex;
                renderedIndex = n + 1;
                this.renderEntry(uMatrixStack, sourceLine, position, n, renderSourceInfo);
            }
        }
    }

    private final void renderEntry(UMatrixStack stack, ClientSourceLine sourceLine, OverlayPosition position, int index, RenderSourceInfo sourceInfo) {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        OverlayStyle overlayStyle = (OverlayStyle)((Object)this.config.getOverlay().getOverlayStyle().value());
        MinecraftTextComponent sourceName = sourceInfo.getSourceName();
        int textWidth = RenderUtil.getTextWidth(sourceName) + 8;
        int x = 0;
        x = this.calcPositionX(position.getX());
        int y = 0;
        y = this.calcPositionY(position.getY());
        y = position.isBottom() ? (y -= 17 * (index + 1)) : (y += 17 * index);
        UGraphics.depthFunc(515);
        stack.push();
        stack.translate(0.0f, 0.0f, 1000.0f);
        int backgroundColor = 0x3F000000;
        if (overlayStyle.getHasSkin()) {
            MinecraftGameProfile minecraftGameProfile = sourceInfo.getPlayer();
            if (minecraftGameProfile != null) {
                MinecraftGameProfile it = minecraftGameProfile;
                boolean bl = false;
                if (position.isRight()) {
                    x -= 16;
                }
                UGraphics.bindTexture(0, this.loadSkin(it));
                UGraphics.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                RenderUtil.blit(stack, x, y, 16, 16, 8.0f, 8.0f, 8, 8, 64, 64);
                UGraphics.enableBlend();
                RenderUtil.blit(stack, x, y, 16, 16, 40.0f, 8.0f, 8, 8, 64, 64);
                UGraphics.disableBlend();
                if (!position.isRight()) {
                    x += 17;
                }
            }
        }
        if (overlayStyle.getHasName()) {
            if (position.isRight()) {
                x -= textWidth + 1;
            }
            RenderUtil.fill(stack, x, y, x + textWidth, y + 16, backgroundColor);
            RenderUtil.drawString(stack, sourceName, x + 4, y + 4, 0xFFFFFF, false);
            if (sourceInfo.getActivated() && !position.isRight()) {
                x += textWidth + 1;
            }
        }
        if (sourceInfo.getActivated()) {
            if (position.isRight()) {
                x -= 17;
            }
            RenderUtil.fill(stack, x, y, x + 16, y + 16, backgroundColor);
            UGraphics.bindTexture(0, new class_2960(sourceLine.getIcon()));
            UGraphics.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            RenderUtil.blit(stack, x, y, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        stack.pop();
    }

    private final MinecraftTextComponent getSourceSenderName(SourceInfo sourceInfo, ClientSourceLine sourceLine) {
        MinecraftTextComponent minecraftTextComponent;
        if (sourceInfo.getName() != null) {
            String string = sourceInfo.getName();
            Intrinsics.checkNotNull(string);
            Object object = string;
            Intrinsics.checkNotNullExpressionValue(object, "sourceInfo.name!!");
            Object sourceName = object;
            if (((String)sourceName).length() > 40) {
                String string2 = ((String)sourceName).substring(0, 40);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                sourceName = string2 + "...";
            }
            object = MinecraftTextComponent.literal((String)sourceName);
            Intrinsics.checkNotNullExpressionValue(object, "literal(sourceName)");
            return (MinecraftTextComponent)object;
        }
        SourceInfo sourceInfo2 = sourceInfo;
        if (sourceInfo2 instanceof DirectSourceInfo) {
            MinecraftLiteralText minecraftLiteralText;
            MinecraftGameProfile minecraftGameProfile = ((DirectSourceInfo)sourceInfo).getSender();
            if (minecraftGameProfile == null) {
                minecraftLiteralText = null;
            } else {
                MinecraftGameProfile it = minecraftGameProfile;
                boolean bl = false;
                minecraftLiteralText = MinecraftTextComponent.literal(it.getName());
            }
            MinecraftLiteralText minecraftLiteralText2 = minecraftLiteralText;
            minecraftTextComponent = minecraftLiteralText2 == null ? sourceLine.getTranslationComponent() : (MinecraftTextComponent)minecraftLiteralText2;
        } else if (sourceInfo2 instanceof PlayerSourceInfo) {
            MinecraftLiteralText minecraftLiteralText;
            class_634 class_6342 = class_310.method_1551().method_1562();
            if (class_6342 == null) {
                minecraftLiteralText = null;
            } else {
                class_640 class_6402 = class_6342.method_2871(((PlayerSourceInfo)sourceInfo).getPlayerInfo().getPlayerId());
                if (class_6402 == null) {
                    minecraftLiteralText = null;
                } else {
                    class_640 it = class_6402;
                    boolean bl = false;
                    minecraftLiteralText = MinecraftTextComponent.literal(it.method_2966().getName());
                }
            }
            MinecraftLiteralText minecraftLiteralText3 = minecraftLiteralText;
            minecraftTextComponent = minecraftLiteralText3 == null ? sourceLine.getTranslationComponent() : (MinecraftTextComponent)minecraftLiteralText3;
        } else {
            minecraftTextComponent = sourceLine.getTranslationComponent();
        }
        return minecraftTextComponent;
    }

    private final UUID getSourceSenderId(SourceInfo sourceInfo) {
        UUID uUID;
        SourceInfo sourceInfo2 = sourceInfo;
        if (sourceInfo2 instanceof DirectSourceInfo) {
            MinecraftGameProfile minecraftGameProfile = ((DirectSourceInfo)sourceInfo).getSender();
            UUID uUID2 = minecraftGameProfile == null ? null : minecraftGameProfile.getId();
            if (uUID2 == null) {
                uUID2 = ((DirectSourceInfo)sourceInfo).getId();
            }
            UUID uUID3 = uUID2;
            Intrinsics.checkNotNullExpressionValue(uUID3, "sourceInfo.sender?.id ?: sourceInfo.id");
            uUID = uUID3;
        } else if (sourceInfo2 instanceof PlayerSourceInfo) {
            UUID uUID4 = ((PlayerSourceInfo)sourceInfo).getPlayerInfo().getPlayerId();
            Intrinsics.checkNotNullExpressionValue(uUID4, "sourceInfo.playerInfo.playerId");
            uUID = uUID4;
        } else {
            UUID uUID5 = sourceInfo.getId();
            Intrinsics.checkNotNullExpressionValue(uUID5, "sourceInfo.id");
            uUID = uUID5;
        }
        return uUID;
    }

    private final MinecraftGameProfile getSourcePlayer(SourceInfo sourceInfo) {
        SourceInfo sourceInfo2 = sourceInfo;
        return sourceInfo2 instanceof DirectSourceInfo ? ((DirectSourceInfo)sourceInfo).getSender() : (sourceInfo2 instanceof PlayerSourceInfo ? new MinecraftGameProfile(((PlayerSourceInfo)sourceInfo).getPlayerInfo().getPlayerId(), ((PlayerSourceInfo)sourceInfo).getPlayerInfo().getPlayerNick(), Collections.emptyList()) : null);
    }

    private final class_2960 loadSkin(MinecraftGameProfile gameProfile) {
        ModPlayerSkins.loadSkin(gameProfile);
        class_2960 class_29602 = ModPlayerSkins.getSkin(gameProfile.getId(), gameProfile.getName());
        Intrinsics.checkNotNullExpressionValue(class_29602, "getSkin(gameProfile.id, gameProfile.name)");
        return class_29602;
    }

    private final class_2960 loadSkin(UUID playerId, String playerName) {
        ModPlayerSkins.loadSkin(playerId, playerName, null);
        class_2960 class_29602 = ModPlayerSkins.getSkin(playerId, playerName);
        Intrinsics.checkNotNullExpressionValue(class_29602, "getSkin(playerId, playerName)");
        return class_29602;
    }

    private final int calcPositionX(int x) {
        return x < 0 ? UResolution.getScaledWidth() + x : x;
    }

    private final int calcPositionY(int y) {
        return y < 0 ? UResolution.getScaledHeight() + y : y;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsu/plo/voice/client/render/voice/OverlayRenderer$Companion;", "", "()V", "ENTRY_HEIGHT", "", "MAX_TEXT_WIDTH", "client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

