/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.EnumConfigEntry;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.api.client.config.overlay.OverlaySourceState;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UMatrixStack;

public final class OverlaySourceStateButton
extends GuiAbstractWidget {
    private static final MinecraftTextComponent ON = MinecraftTextComponent.translatable("message.plasmovoice.on", new Object[0]);
    private static final MinecraftTextComponent OFF = MinecraftTextComponent.translatable("message.plasmovoice.off", new Object[0]);
    @Nullable
    private final PressAction action;
    private final EnumConfigEntry<OverlaySourceState> entry;

    public OverlaySourceStateButton(EnumConfigEntry<OverlaySourceState> entry, int x, int y, int width, int height) {
        this(entry, x, y, width, height, null);
    }

    public OverlaySourceStateButton(@NotNull EnumConfigEntry<OverlaySourceState> entry, int x, int y, int width, int height, @Nullable PressAction action) {
        super(x, y, width, height);
        this.entry = entry;
        this.action = action;
    }

    @Override
    public MinecraftTextComponent getText() {
        return this.entry.value() == OverlaySourceState.ON ? ON : OFF;
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        this.invertToggle();
    }

    @Override
    protected int getYImage(boolean hovered) {
        return 0;
    }

    @Override
    protected void renderBackground(@NotNull UMatrixStack stack, int mouseX, int mouseY) {
        UGraphics.bindTexture(0, WIDGETS_LOCATION);
        int i = (this.isHoveredOrFocused() && this.active ? 2 : 1) * 20;
        if (this.entry.value() == OverlaySourceState.ON) {
            RenderUtil.blit(stack, this.x + (int)((double)(this.width - 8)), this.y, 0, 46 + i, 4, 20);
            RenderUtil.blit(stack, this.x + (int)((double)(this.width - 8)) + 4, this.y, 196, 46 + i, 4, 20);
        } else {
            RenderUtil.blit(stack, this.x, this.y, 0, 46 + i, 4, 20);
            RenderUtil.blit(stack, this.x + 4, this.y, 196, 46 + i, 4, 20);
        }
    }

    public void invertToggle() {
        this.entry.set(this.entry.value() == OverlaySourceState.OFF ? OverlaySourceState.ON : OverlaySourceState.OFF);
        if (this.action != null) {
            this.action.onToggle((OverlaySourceState)((Object)this.entry.value()));
        }
    }

    public static interface PressAction {
        public void onToggle(OverlaySourceState var1);
    }
}

