/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.tab;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.ConfigEntry;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.GuiUtil;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.device.DeviceFactory;
import su.plo.voice.api.client.audio.device.DeviceFactoryManager;
import su.plo.voice.api.client.audio.device.DeviceManager;
import su.plo.voice.api.client.audio.device.DeviceType;
import su.plo.voice.api.client.audio.device.HrtfAudioDevice;
import su.plo.voice.api.client.audio.device.InputDevice;
import su.plo.voice.api.client.audio.device.OutputDevice;
import su.plo.voice.api.client.audio.device.source.AlSource;
import su.plo.voice.api.client.event.audio.device.DeviceClosedEvent;
import su.plo.voice.api.client.event.audio.device.DeviceOpenEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.util.Params;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.gui.settings.MicrophoneTestController;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.tab.TabWidget;
import su.plo.voice.client.gui.settings.widget.ActivationThresholdWidget;
import su.plo.voice.client.gui.settings.widget.DropDownWidget;
import su.plo.voice.client.gui.settings.widget.ToggleButton;

public final class DevicesTabWidget
extends TabWidget {
    private final MicrophoneTestController testController;
    private final DeviceManager devices;
    private final DeviceFactoryManager deviceFactories;
    private ActivationThresholdWidget threshold;

    public DevicesTabWidget(VoiceSettingsScreen parent, PlasmoVoiceClient voiceClient, VoiceClientConfig config, MicrophoneTestController testController) {
        super(parent, voiceClient, config);
        this.testController = testController;
        this.devices = voiceClient.getDeviceManager();
        this.deviceFactories = voiceClient.getDeviceFactoryManager();
    }

    @Override
    public void init() {
        super.init();
        this.addEntry(new TabWidget.CategoryEntry(MinecraftTextComponent.translatable("gui.plasmovoice.devices.microphone", new Object[0])));
        this.addEntry(this.createThresholdEntry());
        this.addEntry(this.createMicrophoneEntry());
        this.addEntry(this.createVolumeSlider(MinecraftTextComponent.translatable("gui.plasmovoice.devices.microphone_volume", new Object[0]), MinecraftTextComponent.translatable("gui.plasmovoice.devices.volume.tooltip", new Object[0]), this.config.getVoice().getMicrophoneVolume(), "%"));
        this.addEntry(this.createToggleEntry(MinecraftTextComponent.translatable("gui.plasmovoice.devices.noise_suppression", new Object[0]), MinecraftTextComponent.translatable("gui.plasmovoice.devices.noise_suppression.tooltip", new Object[0]), this.config.getVoice().getNoiseSuppression()));
        this.addEntry(this.createStereoCaptureEntry());
        this.addEntry(new TabWidget.CategoryEntry(MinecraftTextComponent.translatable("gui.plasmovoice.devices.output", new Object[0])));
        this.addEntry(this.createOutputDeviceEntry());
        this.addEntry(this.createVolumeSlider(MinecraftTextComponent.translatable("gui.plasmovoice.devices.volume", new Object[0]), MinecraftTextComponent.translatable("gui.plasmovoice.devices.volume.tooltip", new Object[0]), this.config.getVoice().getVolume(), "%"));
        this.addEntry(this.createToggleEntry(MinecraftTextComponent.translatable("gui.plasmovoice.devices.occlusion", new Object[0]), MinecraftTextComponent.translatable("gui.plasmovoice.devices.occlusion.tooltip", new Object[0]), this.config.getVoice().getSoundOcclusion()));
        this.addEntry(this.createToggleEntry(MinecraftTextComponent.translatable("gui.plasmovoice.devices.directional_sources", new Object[0]), MinecraftTextComponent.translatable("gui.plasmovoice.devices.directional_sources.tooltip", new Object[0]), this.config.getVoice().getDirectionalSources()));
        this.addEntry(this.createHrtfEntry());
    }

    @EventSubscribe
    public void onDeviceOpen(@NotNull DeviceOpenEvent event) {
        class_310.method_1551().execute(this::init);
    }

    @EventSubscribe
    public void onDeviceClose(@NotNull DeviceClosedEvent event) {
        class_310.method_1551().execute(this::init);
    }

    private TabWidget.ButtonOptionEntry<ActivationThresholdWidget> createThresholdEntry() {
        if (this.threshold != null) {
            this.voiceClient.getEventBus().unregister((Object)this.voiceClient, this.threshold);
        }
        this.threshold = new ActivationThresholdWidget((VoiceSettingsScreen)this.parent, this.config.getVoice().getActivationThreshold(), this.voiceClient.getAudioCapture(), this.voiceClient.getDeviceManager(), this.testController, 0, 0, 100, 20);
        this.voiceClient.getEventBus().register(this.voiceClient, this.threshold);
        return new TabWidget.ButtonOptionEntry((TabWidget)this, (MinecraftTextComponent)MinecraftTextComponent.translatable("gui.plasmovoice.devices.activation_threshold", new Object[0]), (GuiAbstractWidget)this.threshold, this.threshold.getButtons(), (ConfigEntry)this.config.getVoice().getActivationThreshold(), (MinecraftTextComponent)MinecraftTextComponent.translatable("gui.plasmovoice.devices.activation_threshold.tooltip", new Object[0]), null);
    }

    private TabWidget.OptionEntry<DropDownWidget> createMicrophoneEntry() {
        Optional<DeviceFactory> deviceFactory;
        if (((Boolean)this.config.getVoice().getUseJavaxInput().value()).booleanValue()) {
            deviceFactory = this.deviceFactories.getDeviceFactory("JAVAX_INPUT");
            if (!deviceFactory.isPresent()) {
                throw new IllegalStateException("Javax Input device factory not initialized");
            }
        } else {
            deviceFactory = this.deviceFactories.getDeviceFactory("AL_INPUT");
            if (!deviceFactory.isPresent()) {
                throw new IllegalStateException("Al Input device factory not initialized");
            }
        }
        ImmutableList<String> inputDeviceNames = deviceFactory.get().getDeviceNames();
        Collection inputDevices = this.devices.getDevices(DeviceType.INPUT);
        Optional<Object> inputDevice = inputDevices.stream().findFirst();
        DropDownWidget dropdown = new DropDownWidget((VoiceSettingsScreen)this.parent, 0, 0, 124, 20, GuiUtil.formatDeviceName(inputDevice.orElse(null), deviceFactory.get()), GuiUtil.formatDeviceNames(inputDeviceNames, deviceFactory.get()), true, index -> {
            String deviceName = (String)inputDeviceNames.get(index.intValue());
            if (Objects.equals(deviceName, ((DeviceFactory)deviceFactory.get()).getDefaultDeviceName())) {
                deviceName = null;
            }
            this.config.getVoice().getInputDevice().set(Strings.nullToEmpty((String)deviceName));
            this.config.save(true);
            this.reloadInputDevice();
        });
        dropdown.setActive(!inputDeviceNames.isEmpty());
        return new TabWidget.OptionEntry((TabWidget)this, (MinecraftTextComponent)MinecraftTextComponent.translatable("gui.plasmovoice.devices.microphone", new Object[0]), (GuiAbstractWidget)dropdown, this.config.getVoice().getInputDevice(), (button, element) -> {
            element.setText(GuiUtil.formatDeviceName((String)null, (DeviceFactory)deviceFactory.get()));
            this.reloadInputDevice();
        });
    }

    private TabWidget.OptionEntry<ToggleButton> createStereoCaptureEntry() {
        Runnable onUpdate = () -> {
            this.reloadInputDevice();
            this.testController.restart();
        };
        ToggleButton toggleButton = new ToggleButton(this.config.getVoice().getStereoCapture(), 0, 0, 124, 20, toggled -> onUpdate.run());
        return new TabWidget.OptionEntry((TabWidget)this, (MinecraftTextComponent)MinecraftTextComponent.translatable("gui.plasmovoice.devices.stereo_capture", new Object[0]), (GuiAbstractWidget)toggleButton, (ConfigEntry)this.config.getVoice().getStereoCapture(), (MinecraftTextComponent)MinecraftTextComponent.translatable("gui.plasmovoice.devices.stereo_capture.tooltip", new Object[0]), (button, element) -> onUpdate.run());
    }

    private TabWidget.OptionEntry<DropDownWidget> createOutputDeviceEntry() {
        Optional<DeviceFactory> deviceFactory = this.deviceFactories.getDeviceFactory("AL_OUTPUT");
        if (!deviceFactory.isPresent()) {
            throw new IllegalStateException("Al Output device factory not initialized");
        }
        ImmutableList<String> outputDeviceNames = deviceFactory.get().getDeviceNames();
        Collection outputDevices = this.devices.getDevices(DeviceType.OUTPUT);
        Optional<Object> outputDevice = outputDevices.stream().findFirst();
        DropDownWidget dropdown = new DropDownWidget((VoiceSettingsScreen)this.parent, 0, 0, 124, 20, GuiUtil.formatDeviceName(outputDevice.orElse(null), deviceFactory.get()), GuiUtil.formatDeviceNames(outputDeviceNames, deviceFactory.get()), true, index -> {
            String deviceName = (String)outputDeviceNames.get(index.intValue());
            if (Objects.equals(deviceName, ((DeviceFactory)deviceFactory.get()).getDefaultDeviceName())) {
                deviceName = null;
            }
            this.config.getVoice().getOutputDevice().set(Strings.nullToEmpty((String)deviceName));
            this.config.save(true);
            this.reloadOutputDevice();
        });
        dropdown.setActive(!outputDeviceNames.isEmpty());
        return new TabWidget.OptionEntry((TabWidget)this, (MinecraftTextComponent)MinecraftTextComponent.translatable("gui.plasmovoice.devices.output_device", new Object[0]), (GuiAbstractWidget)dropdown, this.config.getVoice().getOutputDevice(), (button, element) -> {
            element.setText(GuiUtil.formatDeviceName((String)null, (DeviceFactory)deviceFactory.get()));
            this.reloadOutputDevice();
        });
    }

    private TabWidget.OptionEntry<ToggleButton> createHrtfEntry() {
        Consumer<Boolean> onUpdate = toggled -> this.devices.getDevices(DeviceType.OUTPUT).forEach(device -> {
            if (device instanceof HrtfAudioDevice) {
                try {
                    device.reload();
                }
                catch (DeviceException e) {
                    BaseVoice.LOGGER.warn("Failed to reload device: {}", (Object)e.getMessage());
                    e.printStackTrace();
                }
            }
        });
        ToggleButton toggleButton = new ToggleButton(this.config.getVoice().getHrtf(), 0, 0, 124, 20, onUpdate::accept);
        return new TabWidget.OptionEntry((TabWidget)this, (MinecraftTextComponent)MinecraftTextComponent.translatable("gui.plasmovoice.devices.hrtf", new Object[0]), (GuiAbstractWidget)toggleButton, (ConfigEntry)this.config.getVoice().getHrtf(), (MinecraftTextComponent)MinecraftTextComponent.translatable("gui.plasmovoice.devices.hrtf.tooltip", new Object[0]), (button, element) -> onUpdate.accept((Boolean)this.config.getVoice().getHrtf().value()));
    }

    private void reloadOutputDevice() {
        try {
            OutputDevice<AlSource> outputDevice = this.devices.openOutputDevice(null, Params.EMPTY);
            this.voiceClient.getDeviceManager().replace(null, outputDevice);
            this.testController.restart();
        }
        catch (Exception e) {
            BaseVoice.LOGGER.error("Failed to open primary OpenAL output device", (Throwable)e);
        }
    }

    private void reloadInputDevice() {
        try {
            InputDevice device = this.devices.openInputDevice(null, Params.EMPTY);
            this.devices.replace(null, device);
        }
        catch (Exception e) {
            BaseVoice.LOGGER.error("Failed to open input device", (Throwable)e);
        }
    }
}

