/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.tab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.BooleanConfigEntry;
import su.plo.config.entry.ConfigEntry;
import su.plo.config.entry.EnumConfigEntry;
import su.plo.config.entry.IntConfigEntry;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.chat.MinecraftTextStyle;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.gui.components.IconButton;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.api.client.audio.capture.ClientActivationManager;
import su.plo.voice.api.client.connection.ServerInfo;
import su.plo.voice.api.client.event.audio.capture.ClientActivationRegisteredEvent;
import su.plo.voice.api.client.event.audio.capture.ClientActivationUnregisteredEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.audio.capture.VoiceClientActivation;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.config.capture.ConfigClientActivation;
import su.plo.voice.client.config.keybind.KeyBindingConfigEntry;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.tab.AbstractHotKeysTabWidget;
import su.plo.voice.client.gui.settings.tab.TabWidget;
import su.plo.voice.client.gui.settings.widget.DistanceSliderWidget;
import su.plo.voice.client.gui.settings.widget.DropDownWidget;
import su.plo.voice.client.gui.settings.widget.HotKeyWidget;
import su.plo.voice.client.gui.settings.widget.NumberTextFieldWidget;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;
import su.plo.voice.universal.UMinecraft;

public final class ActivationTabWidget
extends AbstractHotKeysTabWidget {
    private static final List<MinecraftTextComponent> TYPES = ImmutableList.of((Object)MinecraftTextComponent.translatable("gui.plasmovoice.activation.type_ptt", new Object[0]), (Object)MinecraftTextComponent.translatable("gui.plasmovoice.activation.type_voice", new Object[0]), (Object)MinecraftTextComponent.translatable("gui.plasmovoice.activation.type_inherit", new Object[0]));
    private static final List<MinecraftTextComponent> NO_INHERIT_TYPES = ImmutableList.of((Object)MinecraftTextComponent.translatable("gui.plasmovoice.activation.type_ptt", new Object[0]), (Object)MinecraftTextComponent.translatable("gui.plasmovoice.activation.type_voice", new Object[0]));
    private final ClientActivationManager activations;

    public ActivationTabWidget(@NotNull VoiceSettingsScreen parent, @NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config) {
        super(parent, voiceClient, config);
        this.activations = voiceClient.getActivationManager();
    }

    @Override
    public void init() {
        super.init();
        this.activations.getParentActivation().ifPresent(activation -> this.createActivation((ClientActivation)activation, false));
        ArrayList activations = Lists.newArrayList(this.activations.getActivations());
        Collections.reverse(activations);
        activations.stream().filter(activation -> !activation.getId().equals(VoiceActivation.PROXIMITY_ID)).forEach(activation -> this.createActivation((ClientActivation)activation, true));
    }

    @EventSubscribe
    public void onActivationRegister(@NotNull ClientActivationRegisteredEvent event) {
        UMinecraft.getMinecraft().execute(this::init);
    }

    @EventSubscribe
    public void onActivationUnregister(@NotNull ClientActivationUnregisteredEvent event) {
        UMinecraft.getMinecraft().execute(this::init);
    }

    private void createActivation(ClientActivation activation, boolean canInherit) {
        Optional<ServerInfo> serverInfo = this.voiceClient.getServerInfo();
        if (!serverInfo.isPresent()) {
            throw new IllegalStateException("Not connected");
        }
        Optional<VoiceClientConfig.Server> serverConfig = this.config.getServers().getById(serverInfo.get().getServerId());
        if (!serverConfig.isPresent()) {
            throw new IllegalStateException("Not connected");
        }
        Optional<ConfigClientActivation> activationConfig = this.config.getActivations().getActivation(activation.getId());
        if (!activationConfig.isPresent()) {
            throw new IllegalStateException("Activation config is empty");
        }
        Optional<IntConfigEntry> activationDistance = serverConfig.get().getActivationDistance(activation.getId());
        if (!activationDistance.isPresent()) {
            throw new IllegalStateException("Activation distance config is empty");
        }
        this.addEntry(new TabWidget.CategoryEntry(MinecraftTextComponent.translatable(activation.getTranslation(), new Object[0])));
        this.addEntry(this.createActivationType(activation, activationConfig.get(), canInherit));
        this.addEntry(this.createActivationButton((VoiceClientActivation)activation));
        if (activation.getDistances().size() > 0) {
            this.createDistance(activation, activationConfig.get(), activationDistance.get());
        }
    }

    private TabWidget.OptionEntry<DropDownWidget> createActivationType(ClientActivation activation, ConfigClientActivation activationConfig, boolean canInherit) {
        DropDownWidget dropdown = new DropDownWidget((VoiceSettingsScreen)this.parent, 0, 0, activation.getType() == ClientActivation.Type.PUSH_TO_TALK ? 124 : 100, 20, TYPES.get(activation.getType().ordinal()), canInherit ? TYPES : NO_INHERIT_TYPES, false, index -> {
            activationConfig.getConfigType().set(ClientActivation.Type.values()[index]);
            this.init();
        });
        return new ActivationToggleStateEntry(MinecraftTextComponent.translatable("gui.plasmovoice.activation.type", new Object[0]), dropdown, MinecraftTextComponent.translatable(activation.getTranslation(), new Object[0]), activationConfig.getConfigType(), activationConfig.getConfigToggle(), null, (btn, element) -> {
            element.setText(TYPES.get(activation.getType().ordinal()));
            this.init();
        });
    }

    private TabWidget.OptionEntry<HotKeyWidget> createActivationButton(VoiceClientActivation activation) {
        String translatable = "gui.plasmovoice.activation.toggle_button";
        KeyBindingConfigEntry entry = activation.getToggleConfigEntry();
        if (activation.getType() == ClientActivation.Type.PUSH_TO_TALK) {
            translatable = "gui.plasmovoice.activation.ptt_button";
            entry = activation.getPttConfigEntry();
        }
        return this.createHotKey(translatable, null, entry);
    }

    private void createDistance(ClientActivation activation, ConfigClientActivation activationConfig, IntConfigEntry activationDistance) {
        if (activation.getDistances().size() == 0) {
            return;
        }
        if (activation.getMinDistance() == -1) {
            this.addEntry(this.createDistanceText(activation, activationConfig, activationDistance));
        } else {
            this.addEntry(this.createDistanceSlider(activation, activationConfig, activationDistance));
        }
    }

    private TabWidget.OptionEntry<DistanceSliderWidget> createDistanceSlider(ClientActivation activation, ConfigClientActivation activationConfig, IntConfigEntry activationDistance) {
        DistanceSliderWidget sliderWidget = new DistanceSliderWidget(activation, activationDistance, 0, 0, 124, 20);
        return new TabWidget.OptionEntry((TabWidget)this, (MinecraftTextComponent)MinecraftTextComponent.translatable("gui.plasmovoice.activation.distance", MinecraftTextComponent.translatable(activation.getTranslation(), new Object[0])), (GuiAbstractWidget)sliderWidget, (ConfigEntry)activationDistance);
    }

    private TabWidget.OptionEntry<NumberTextFieldWidget> createDistanceText(ClientActivation activation, ConfigClientActivation activationConfig, IntConfigEntry activationDistance) {
        NumberTextFieldWidget textField = new NumberTextFieldWidget(activationDistance, 0, 0, 124, 20);
        return new TabWidget.OptionEntry((TabWidget)this, (MinecraftTextComponent)MinecraftTextComponent.translatable("gui.plasmovoice.activation.distance", MinecraftTextComponent.translatable(activation.getTranslation(), new Object[0])), (GuiAbstractWidget)textField, (ConfigEntry)activationDistance);
    }

    private class ActivationToggleStateEntry
    extends TabWidget.ButtonOptionEntry<DropDownWidget> {
        public ActivationToggleStateEntry(@NotNull MinecraftTextComponent text, @NotNull DropDownWidget widget, @NotNull MinecraftTextComponent activationName, @NotNull EnumConfigEntry<ClientActivation.Type> entry, @Nullable BooleanConfigEntry stateEntry, @Nullable MinecraftTextComponent tooltip, TabWidget.OptionResetAction<DropDownWidget> resetAction) {
            super((TabWidget)ActivationTabWidget.this, text, (GuiAbstractWidget)widget, (List)Lists.newArrayList(), entry, tooltip, resetAction);
            if (entry.value() == ClientActivation.Type.PUSH_TO_TALK) {
                return;
            }
            IconButton disableToggleState = new IconButton(((VoiceSettingsScreen)ActivationTabWidget.this.parent).getWidth() - 52, 8, 20, 20, button -> {
                ((Button)this.buttons.get(0)).setVisible(false);
                ((Button)this.buttons.get(1)).setVisible(true);
                stateEntry.set(true);
            }, (button, render, mouseX, mouseY) -> ((VoiceSettingsScreen)ActivationTabWidget.this.parent).setTooltip(MinecraftTextComponent.translatable("gui.plasmovoice.activation.toggle", activationName, MinecraftTextComponent.translatable("gui.plasmovoice.toggle.currently", MinecraftTextComponent.translatable("gui.plasmovoice.toggle.enabled", new Object[0]).withStyle(MinecraftTextStyle.GREEN)).withStyle(MinecraftTextStyle.GRAY))), new class_2960("plasmovoice:textures/icons/microphone_menu.png"), true);
            IconButton enableToggleState = new IconButton(((VoiceSettingsScreen)ActivationTabWidget.this.parent).getWidth() - 52, 8, 20, 20, button -> {
                ((Button)this.buttons.get(0)).setVisible(true);
                ((Button)this.buttons.get(1)).setVisible(false);
                stateEntry.set(false);
            }, (button, render, mouseX, mouseY) -> ((VoiceSettingsScreen)ActivationTabWidget.this.parent).setTooltip(MinecraftTextComponent.translatable("gui.plasmovoice.activation.toggle", activationName, MinecraftTextComponent.translatable("gui.plasmovoice.toggle.currently", MinecraftTextComponent.translatable("gui.plasmovoice.toggle.disabled", new Object[0]).withStyle(MinecraftTextStyle.RED)).withStyle(MinecraftTextStyle.GRAY))), new class_2960("plasmovoice:textures/icons/microphone_menu_disabled.png"), true);
            disableToggleState.setVisible((Boolean)stateEntry.value() == false);
            enableToggleState.setVisible((Boolean)stateEntry.value());
            this.buttons.add(disableToggleState);
            this.buttons.add(enableToggleState);
            this.widgets.addAll(this.buttons);
        }
    }
}

