/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings;

import java.net.URI;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.gui.screen.GuiScreen;
import su.plo.lib.mod.client.gui.screen.ScreenWrapper;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.api.client.event.socket.UdpClientClosedEvent;
import su.plo.voice.api.client.event.socket.UdpClientConnectedEvent;
import su.plo.voice.api.client.event.socket.UdpClientTimedOutEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.universal.UDesktop;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UMatrixStack;

public final class VoiceNotAvailableScreen
extends GuiScreen {
    private static final String WIKI_LINK = "https://plasmovoice.com/docs/server/installing";
    private static final int WIDTH = 248;
    private static final int HEIGHT = 50;
    private final BaseVoiceClient voiceClient;
    private Button button;
    private int x;
    private int y;
    private MinecraftTextComponent message;

    public VoiceNotAvailableScreen(@NotNull BaseVoiceClient voiceClient) {
        this.setNotAvailable();
        this.voiceClient = voiceClient;
        voiceClient.getEventBus().register(voiceClient, this);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        String formattedMessage = RenderUtil.getFormattedString(this.message);
        String[] messageLines = formattedMessage.split("\n");
        if (messageLines.length == 3 && button == 0) {
            int lineWidth = UGraphics.getStringWidth(messageLines[2]);
            int lineHeight = UGraphics.getFontHeight();
            float x = this.getWidth() / 2 - lineWidth / 2;
            if (mouseX >= (double)x && mouseX <= (double)(x + (float)lineWidth) && mouseY >= (double)(this.y + 10 + lineHeight * 2) && mouseY <= (double)(this.y + 10 + lineHeight * 3)) {
                this.openLink(WIKI_LINK);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void init() {
        this.x = (this.getWidth() - 248) / 2;
        this.y = (this.getHeight() - 50) / 2;
        this.button = new Button(this.x + 10, 0, 228, 20, MinecraftTextComponent.translatable("message.plasmovoice.close", new Object[0]), button -> ScreenWrapper.openScreen(null), Button.NO_TOOLTIP);
        this.clearWidgets();
        this.addRenderWidget(this.button);
    }

    @Override
    public void removed() {
        this.voiceClient.getEventBus().unregister((Object)this.voiceClient, this);
    }

    @Override
    public void render(@NotNull UMatrixStack stack, int mouseX, int mouseY, float delta) {
        this.screen.renderBackground(stack);
        int messageLines = RenderUtil.drawStringMultiLineCentered(stack, this.message, this.getWidth(), this.y, 0, 0xFFFFFF);
        this.button.setY(this.y + UGraphics.getFontHeight() * messageLines + 20);
        super.render(stack, mouseX, mouseY, delta);
    }

    public void setNotAvailable() {
        this.message = MinecraftTextComponent.translatable("gui.plasmovoice.not_available", new Object[0]);
    }

    public void setConnecting() {
        this.message = MinecraftTextComponent.translatable("gui.plasmovoice.connecting", new Object[0]);
    }

    public void setCannotConnect() {
        this.message = MinecraftTextComponent.translatable("gui.plasmovoice.cannot_connect_to_udp", WIKI_LINK);
    }

    private void openLink(@NotNull String link) {
        try {
            UDesktop.browse(new URI(link));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @EventSubscribe
    public void onConnect(@NotNull UdpClientConnectedEvent event) {
        this.voiceClient.openSettings();
    }

    @EventSubscribe
    public void onTimedOut(@NotNull UdpClientTimedOutEvent event) {
        if (event.isTimedOut()) {
            this.setConnecting();
        } else {
            this.voiceClient.openSettings();
        }
    }

    @EventSubscribe
    public void onClosed(@NotNull UdpClientClosedEvent event) {
        switch (event.getReason()) {
            case TIMED_OUT: 
            case FAILED_TO_CONNECT: {
                this.setCannotConnect();
                break;
            }
            case RECONNECT: {
                this.setConnecting();
                break;
            }
            default: {
                this.setNotAvailable();
            }
        }
    }
}

