/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.config.keybind;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.ConfigEntry;
import su.plo.config.entry.SerializableConfigEntry;
import su.plo.voice.api.client.config.keybind.KeyBinding;
import su.plo.voice.api.client.config.keybind.KeyBindings;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.config.keybind.KeyBindingConfigEntry;
import su.plo.voice.client.config.keybind.VoiceKeyBinding;
import su.plo.voice.client.event.key.KeyPressedEvent;
import su.plo.voice.universal.UScreen;

public final class ConfigKeyBindings
implements KeyBindings,
SerializableConfigEntry {
    private Map<String, KeyBindingConfigEntry> keyBindings = Maps.newHashMap();
    private final ListMultimap<String, KeyBindingConfigEntry> categoryEntries = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
    private final Set<KeyBinding.Key> pressedKeys = new HashSet<KeyBinding.Key>();

    public ConfigKeyBindings() {
        this.register("key.plasmovoice.proximity.ptt", (List<KeyBinding.Key>)ImmutableList.of((Object)KeyBinding.Type.KEYSYM.getOrCreate(342)), "hidden", true);
        this.register("key.plasmovoice.general.mute_microphone", (List<KeyBinding.Key>)ImmutableList.of((Object)KeyBinding.Type.KEYSYM.getOrCreate(77)), "key.plasmovoice.general", false);
        this.register("key.plasmovoice.general.disable_voice", (List<KeyBinding.Key>)ImmutableList.of(), "key.plasmovoice.general", false);
        this.register("key.plasmovoice.general.action", (List<KeyBinding.Key>)ImmutableList.of((Object)KeyBinding.Type.MOUSE.getOrCreate(1)), "key.plasmovoice.general", false);
        this.register("key.plasmovoice.occlusion.toggle", (List<KeyBinding.Key>)ImmutableList.of(), "key.plasmovoice.occlusion", false);
    }

    @Override
    public synchronized Optional<KeyBinding> getKeyBinding(@NotNull String name) {
        if (!this.keyBindings.containsKey(name)) {
            return Optional.empty();
        }
        return Optional.of((KeyBinding)this.keyBindings.get(name).value());
    }

    public synchronized Optional<KeyBindingConfigEntry> getConfigKeyBinding(@NotNull String name) {
        return Optional.ofNullable(this.keyBindings.get(name));
    }

    @Override
    public synchronized KeyBinding register(@NotNull String name, List<KeyBinding.Key> keys2, @NotNull String category, boolean anyContext) {
        boolean keyBindingExists;
        VoiceKeyBinding keyBinding = new VoiceKeyBinding(this, name, keys2, anyContext);
        if (this.categoryEntries.containsKey((Object)category) && (keyBindingExists = this.categoryEntries.values().stream().anyMatch(entry -> ((KeyBinding)entry.value()).equals(keyBinding)))) {
            throw new IllegalArgumentException("KeyBinding with the same name is already exists");
        }
        KeyBindingConfigEntry entry2 = new KeyBindingConfigEntry(keyBinding);
        this.categoryEntries.put((Object)category, (Object)entry2);
        this.keyBindings.put(name, entry2);
        return keyBinding;
    }

    @Override
    public synchronized void resetStates() {
        this.keyBindings.values().forEach(entry -> ((KeyBinding)entry.value()).resetState());
    }

    @Override
    public Map<String, Collection<KeyBinding>> getCategories() {
        HashMap<String, Collection<KeyBinding>> categories = new HashMap<String, Collection<KeyBinding>>();
        this.categoryEntries.asMap().forEach((category, list) -> categories.put((String)category, list.stream().map(ConfigEntry::value).collect(Collectors.toList())));
        return categories;
    }

    @Override
    public synchronized void deserialize(Object object) {
        try {
            List serialized = (List)object;
            serialized.forEach(value -> {
                Map configKeyMap = (Map)value;
                String name = (String)configKeyMap.get("name");
                String category = (String)configKeyMap.get("category");
                List configKeys = (List)configKeyMap.get("keys");
                boolean anyContext = (Boolean)configKeyMap.get("any_context");
                ArrayList keys2 = new ArrayList();
                configKeys.forEach(serializedKey -> {
                    Map configKey = (Map)serializedKey;
                    KeyBinding.Type keyType = KeyBinding.Type.valueOf((String)configKey.get("type"));
                    int keyCode = ((Long)configKey.get("code")).intValue();
                    keys2.add(new KeyBinding.Key(keyType, keyCode));
                });
                if (!this.keyBindings.containsKey(name)) {
                    this.register(name, (List<KeyBinding.Key>)ImmutableList.of(), category, anyContext);
                }
                Optional<KeyBindingConfigEntry> keybindingEntry = this.categoryEntries.values().stream().filter(entry -> ((KeyBinding)entry.value()).getName().equals(name)).findFirst();
                keybindingEntry.ifPresent(keyBindingConfigEntry -> keyBindingConfigEntry.set(new VoiceKeyBinding(this, name, keys2, anyContext)));
            });
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public synchronized Object serialize() {
        ArrayList serialized = new ArrayList();
        this.categoryEntries.asMap().forEach((category, keyBindings) -> keyBindings.forEach(entry -> {
            if (entry.isDefault()) {
                return;
            }
            KeyBinding keyBinding = (KeyBinding)entry.value();
            HashMap serializedKeyBinding = Maps.newHashMap();
            serializedKeyBinding.put("name", keyBinding.getName());
            serializedKeyBinding.put("category", category);
            serializedKeyBinding.put("keys", keyBinding.getKeys().stream().map(key -> {
                HashMap serializedKey = Maps.newHashMap();
                serializedKey.put("type", key.getType().name());
                serializedKey.put("code", key.getCode());
                return serializedKey;
            }).collect(Collectors.toList()));
            serializedKeyBinding.put("any_context", keyBinding.isAnyContext());
            serialized.add(serializedKeyBinding);
        }));
        return serialized;
    }

    @EventSubscribe
    public void onKeyPressed(@NotNull KeyPressedEvent event) {
        if (event.getAction() == KeyBinding.Action.UP) {
            this.pressedKeys.remove(event.getKey());
        } else {
            this.pressedKeys.add(event.getKey());
        }
        this.keyBindings.values().forEach(entry -> {
            if (((KeyBinding)entry.value()).isAnyContext() || UScreen.getCurrentScreen() == null) {
                ((KeyBinding)entry.value()).updateState(event.getAction());
            }
        });
    }

    public String toString() {
        return "ConfigKeyBindings(keyBindings=" + this.getKeyBindings() + ", categoryEntries=" + this.getCategoryEntries() + ", pressedKeys=" + (Set)this.getPressedKeys() + ")";
    }

    public Map<String, KeyBindingConfigEntry> getKeyBindings() {
        return this.keyBindings;
    }

    public void setKeyBindings(Map<String, KeyBindingConfigEntry> keyBindings) {
        this.keyBindings = keyBindings;
    }

    public ListMultimap<String, KeyBindingConfigEntry> getCategoryEntries() {
        return this.categoryEntries;
    }

    public Set<KeyBinding.Key> getPressedKeys() {
        return this.pressedKeys;
    }
}

