/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.device.source;

import java.util.Arrays;
import org.lwjgl.openal.AL11;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.AlAudioDevice;
import su.plo.voice.api.client.audio.device.source.AlSource;
import su.plo.voice.api.client.event.audio.device.source.AlSourcePauseEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourcePlayEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceStopEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceUpdateParamEvent;
import su.plo.voice.client.audio.AlUtil;
import su.plo.voice.client.audio.device.AlOutputDevice;
import su.plo.voice.proto.data.pos.Pos3d;

public abstract class BaseAlSource
implements AlSource {
    protected final PlasmoVoiceClient client;
    protected final AlOutputDevice device;
    protected final int format;
    protected int pointer;
    private Pos3d position;

    protected BaseAlSource(PlasmoVoiceClient client, AlOutputDevice device, boolean stereo, int pointer) {
        this.client = client;
        this.device = device;
        this.pointer = pointer;
        this.format = stereo ? 4355 : 4353;
    }

    @Override
    public boolean isClosed() {
        return (long)this.pointer == 0L;
    }

    @Override
    public AlAudioDevice getDevice() {
        return this.device;
    }

    @Override
    public long getPointer() {
        return this.pointer;
    }

    @Override
    public void play() {
        AlUtil.checkDeviceContext(this.device);
        AlSourcePlayEvent event = new AlSourcePlayEvent(this);
        this.client.getEventBus().call(event);
        if (event.isCancelled()) {
            return;
        }
        AL11.alSourcePlay((int)this.pointer);
        AlUtil.checkErrors("Source pause");
    }

    @Override
    public void stop() {
        AlUtil.checkDeviceContext(this.device);
        AlSourceStopEvent event = new AlSourceStopEvent(this);
        this.client.getEventBus().call(event);
        if (event.isCancelled()) {
            return;
        }
        AL11.alSourceStop((int)this.pointer);
        AlUtil.checkErrors("Source pause");
    }

    @Override
    public void pause() {
        AlUtil.checkDeviceContext(this.device);
        AlSourcePauseEvent event = new AlSourcePauseEvent(this);
        this.client.getEventBus().call(event);
        if (event.isCancelled()) {
            return;
        }
        AL11.alSourcePause((int)this.pointer);
        AlUtil.checkErrors("Source pause");
    }

    @Override
    public AlSource.State getState() {
        return AlSource.State.fromInt(this.getInt(4112));
    }

    @Override
    public float getPitch() {
        return this.getFloat(4099);
    }

    @Override
    public void setPitch(float pitch) {
        this.setFloat(4099, pitch);
    }

    @Override
    public float getVolume() {
        return this.getFloat(4106);
    }

    @Override
    public void setVolume(float volume) {
        AlUtil.checkDeviceContext(this.device);
        this.setFloat(4106, volume);
    }

    @Override
    public boolean isRelative() {
        AlUtil.checkDeviceContext(this.device);
        return this.getInt(514) == 1;
    }

    @Override
    public void setRelative(boolean relative) {
        AlUtil.checkDeviceContext(this.device);
        this.setInt(514, relative ? 1 : 0);
    }

    @Override
    public int getInt(int param) {
        AlUtil.checkDeviceContext(this.device);
        if (this.isClosed()) {
            return -1;
        }
        int value = AL11.alGetSourcei((int)this.pointer, (int)param);
        AlUtil.checkErrors("Get source int " + param);
        return value;
    }

    @Override
    public void setInt(int param, int value) {
        AlUtil.checkDeviceContext(this.device);
        if (this.isClosed()) {
            return;
        }
        if (!this.callParamEvent(param, value)) {
            return;
        }
        AL11.alSourcei((int)this.pointer, (int)param, (int)value);
        AlUtil.checkErrors("Set source int " + param + ": " + value);
    }

    @Override
    public void getIntArray(int param, int[] values2) {
        AlUtil.checkDeviceContext(this.device);
        if (this.isClosed()) {
            return;
        }
        AL11.alGetSourceiv((int)this.pointer, (int)param, (int[])values2);
        AlUtil.checkErrors("Get source int[] " + param);
    }

    @Override
    public void setIntArray(int param, int[] values2) {
        AlUtil.checkDeviceContext(this.device);
        if (this.isClosed()) {
            return;
        }
        if (!this.callParamEvent(param, values2)) {
            return;
        }
        AL11.alSourceiv((int)this.pointer, (int)param, (int[])values2);
        AlUtil.checkErrors("Set source int[] " + param + ": " + Arrays.toString(values2));
    }

    @Override
    public float getFloat(int param) {
        AlUtil.checkDeviceContext(this.device);
        if (this.isClosed()) {
            return -1.0f;
        }
        float value = AL11.alGetSourcei((int)this.pointer, (int)param);
        AlUtil.checkErrors("Get source float " + param);
        return value;
    }

    @Override
    public void setFloat(int param, float value) {
        AlUtil.checkDeviceContext(this.device);
        if (this.isClosed()) {
            return;
        }
        if (!this.callParamEvent(param, Float.valueOf(value))) {
            return;
        }
        AL11.alSourcef((int)this.pointer, (int)param, (float)value);
        AlUtil.checkErrors("Set source float " + param + ": " + value);
    }

    @Override
    public void getFloatArray(int param, float[] values2) {
        AlUtil.checkDeviceContext(this.device);
        if (this.isClosed()) {
            return;
        }
        AL11.alGetSourcefv((int)this.pointer, (int)param, (float[])values2);
        AlUtil.checkErrors("Get source float[] " + param);
    }

    @Override
    public void setFloatArray(int param, float[] values2) {
        AlUtil.checkDeviceContext(this.device);
        if (this.isClosed()) {
            return;
        }
        if (!this.callParamEvent(param, values2)) {
            return;
        }
        AL11.alSourcefv((int)this.pointer, (int)param, (float[])values2);
        AlUtil.checkErrors("Set source float[] " + param + ": " + Arrays.toString(values2));
    }

    private boolean callParamEvent(int param, Object value) {
        AlSourceUpdateParamEvent event = new AlSourceUpdateParamEvent(this, param, value);
        return this.client.getEventBus().call(event);
    }
}

