/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.device;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.device.InputDevice;
import su.plo.voice.api.client.event.audio.device.DeviceClosedEvent;
import su.plo.voice.api.client.event.audio.device.DeviceOpenEvent;
import su.plo.voice.api.client.event.audio.device.DevicePreOpenEvent;
import su.plo.voice.api.util.AudioUtil;
import su.plo.voice.client.audio.device.BaseAudioDevice;

public final class JavaxInputDevice
extends BaseAudioDevice
implements InputDevice {
    private TargetDataLine device;

    public JavaxInputDevice(PlasmoVoiceClient client, @Nullable String name, @NotNull AudioFormat format) throws DeviceException {
        super(client, name, format);
        this.open();
    }

    @Override
    public synchronized void close() {
        if (!this.isOpen()) {
            this.device.stop();
            this.device.flush();
            this.device.close();
            this.device = null;
        }
        this.getVoiceClient().getEventBus().call(new DeviceClosedEvent(this));
    }

    @Override
    public boolean isOpen() {
        return this.device != null && this.device.isOpen();
    }

    @Override
    public void start() {
        if (!this.isOpen()) {
            return;
        }
        this.device.start();
    }

    @Override
    public void stop() {
        if (!this.isOpen()) {
            return;
        }
        this.device.stop();
        this.device.flush();
    }

    @Override
    public int available() {
        return this.device.available();
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public short[] read(int bufferSize) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Device is not open");
        }
        byte[] samples = new byte[bufferSize];
        int read = this.device.read(samples, 0, bufferSize);
        if (read == -1) {
            return null;
        }
        return AudioUtil.bytesToShorts(samples);
    }

    @Override
    protected void open() throws DeviceException {
        if (this.isOpen()) {
            throw new DeviceException("Device is already open");
        }
        DevicePreOpenEvent preOpenEvent = new DevicePreOpenEvent(this);
        this.getVoiceClient().getEventBus().call(preOpenEvent);
        if (preOpenEvent.isCancelled()) {
            throw new DeviceException("Device opening has been canceled");
        }
        try {
            this.device = this.openDevice();
            this.device.open(this.getFormat());
        }
        catch (LineUnavailableException e) {
            throw new DeviceException("Failed to open javax device", e);
        }
        BaseVoice.LOGGER.info("Device {} initialized", (Object)this.getName());
        this.getVoiceClient().getEventBus().call(new DeviceOpenEvent(this));
    }

    private TargetDataLine openDevice() throws DeviceException {
        Mixer.Info[] mixers;
        AudioFormat format = this.getFormat();
        String deviceName = this.getName();
        for (Mixer.Info mixerInfo : mixers = AudioSystem.getMixerInfo()) {
            String lineName;
            DataLine.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo = new DataLine.Info(TargetDataLine.class, format)) || !(lineName = mixerInfo.getName()).equals(deviceName)) continue;
            try {
                return (TargetDataLine)mixer.getLine(lineInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new DeviceException("Device not found");
    }
}

