/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.device;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALUtil;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.AudioDevice;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.device.DeviceFactory;
import su.plo.voice.client.audio.device.AlOutputDevice;

public final class AlOutputDeviceFactory
implements DeviceFactory {
    private final PlasmoVoiceClient voiceClient;

    @Override
    public AudioDevice openDevice(@NotNull AudioFormat format, @Nullable String deviceName) throws DeviceException {
        Preconditions.checkNotNull((Object)format, (Object)"format cannot be null");
        if (Strings.isNullOrEmpty((String)deviceName)) {
            deviceName = this.getDefaultDeviceName();
        }
        return new AlOutputDevice(this.voiceClient, deviceName, format);
    }

    @Override
    public String getDefaultDeviceName() {
        return ALC11.alcGetString((long)0L, (int)4115);
    }

    @Override
    public ImmutableList<String> getDeviceNames() {
        List devices = ALUtil.getStringList((long)0L, (int)4115);
        return devices == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)devices);
    }

    @Override
    public String getType() {
        return "AL_OUTPUT";
    }

    public AlOutputDeviceFactory(PlasmoVoiceClient voiceClient) {
        this.voiceClient = voiceClient;
    }
}

