/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.server.mute;

import su.plo.lib.api.chat.MinecraftTextComponent;

public enum MuteDurationUnit {
    SECOND(1000L, "pv.mutes.durations.seconds"),
    MINUTE(MuteDurationUnit.SECOND.msDuration * 60L, "pv.mutes.durations.minutes"),
    HOUR(MuteDurationUnit.MINUTE.msDuration * 60L, "pv.mutes.durations.hours"),
    DAY(MuteDurationUnit.HOUR.msDuration * 24L, "pv.mutes.durations.days"),
    WEEK(MuteDurationUnit.DAY.msDuration * 7L, "pv.mutes.durations.weeks"),
    TIMESTAMP(1L, "pv.mutes.durations.seconds");

    private final long msDuration;
    private final String translationKey;

    private MuteDurationUnit(long msDuration, String translationKey) {
        this.msDuration = msDuration;
        this.translationKey = translationKey;
    }

    public long multiply(long duration) {
        return duration * this.msDuration;
    }

    public MinecraftTextComponent translate(long duration) {
        if (this == TIMESTAMP) {
            long diff = duration - System.currentTimeMillis();
            if (diff <= 0L) {
                throw new IllegalArgumentException("TIMESTAMP duration should be in the future");
            }
            return MinecraftTextComponent.translatable(this.translationKey, diff / 1000L);
        }
        return MinecraftTextComponent.translatable(this.translationKey, duration);
    }
}

