/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.server.audio.source;

import java.util.Collection;
import java.util.UUID;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.audio.source.AudioSource;
import su.plo.voice.api.server.audio.line.BaseServerSourceLine;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.proto.data.audio.source.SourceInfo;

public interface ServerAudioSource<S extends SourceInfo>
extends AudioSource<S> {
    @NotNull
    public AddonContainer getAddon();

    @NotNull
    public UUID getId();

    @NotNull
    public BaseServerSourceLine getLine();

    public int getState();

    public void setAngle(int var1);

    public void setIconVisible(boolean var1);

    public void setStereo(boolean var1);

    public void setName(@Nullable String var1);

    public void setDirty();

    public boolean isIconVisible();

    public void addFilter(Predicate<VoicePlayer> var1);

    public void removeFilter(Predicate<VoicePlayer> var1);

    @NotNull
    public Collection<Predicate<VoicePlayer>> getFilters();

    public void clearFilters();

    default public void remove() {
        this.getLine().removeSource(this);
    }

    public boolean matchFilters(@NotNull VoicePlayer var1);

    default public boolean notMatchFilters(@NotNull VoicePlayer player) {
        return !this.matchFilters(player);
    }
}

