/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.server.audio.capture;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.event.EventPriority;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.capture.SelfActivationInfo;
import su.plo.voice.api.server.audio.capture.ServerActivation;
import su.plo.voice.api.server.audio.line.ServerSourceLine;
import su.plo.voice.api.server.audio.source.ServerAudioSource;
import su.plo.voice.api.server.audio.source.ServerPlayerSource;
import su.plo.voice.api.server.event.audio.source.ServerSourcePacketEvent;
import su.plo.voice.api.server.event.connection.UdpClientDisconnectedEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.SourceAudioEndPacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceInfoPacket;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerAudioEndPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.proto.packets.udp.serverbound.PlayerAudioPacket;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001-B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ!\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00122\u0006\u0010#\u001a\u00020$H\u0007J\u0010\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020'H\u0007J\"\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020!2\b\b\u0002\u0010*\u001a\u00020+H\u0002J*\u0010,\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010*\u001a\u00020+H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006."}, d2={"Lsu/plo/voice/api/server/audio/capture/ProximityServerActivationHelper;", "", "voiceServer", "Lsu/plo/voice/api/server/PlasmoVoiceServer;", "activation", "Lsu/plo/voice/api/server/audio/capture/ServerActivation;", "sourceLine", "Lsu/plo/voice/api/server/audio/line/ServerSourceLine;", "distanceSupplier", "Lsu/plo/voice/api/server/audio/capture/ProximityServerActivationHelper$DistanceSupplier;", "(Lsu/plo/voice/api/server/PlasmoVoiceServer;Lsu/plo/voice/api/server/audio/capture/ServerActivation;Lsu/plo/voice/api/server/audio/line/ServerSourceLine;Lsu/plo/voice/api/server/audio/capture/ProximityServerActivationHelper$DistanceSupplier;)V", "getActivation", "()Lsu/plo/voice/api/server/audio/capture/ServerActivation;", "selfActivationInfo", "Lsu/plo/voice/api/server/audio/capture/SelfActivationInfo;", "sourceByPlayerId", "", "Ljava/util/UUID;", "Lsu/plo/voice/api/server/audio/source/ServerPlayerSource;", "getSourceLine", "()Lsu/plo/voice/api/server/audio/line/ServerSourceLine;", "getPlayerSource", "player", "Lsu/plo/voice/api/server/player/VoiceServerPlayer;", "isStereo", "", "(Lsu/plo/voice/api/server/player/VoiceServerPlayer;Ljava/lang/Boolean;)Lsu/plo/voice/api/server/audio/source/ServerPlayerSource;", "onActivation", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$Result;", "Lsu/plo/voice/api/server/player/VoicePlayer;", "packet", "Lsu/plo/voice/proto/packets/udp/serverbound/PlayerAudioPacket;", "onActivationEnd", "Lsu/plo/voice/proto/packets/tcp/serverbound/PlayerAudioEndPacket;", "onClientDisconnected", "event", "Lsu/plo/voice/api/server/event/connection/UdpClientDisconnectedEvent;", "onSourceSendPacket", "", "Lsu/plo/voice/api/server/event/audio/source/ServerSourcePacketEvent;", "sendAudioEndPacket", "source", "distance", "", "sendAudioPacket", "DistanceSupplier", "server"})
public final class ProximityServerActivationHelper {
    @NotNull
    private final ServerActivation activation;
    @NotNull
    private final ServerSourceLine sourceLine;
    @Nullable
    private final DistanceSupplier distanceSupplier;
    @NotNull
    private final SelfActivationInfo selfActivationInfo;
    @NotNull
    private final Map<UUID, ServerPlayerSource> sourceByPlayerId;

    public ProximityServerActivationHelper(@NotNull PlasmoVoiceServer voiceServer, @NotNull ServerActivation activation, @NotNull ServerSourceLine sourceLine, @Nullable DistanceSupplier distanceSupplier) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(activation, "activation");
        Intrinsics.checkNotNullParameter(sourceLine, "sourceLine");
        this.activation = activation;
        this.sourceLine = sourceLine;
        this.distanceSupplier = distanceSupplier;
        this.selfActivationInfo = new SelfActivationInfo(voiceServer.getUdpConnectionManager());
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "newConcurrentMap()");
        this.sourceByPlayerId = concurrentMap;
        this.activation.onPlayerActivation(this::onActivation);
        this.activation.onPlayerActivationEnd(this::onActivationEnd);
    }

    public /* synthetic */ ProximityServerActivationHelper(PlasmoVoiceServer plasmoVoiceServer, ServerActivation serverActivation, ServerSourceLine serverSourceLine, DistanceSupplier distanceSupplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            distanceSupplier = null;
        }
        this(plasmoVoiceServer, serverActivation, serverSourceLine, distanceSupplier);
    }

    @NotNull
    public final ServerActivation getActivation() {
        return this.activation;
    }

    @NotNull
    public final ServerSourceLine getSourceLine() {
        return this.sourceLine;
    }

    @EventSubscribe(priority=EventPriority.HIGHEST)
    public final void onSourceSendPacket(@NotNull ServerSourcePacketEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ServerAudioSource serverAudioSource = event.getSource();
        ServerPlayerSource serverPlayerSource = serverAudioSource instanceof ServerPlayerSource ? (ServerPlayerSource)serverAudioSource : null;
        if (serverPlayerSource == null) {
            return;
        }
        ServerPlayerSource source = serverPlayerSource;
        if (!this.selfActivationInfo.getLastPlayerActivationIds().containsKey(source.getPlayer().getInstance().getUUID())) {
            return;
        }
        if (event.getPacket() instanceof SourceInfoPacket) {
            Packet<?> packet = event.getPacket();
            if (packet == null) {
                throw new NullPointerException("null cannot be cast to non-null type su.plo.voice.proto.packets.tcp.clientbound.SourceInfoPacket");
            }
            this.selfActivationInfo.updateSelfSourceInfo(source.getPlayer(), source, ((SourceInfoPacket)packet).getSourceInfo());
        }
    }

    @EventSubscribe
    @Nullable
    public final ServerPlayerSource onClientDisconnected(@NotNull UdpClientDisconnectedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        return this.sourceByPlayerId.remove(event.getConnection().getPlayer().getInstance().getUUID());
    }

    private final ServerActivation.Result onActivation(VoicePlayer player, PlayerAudioPacket packet) {
        short distance;
        ServerPlayerSource serverPlayerSource;
        ServerPlayerSource it = serverPlayerSource = this.getPlayerSource((VoiceServerPlayer)player, packet.isStereo());
        boolean bl = false;
        DistanceSupplier distanceSupplier = this.distanceSupplier;
        Short s = distanceSupplier == null ? null : Short.valueOf(distanceSupplier.getDistance((VoiceServerPlayer)player, packet));
        short s2 = distance = s == null ? packet.getDistance() : s.shortValue();
        if (this.sendAudioPacket((VoiceServerPlayer)player, it, packet, distance)) {
            return ServerActivation.Result.HANDLED;
        }
        return ServerActivation.Result.IGNORED;
    }

    private final ServerActivation.Result onActivationEnd(VoicePlayer player, PlayerAudioEndPacket packet) {
        short distance;
        ServerPlayerSource serverPlayerSource;
        ServerPlayerSource it = serverPlayerSource = ProximityServerActivationHelper.getPlayerSource$default(this, (VoiceServerPlayer)player, null, 2, null);
        boolean bl = false;
        DistanceSupplier distanceSupplier = this.distanceSupplier;
        Short s = distanceSupplier == null ? null : Short.valueOf(distanceSupplier.getDistance((VoiceServerPlayer)player, packet));
        short s2 = distance = s == null ? packet.getDistance() : s.shortValue();
        if (this.sendAudioEndPacket(it, packet, distance)) {
            return ServerActivation.Result.HANDLED;
        }
        return ServerActivation.Result.IGNORED;
    }

    private final boolean sendAudioEndPacket(ServerPlayerSource source, PlayerAudioEndPacket packet, short distance) {
        SourceAudioEndPacket sourceEndPacket = new SourceAudioEndPacket(source.getId(), packet.getSequenceNumber());
        if (source.sendPacket(sourceEndPacket, distance)) {
            source.getPlayer().sendPacket(sourceEndPacket);
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean sendAudioEndPacket$default(ProximityServerActivationHelper proximityServerActivationHelper, ServerPlayerSource serverPlayerSource, PlayerAudioEndPacket playerAudioEndPacket, short s, int n, Object object) {
        if ((n & 4) != 0) {
            s = playerAudioEndPacket.getDistance();
        }
        return proximityServerActivationHelper.sendAudioEndPacket(serverPlayerSource, playerAudioEndPacket, s);
    }

    private final boolean sendAudioPacket(VoiceServerPlayer player, ServerPlayerSource source, PlayerAudioPacket packet, short distance) {
        SourceAudioPacket sourcePacket = new SourceAudioPacket(packet.getSequenceNumber(), (byte)source.getState(), packet.getData(), source.getId(), distance);
        if (source.sendAudioPacket(sourcePacket, distance, packet.getActivationId())) {
            this.selfActivationInfo.sendAudioInfo(player, source, packet.getActivationId(), sourcePacket);
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean sendAudioPacket$default(ProximityServerActivationHelper proximityServerActivationHelper, VoiceServerPlayer voiceServerPlayer, ServerPlayerSource serverPlayerSource, PlayerAudioPacket playerAudioPacket, short s, int n, Object object) {
        if ((n & 8) != 0) {
            s = playerAudioPacket.getDistance();
        }
        return proximityServerActivationHelper.sendAudioPacket(voiceServerPlayer, serverPlayerSource, playerAudioPacket, s);
    }

    /*
     * WARNING - void declaration
     */
    private final ServerPlayerSource getPlayerSource(VoiceServerPlayer player, Boolean isStereo) {
        Object object;
        void $this$getOrPut$iv;
        Map<UUID, ServerPlayerSource> map2 = this.sourceByPlayerId;
        UUID uUID = player.getInstance().getUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "player.instance.uuid");
        UUID key$iv = uUID;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ServerPlayerSource answer$iv = ServerSourceLine.createPlayerSource$default(this.getSourceLine(), player, false, null, 6, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        map2 = object;
        ServerPlayerSource $this$getPlayerSource_u24lambda_u2d4 = (ServerPlayerSource)((Object)map2);
        boolean bl = false;
        Boolean bl2 = isStereo;
        if (bl2 != null) {
            boolean isStereo2 = bl2;
            boolean bl3 = false;
            $this$getPlayerSource_u24lambda_u2d4.setStereo(isStereo2 && this.getActivation().isStereoSupported());
        }
        return (ServerPlayerSource)((Object)map2);
    }

    static /* synthetic */ ServerPlayerSource getPlayerSource$default(ProximityServerActivationHelper proximityServerActivationHelper, VoiceServerPlayer voiceServerPlayer, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        return proximityServerActivationHelper.getPlayerSource(voiceServerPlayer, bl);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lsu/plo/voice/api/server/audio/capture/ProximityServerActivationHelper$DistanceSupplier;", "", "getDistance", "", "player", "Lsu/plo/voice/api/server/player/VoiceServerPlayer;", "packet", "Lsu/plo/voice/proto/packets/tcp/serverbound/PlayerAudioEndPacket;", "Lsu/plo/voice/proto/packets/udp/serverbound/PlayerAudioPacket;", "server"})
    public static interface DistanceSupplier {
        public short getDistance(@NotNull VoiceServerPlayer var1, @NotNull PlayerAudioPacket var2);

        public short getDistance(@NotNull VoiceServerPlayer var1, @NotNull PlayerAudioEndPacket var2);
    }
}

