/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.addon;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.BaseVoice;
import su.plo.voice.addon.PlasmoVoiceAddon;
import su.plo.voice.addon.VoiceAddon;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.addon.AddonDependency;
import su.plo.voice.api.addon.AddonInitializer;
import su.plo.voice.api.addon.AddonLoaderScope;
import su.plo.voice.api.addon.AddonManager;
import su.plo.voice.api.addon.annotation.Addon;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0006\u0010\u0017\u001a\u00020\u0010J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\nH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lsu/plo/voice/addon/VoiceAddonManager;", "Lsu/plo/voice/api/addon/AddonManager;", "voice", "Lsu/plo/voice/BaseVoice;", "(Lsu/plo/voice/BaseVoice;)V", "addonById", "", "", "Lsu/plo/voice/api/addon/AddonContainer;", "addonByInstance", "", "initialized", "", "initializedAddons", "", "clear", "", "getAddon", "Ljava/util/Optional;", "instance", "id", "initializeAddon", "addon", "initializeLoadedAddons", "isLoaded", "load", "addonObject", "loadAddon", "shutdownAddon", "unload", "common"})
public final class VoiceAddonManager
implements AddonManager {
    @NotNull
    private final BaseVoice voice;
    @NotNull
    private final Map<Object, AddonContainer> addonByInstance;
    @NotNull
    private final Map<String, AddonContainer> addonById;
    @NotNull
    private final Set<String> initializedAddons;
    private boolean initialized;

    public VoiceAddonManager(@NotNull BaseVoice voice) {
        Intrinsics.checkNotNullParameter(voice, "voice");
        this.voice = voice;
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue(hashMap, "newHashMap()");
        this.addonByInstance = hashMap;
        hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue(hashMap, "newHashMap()");
        this.addonById = hashMap;
        this.initializedAddons = new HashSet();
        AddonContainer voiceAddon = new PlasmoVoiceAddon(this.voice, AddonLoaderScope.ANY);
        Map<Object, AddonContainer> map2 = this.addonById;
        Object object = "plasmovoice";
        map2.put((String)object, voiceAddon);
        map2 = this.addonByInstance;
        object = this.voice;
        map2.put((String)object, voiceAddon);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void load(@NotNull Object addonObject) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Collection<AddonDependency> collection;
        Iterable $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter(addonObject, "addonObject");
        Class<?> addonClass = addonObject.getClass();
        if (!addonClass.isAnnotationPresent(Addon.class)) {
            boolean $i$a$-require-VoiceAddonManager$load$22 = false;
            String $i$a$-require-VoiceAddonManager$load$22 = "Addon object must be annotated with @Addon";
            throw new IllegalArgumentException($i$a$-require-VoiceAddonManager$load$22.toString());
        }
        Addon addon = addonClass.getAnnotation(Addon.class);
        Object[] objectArray = addon.authors();
        List list = Lists.newArrayList((Object[])Arrays.copyOf(objectArray, objectArray.length));
        objectArray = addon.dependencies();
        List list2 = list;
        String string = addon.version();
        AddonLoaderScope addonLoaderScope = addon.scope();
        String string2 = Strings.emptyToNull((String)addon.name()) == null ? addon.id() : addon.name();
        String string3 = addon.id();
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void dependency;
            void var14_26 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AddonDependency(dependency.id(), dependency.optional(), dependency.mod()));
        }
        collection = (List)destination$iv$iv;
        Class<?> clazz = addonClass;
        Collection<AddonDependency> collection2 = collection;
        List list3 = list2;
        String string4 = string;
        AddonLoaderScope addonLoaderScope2 = addonLoaderScope;
        String string5 = string2;
        String string6 = string3;
        VoiceAddon addonContainer = new VoiceAddon(string6, string5, addonLoaderScope2, string4, list3, (List<AddonDependency>)collection2, clazz);
        $this$map$iv = addonContainer.getDependencies();
        Intrinsics.checkNotNullExpressionValue($this$map$iv, "addonContainer.dependencies");
        Iterable $this$filter$iv = $this$map$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AddonDependency it = (AddonDependency)element$iv$iv;
            boolean bl = false;
            if (!(!it.isOptional() && !it.isMod())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AddonDependency dependency = (AddonDependency)element$iv;
            boolean bl = false;
            if (this.addonById.containsKey(dependency.getId())) continue;
            BaseVoice.LOGGER.error("Addon \"{}\" is missing dependency \"{}\"", (Object)addonContainer.getId(), (Object)dependency.getId());
            return;
        }
        addonContainer.setInstance(addonObject);
        this.loadAddon(addonContainer);
    }

    @Override
    public synchronized void unload(@NotNull Object addonObject) {
        Intrinsics.checkNotNullParameter(addonObject, "addonObject");
        Class<?> addonClass = addonObject.getClass();
        if (!addonClass.isAnnotationPresent(Addon.class)) {
            boolean bl = false;
            String string = "Addon object must be annotated with @Addon";
            throw new IllegalArgumentException(string.toString());
        }
        Addon addon = addonClass.getAnnotation(Addon.class);
        if (!this.initializedAddons.contains(addon.id())) {
            return;
        }
        AddonContainer addonContainer = this.addonById.get(addon.id());
        if (addonContainer != null) {
            AddonContainer it = addonContainer;
            boolean bl = false;
            this.shutdownAddon(it);
        }
    }

    @Override
    public boolean isLoaded(@NotNull String id) {
        Intrinsics.checkNotNullParameter(id, "id");
        return this.addonById.containsKey(id);
    }

    @Override
    @NotNull
    public Optional<AddonContainer> getAddon(@NotNull String id) {
        Intrinsics.checkNotNullParameter(id, "id");
        Optional<AddonContainer> optional = Optional.ofNullable(this.addonById.get(id));
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(addonById[id])");
        return optional;
    }

    @Override
    @NotNull
    public Optional<AddonContainer> getAddon(@NotNull Object instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        Optional<AddonContainer> optional = Optional.ofNullable(this.addonByInstance.get(instance));
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(addonByInstance[instance])");
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void initializeLoadedAddons() {
        void $this$filterTo$iv$iv;
        if (this.initialized) {
            return;
        }
        Iterable $this$filter$iv = this.addonById.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AddonContainer it = (AddonContainer)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getId(), "plasmovoice"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AddonContainer p0 = (AddonContainer)element$iv;
            boolean bl = false;
            this.initializeAddon(p0);
        }
        this.initialized = true;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void clear() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.addonById.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AddonContainer it = (AddonContainer)element$iv$iv;
            boolean bl = false;
            if (!this.initializedAddons.contains(it.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AddonContainer addon = (AddonContainer)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(addon.getId(), "plasmovoice")) continue;
            this.shutdownAddon(addon);
        }
        this.initialized = false;
    }

    private final void loadAddon(AddonContainer addon) {
        if (this.initialized) {
            AddonContainer addonContainer = this.addonById.get(addon.getId());
            if (addonContainer != null) {
                AddonContainer oldAddon = addonContainer;
                boolean bl = false;
                this.voice.getEventBus().unregister(oldAddon.getInstance().get());
            }
        }
        Object addonInstance = addon.getInstance().get();
        Object object = new Module[]{this.voice.createInjectModule()};
        Injector injector = Guice.createInjector((Module[])object);
        injector.injectMembers(addonInstance);
        object = this.addonById;
        String string = addon.getId();
        Intrinsics.checkNotNullExpressionValue(string, "addon.id");
        object.put(string, addon);
        object = this.addonByInstance;
        Intrinsics.checkNotNullExpressionValue(addonInstance, "addonInstance");
        string = addonInstance;
        object.put(string, addon);
        if (this.initialized) {
            this.initializeAddon(addon);
        }
    }

    private final void initializeAddon(AddonContainer addon) {
        Object addonInstance = addon.getInstance().get();
        if (addonInstance instanceof AddonInitializer) {
            ((AddonInitializer)addonInstance).onAddonInitialize();
        }
        this.voice.getEventBus().register(addonInstance, addonInstance);
        Object[] objectArray = addon.getId();
        Intrinsics.checkNotNullExpressionValue(objectArray, "addon.id");
        this.initializedAddons.add((String)objectArray);
        objectArray = new Object[]{addon.getId(), addon.getVersion(), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)addon.getAuthors())};
        BaseVoice.LOGGER.info("{} v{} by {} loaded", objectArray);
    }

    private final void shutdownAddon(AddonContainer addon) {
        Object addonInstance = addon.getInstance().get();
        if (addonInstance instanceof AddonInitializer) {
            ((AddonInitializer)addonInstance).onAddonShutdown();
        }
        this.voice.getEventBus().unregister(addon.getInstance().get());
        this.initializedAddons.remove(addon.getId());
        Object[] objectArray = new Object[]{addon.getId(), addon.getVersion(), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)addon.getAuthors())};
        BaseVoice.LOGGER.info("Addon {} v{} by {} unloaded", objectArray);
    }
}

