/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.components;

import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.shader.SolidColorShader;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UMatrixStack;

public final class IconButton
extends Button {
    private final boolean shadow;
    private final int shadowColor;
    private class_2960 iconLocation;
    private int iconColor;

    public IconButton(int x, int y, int width, int height, @NotNull Button.OnPress pressAction, @NotNull Button.OnTooltip tooltipAction, @NotNull class_2960 iconLocation, boolean shadow) {
        this(x, y, width, height, pressAction, tooltipAction, iconLocation, shadow, -1);
    }

    public IconButton(int x, int y, int width, int height, @NotNull Button.OnPress pressAction, @NotNull Button.OnTooltip tooltipAction, @NotNull class_2960 iconLocation, boolean shadow, int shadowColor) {
        super(x, y, width, height, MinecraftTextComponent.empty(), pressAction, tooltipAction);
        this.iconLocation = iconLocation;
        this.shadow = shadow;
        this.shadowColor = shadowColor;
    }

    @Override
    public void renderButton(@NotNull UMatrixStack stack, int mouseX, int mouseY, float delta) {
        int iconColor;
        super.renderButton(stack, mouseX, mouseY, delta);
        UGraphics.bindTexture(0, this.iconLocation);
        UGraphics.enableDepth();
        if (this.hasShadow()) {
            int shadowColor = this.active ? this.shadowColor : -6250336;
            try {
                SolidColorShader.bind();
                RenderUtil.blitWithActiveShader(stack, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR, this.x + 2, this.x + 2 + 16, this.y + 3, this.y + 3 + 16, 0, 0.0f, 1.0f, 0.0f, 1.0f, (int)((double)(shadowColor >> 16 & 0xFF) * 0.25), (int)((double)(shadowColor >> 8 & 0xFF) * 0.25), (int)((double)(shadowColor & 0xFF) * 0.25), shadowColor >> 24 & 0xFF);
                SolidColorShader.unbind();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((iconColor = this.iconColor) == 0 && !this.active) {
            iconColor = -6250336;
        }
        if (iconColor != 0) {
            float alpha = (float)(iconColor >> 24 & 0xFF) / 255.0f;
            float red = (float)(iconColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(iconColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(iconColor & 0xFF) / 255.0f;
            UGraphics.color4f(red, green, blue, alpha);
        } else {
            UGraphics.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
        RenderUtil.blit(stack, this.x + 2, this.y + 2, 0.0f, 0.0f, 16, 16, 16, 16);
        UGraphics.disableDepth();
        UGraphics.color4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean hasShadow() {
        return this.shadow;
    }

    public class_2960 getIconLocation() {
        return this.iconLocation;
    }

    public void setIconLocation(class_2960 iconLocation) {
        this.iconLocation = iconLocation;
    }

    public int getIconColor() {
        return this.iconColor;
    }

    public void setIconColor(int iconColor) {
        this.iconColor = iconColor;
    }
}

