/*
 * Decompiled with CFR 0.152.
 */
package su.plo.config.entry;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import su.plo.config.entry.SerializableConfigEntry;

public class ConfigEntry<E>
implements SerializableConfigEntry {
    protected final List<Consumer<E>> changeListeners = new CopyOnWriteArrayList<Consumer<E>>();
    protected transient E defaultValue;
    protected E value = null;
    protected boolean disabled;

    public ConfigEntry(E defaultValue) {
        this.defaultValue = defaultValue;
        this.reset();
    }

    public void reset() {
        this.value = this.defaultValue;
        this.changeListeners.forEach(listener -> listener.accept(this.value));
    }

    public boolean isDefault() {
        return Objects.equals(this.defaultValue, this.value);
    }

    public void set(E value) {
        if (!this.value.equals(value)) {
            this.value = value;
            this.changeListeners.forEach(listener -> listener.accept(value));
        }
    }

    public void setDefault(E value) {
        this.defaultValue = value;
        if (this.value == null) {
            this.reset();
        }
    }

    public E getDefault() {
        return this.defaultValue;
    }

    public E value() {
        return this.value;
    }

    public void addChangeListener(Consumer<E> listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(Consumer<E> listener) {
        this.changeListeners.remove(listener);
    }

    public void clearChangeListeners() {
        this.changeListeners.clear();
    }

    @Override
    public void deserialize(Object object) {
        try {
            this.value = object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public Object serialize() {
        return this.value;
    }

    public String toString() {
        return "ConfigEntry(changeListeners=" + this.changeListeners + ", defaultValue=" + this.defaultValue + ", value=" + this.value + ", disabled=" + this.isDisabled() + ")";
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }
}

