/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.events;

import com.mojang.blaze3d.systems.RenderSystem;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.RectDebugger;
import mezz.jei.core.util.LimitedLogger;
import mezz.jei.gui.input.MouseUtil;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LimitedLogger missingBackgroundLogger = new LimitedLogger(LOGGER, Duration.ofHours(1L));
    private final IngredientListOverlay ingredientListOverlay;
    private final IScreenHelper screenHelper;
    private final BookmarkOverlay bookmarkOverlay;
    private boolean drawnOnBackground = false;

    public GuiEventHandler(IScreenHelper screenHelper, BookmarkOverlay bookmarkOverlay, IngredientListOverlay ingredientListOverlay) {
        this.screenHelper = screenHelper;
        this.bookmarkOverlay = bookmarkOverlay;
        this.ingredientListOverlay = ingredientListOverlay;
    }

    public void onGuiInit(class_437 screen) {
        Set<ImmutableRect2i> guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).map(ImmutableRect2i::new).collect(Collectors.toUnmodifiableSet());
        this.ingredientListOverlay.updateScreen(screen, guiExclusionAreas);
        this.bookmarkOverlay.updateScreen(screen, guiExclusionAreas);
    }

    public void onGuiOpen(class_437 screen) {
        this.ingredientListOverlay.updateScreen(screen, null);
        this.bookmarkOverlay.updateScreen(screen, null);
    }

    public void onDrawBackgroundPost(class_437 screen, class_332 guiGraphics) {
        class_310 minecraft = class_310.method_1551();
        Set<ImmutableRect2i> guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).map(ImmutableRect2i::new).collect(Collectors.toUnmodifiableSet());
        this.ingredientListOverlay.updateScreen(screen, guiExclusionAreas);
        this.bookmarkOverlay.updateScreen(screen, guiExclusionAreas);
        this.drawnOnBackground = true;
        double mouseX = MouseUtil.getX();
        double mouseY = MouseUtil.getY();
        this.ingredientListOverlay.drawScreen(minecraft, guiGraphics, (int)mouseX, (int)mouseY, minecraft.method_1488());
        this.bookmarkOverlay.drawScreen(minecraft, guiGraphics, (int)mouseX, (int)mouseY, minecraft.method_1488());
    }

    public void onDrawForeground(class_465<?> screen, class_332 guiGraphics, int mouseX, int mouseY) {
        class_310 minecraft = class_310.method_1551();
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
        poseStack.method_46416((float)(-screenHelper.getGuiLeft(screen)), (float)(-screenHelper.getGuiTop(screen)), 0.0f);
        this.bookmarkOverlay.drawOnForeground(minecraft, guiGraphics, mouseX, mouseY);
        this.ingredientListOverlay.drawOnForeground(minecraft, guiGraphics, mouseX, mouseY);
        poseStack.method_22909();
    }

    public void onDrawScreenPost(class_437 screen, class_332 guiGraphics, int mouseX, int mouseY) {
        class_310 minecraft = class_310.method_1551();
        this.ingredientListOverlay.updateScreen(screen, null);
        this.bookmarkOverlay.updateScreen(screen, null);
        if (!this.drawnOnBackground) {
            if (screen instanceof class_465) {
                String guiName = screen.getClass().getName();
                missingBackgroundLogger.log(Level.WARN, guiName, "GUI did not draw the dark background layer behind itself, this may result in display issues: {}", guiName);
            }
            this.ingredientListOverlay.drawScreen(minecraft, guiGraphics, mouseX, mouseY, minecraft.method_1488());
            this.bookmarkOverlay.drawScreen(minecraft, guiGraphics, mouseX, mouseY, minecraft.method_1488());
        }
        this.drawnOnBackground = false;
        if (screen instanceof class_465) {
            class_465 guiContainer = (class_465)screen;
            IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
            int guiLeft = screenHelper.getGuiLeft(guiContainer);
            int guiTop = screenHelper.getGuiTop(guiContainer);
            this.screenHelper.getGuiClickableArea(guiContainer, mouseX - guiLeft, mouseY - guiTop).filter(IGuiClickableArea::isTooltipEnabled).map(IGuiClickableArea::getTooltipStrings).findFirst().ifPresent(tooltipStrings -> {
                if (tooltipStrings.isEmpty()) {
                    tooltipStrings = List.of(class_2561.method_43471((String)"jei.tooltip.show.recipes"));
                }
                TooltipRenderer.drawHoveringText(guiGraphics, tooltipStrings, mouseX, mouseY);
            });
        }
        this.ingredientListOverlay.drawTooltips(minecraft, guiGraphics, mouseX, mouseY);
        this.bookmarkOverlay.drawTooltips(minecraft, guiGraphics, mouseX, mouseY);
        if (DebugConfig.isDebugModeEnabled()) {
            this.drawDebugInfoForScreen(screen, guiGraphics);
        }
    }

    public void onClientTick() {
        this.ingredientListOverlay.handleTick();
    }

    public boolean renderCompactPotionIndicators() {
        return this.ingredientListOverlay.isListDisplayed();
    }

    private void drawDebugInfoForScreen(class_437 screen, class_332 guiGraphics) {
        RectDebugger.INSTANCE.draw(guiGraphics);
        this.screenHelper.getGuiProperties(screen).ifPresent(guiProperties -> {
            Set guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).collect(Collectors.toUnmodifiableSet());
            RenderSystem.disableDepthTest();
            for (class_768 area : guiExclusionAreas) {
                guiGraphics.method_51739(class_1921.method_51784(), area.method_3321(), area.method_3322(), area.method_3321() + area.method_3319(), area.method_3322() + area.method_3320(), 0x44FF0000);
            }
            guiGraphics.method_51739(class_1921.method_51784(), guiProperties.getGuiLeft(), guiProperties.getGuiTop(), guiProperties.getGuiLeft() + guiProperties.getGuiXSize(), guiProperties.getGuiTop() + guiProperties.getGuiYSize(), 0x22CCCC00);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        });
    }
}

