/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.animatica.config;

import io.github.foundationgames.animatica.Animatica;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_7172;

public class AnimaticaConfig {
    public static String ANIMATED_TEXTURES_KEY = "animated_textures";
    public static final String FILE_NAME = "animatica.properties";
    private final class_7172<Boolean> animatedTexturesOption;
    public boolean animatedTextures;

    public AnimaticaConfig() {
        try {
            this.load();
        }
        catch (IOException e) {
            Animatica.LOG.error("Error loading config during initialization!", (Throwable)e);
        }
        this.animatedTexturesOption = class_7172.method_41751((String)"option.animatica.animated_textures", (boolean)this.animatedTextures, value -> {
            this.animatedTextures = value;
            try {
                this.save();
            }
            catch (IOException e) {
                Animatica.LOG.error("Error saving config while changing in game!", (Throwable)e);
            }
            class_310.method_1551().method_1521();
        });
    }

    public void writeTo(Properties properties) {
        properties.put(ANIMATED_TEXTURES_KEY, Boolean.toString(this.animatedTextures));
    }

    public void readFrom(Properties properties) {
        this.animatedTextures = AnimaticaConfig.boolFrom(properties.getProperty(ANIMATED_TEXTURES_KEY), true);
    }

    public Path getFile() throws IOException {
        Path file = FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
        }
        return file;
    }

    public class_7172<Boolean> getAnimatedTexturesOption() {
        return this.animatedTexturesOption;
    }

    public void save() throws IOException {
        Path file = this.getFile();
        Properties properties = new Properties();
        this.writeTo(properties);
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            properties.store(out, "Configuration file for Animatica");
        }
    }

    public void load() throws IOException {
        Path file = this.getFile();
        Properties properties = new Properties();
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            properties.load(in);
        }
        this.readFrom(properties);
    }

    private static boolean boolFrom(String s, boolean defaultVal) {
        return s == null ? defaultVal : "true".equals(s);
    }
}

