/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.zoomify;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.isxander.zoomify.Zoomify;
import dev.isxander.zoomify.config.OverlayVisibility;
import dev.isxander.zoomify.config.SoundBehaviour;
import dev.isxander.zoomify.config.SpyglassBehaviour;
import dev.isxander.zoomify.config.ZoomKeyBehaviour;
import dev.isxander.zoomify.config.ZoomifySettings;
import dev.isxander.zoomify.config.migrator.Migrator;
import dev.isxander.zoomify.utils.TransitionType;
import dev.isxander.zoomify.zoom.InstantInterpolator;
import dev.isxander.zoomify.zoom.SmoothInterpolator;
import dev.isxander.zoomify.zoom.TimedInterpolator;
import dev.isxander.zoomify.zoom.TransitionInterpolator;
import dev.isxander.zoomify.zoom.ZoomHelper;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_7157;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b=\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0004J\u000f\u0010\u0014\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0004J\u001f\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\f\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001f\u001a\u00020\u001e8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020%8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b&\u0010'R$\u0010)\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00078\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u0016\u0010-\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010'R\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0014\u00101\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00100R\u0014\u00103\u001a\u0002028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0014\u00105\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00100R$\u00106\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b6\u0010$\u001a\u0004\b7\u0010\u001dR\u0016\u00108\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u0010$R\u0014\u00109\u001a\u0002028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u00104R\u0014\u0010:\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u00100R$\u0010;\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b;\u0010$\u001a\u0004\b<\u0010\u001d\u00a8\u0006>"}, d2={"Ldev/isxander/zoomify/Zoomify;", "Lnet/fabricmc/api/ClientModInitializer;", "", "detectConflictingToast", "()V", "", "tickDelta", "", "getZoomDivisor", "(F)D", "Lnet/minecraft/class_310;", "client", "", "prevZooming", "handleSpyglass", "(Lnet/minecraft/class_310;Z)V", "mouseDelta", "mouseZoom", "(D)V", "onGameFinishedLoading", "onInitializeClient", "Lnet/minecraft/class_742;", "player", "isUsingSpyglass", "shouldRenderOverlay", "(Lnet/minecraft/class_742;Z)Z", "tick", "(Lnet/minecraft/class_310;)V", "unbindConflicting", "()Z", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "displayGui", "Z", "", "maxScrollTiers", "I", "<set-?>", "previousZoomDivisor", "D", "getPreviousZoomDivisor", "()D", "scrollSteps", "Lnet/minecraft/class_304;", "scrollZoomIn", "Lnet/minecraft/class_304;", "scrollZoomOut", "Ldev/isxander/zoomify/zoom/ZoomHelper;", "secondaryZoomHelper", "Ldev/isxander/zoomify/zoom/ZoomHelper;", "secondaryZoomKey", "secondaryZooming", "getSecondaryZooming", "shouldPlaySound", "zoomHelper", "zoomKey", "zooming", "getZooming", "<init>", "Zoomify"})
@SourceDebugExtension(value={"SMAP\nZoomify.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Zoomify.kt\ndev/isxander/zoomify/Zoomify\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,269:1\n1#2:270\n12474#3,2:271\n*S KotlinDebug\n*F\n+ 1 Zoomify.kt\ndev/isxander/zoomify/Zoomify\n*L\n256#1:271,2\n*E\n"})
public final class Zoomify
implements ClientModInitializer {
    @NotNull
    public static final Zoomify INSTANCE = new Zoomify();
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final class_304 zoomKey;
    @NotNull
    private static final class_304 secondaryZoomKey;
    @NotNull
    private static final class_304 scrollZoomIn;
    @NotNull
    private static final class_304 scrollZoomOut;
    private static boolean zooming;
    @NotNull
    private static final ZoomHelper zoomHelper;
    private static boolean secondaryZooming;
    @NotNull
    private static final ZoomHelper secondaryZoomHelper;
    private static double previousZoomDivisor;
    public static final int maxScrollTiers = 30;
    private static int scrollSteps;
    private static boolean shouldPlaySound;
    private static boolean displayGui;

    private Zoomify() {
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    public final boolean getZooming() {
        return zooming;
    }

    public final boolean getSecondaryZooming() {
        return secondaryZooming;
    }

    public final double getPreviousZoomDivisor() {
        return previousZoomDivisor;
    }

    public void onInitializeClient() {
        KeyBindingHelper.registerKeyBinding((class_304)zoomKey);
        KeyBindingHelper.registerKeyBinding((class_304)secondaryZoomKey);
        if (ZoomifySettings.INSTANCE.getKeybindScrolling()) {
            KeyBindingHelper.registerKeyBinding((class_304)scrollZoomIn);
            KeyBindingHelper.registerKeyBinding((class_304)scrollZoomOut);
        }
        ClientCommandRegistrationCallback.EVENT.register(Zoomify::onInitializeClient$lambda$1);
        ClientTickEvents.END_CLIENT_TICK.register(this::tick);
    }

    private final void tick(class_310 client) {
        boolean prevZooming = zooming;
        switch (WhenMappings.$EnumSwitchMapping$0[ZoomifySettings.INSTANCE.getZoomKeyBehaviour().ordinal()]) {
            case 1: {
                zooming = zoomKey.method_1434();
                break;
            }
            case 2: {
                while (zoomKey.method_1436()) {
                    zooming = !zooming;
                }
                break;
            }
        }
        while (secondaryZoomKey.method_1436()) {
            secondaryZooming = !secondaryZooming;
        }
        if (ZoomifySettings.INSTANCE.getKeybindScrolling()) {
            int n;
            while (scrollZoomIn.method_1436()) {
                n = scrollSteps;
                scrollSteps = n + 1;
            }
            while (scrollZoomOut.method_1436()) {
                n = scrollSteps;
                scrollSteps = n + -1;
            }
            scrollSteps = RangesKt.coerceIn((int)scrollSteps, (ClosedRange)((ClosedRange)new IntRange(0, 30)));
        }
        this.handleSpyglass(client, prevZooming);
        ZoomHelper.tick$default(zoomHelper, zooming, scrollSteps, 0.0, 4, null);
        ZoomHelper.tick$default(secondaryZoomHelper, secondaryZooming, scrollSteps, 0.0, 4, null);
        if (displayGui) {
            displayGui = false;
            client.method_1507(ZoomifySettings.INSTANCE.gui(client.field_1755));
        }
    }

    @JvmStatic
    public static final double getZoomDivisor(float tickDelta) {
        double d;
        if (!zooming) {
            if (!ZoomifySettings.INSTANCE.getRetainZoomSteps()) {
                scrollSteps = 0;
            }
            zoomHelper.reset();
        }
        double it = d = zoomHelper.getZoomDivisor(tickDelta);
        boolean bl = false;
        previousZoomDivisor = it;
        return d * secondaryZoomHelper.getZoomDivisor(tickDelta);
    }

    @JvmStatic
    public static final void mouseZoom(double mouseDelta) {
        if (mouseDelta > 0.0) {
            int n = scrollSteps;
            scrollSteps = n + 1;
        } else if (mouseDelta < 0.0) {
            int n = scrollSteps;
            scrollSteps = n + -1;
        }
        scrollSteps = RangesKt.coerceIn((int)scrollSteps, (ClosedRange)((ClosedRange)new IntRange(0, 30)));
    }

    private final void handleSpyglass(class_310 client, boolean prevZooming) {
        class_1297 cameraEntity = client.field_1719;
        if (cameraEntity instanceof class_742) {
            boolean requiresSpyglass;
            switch (WhenMappings.$EnumSwitchMapping$1[ZoomifySettings.INSTANCE.getSpyglassBehaviour().ordinal()]) {
                case 1: {
                    if (((class_742)cameraEntity).method_24518(class_1802.field_27070)) break;
                    zooming = false;
                    break;
                }
                case 2: {
                    if (((class_742)cameraEntity).method_31548().method_43256(Zoomify::handleSpyglass$lambda$3)) break;
                    zooming = false;
                    break;
                }
                case 3: {
                    if (!((class_742)cameraEntity).method_31550()) break;
                    zooming = zooming && client.field_1690.method_31044().method_31034();
                }
            }
            boolean bl = requiresSpyglass = ZoomifySettings.INSTANCE.getSpyglassBehaviour() != SpyglassBehaviour.COMBINE;
            if (requiresSpyglass && ((class_742)cameraEntity).method_31550()) {
                zooming = true;
            }
            if (shouldPlaySound && !zooming && prevZooming) {
                ((class_742)cameraEntity).method_5783(class_3417.field_26973, 1.0f, 1.0f);
            }
            shouldPlaySound = switch (WhenMappings.$EnumSwitchMapping$2[ZoomifySettings.INSTANCE.getSpyglassSoundBehaviour().ordinal()]) {
                case 1 -> false;
                case 2 -> true;
                case 3 -> {
                    if (((class_742)cameraEntity).method_31550() || requiresSpyglass && zooming && ((class_742)cameraEntity).method_24518(class_1802.field_27070)) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> {
                    if (Zoomify.shouldRenderOverlay((class_742)cameraEntity, client.field_1690.method_31044().method_31034() && ((class_742)cameraEntity).method_31550()) && requiresSpyglass) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            if (shouldPlaySound && zooming && !prevZooming) {
                ((class_742)cameraEntity).method_5783(class_3417.field_26972, 1.0f, 1.0f);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean shouldRenderOverlay(@NotNull class_742 player, boolean isUsingSpyglass) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        switch (WhenMappings.$EnumSwitchMapping$3[ZoomifySettings.INSTANCE.getSpyglassOverlayVisibility().ordinal()]) {
            case 1: {
                return false;
            }
            case 2: {
                boolean bl = zooming;
                return bl;
            }
            case 3: {
                if (isUsingSpyglass) return true;
                if (!zooming) return false;
                if (!player.method_24518(class_1802.field_27070)) return false;
                if (ZoomifySettings.INSTANCE.getSpyglassBehaviour() == SpyglassBehaviour.COMBINE) return false;
                return true;
            }
            case 4: {
                if (!zooming) return false;
                if (!player.method_31548().method_43256(Zoomify::shouldRenderOverlay$lambda$4)) return false;
                return true;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void onGameFinishedLoading() {
        if (ZoomifySettings.INSTANCE.getFirstLaunch()) {
            LOGGER.info("Zoomify detected first launch!");
            this.detectConflictingToast();
            Migrator.Companion.checkMigrations();
        }
    }

    public final boolean unbindConflicting() {
        class_310 client = class_310.method_1551();
        if (!zoomKey.method_1415()) {
            Intrinsics.checkNotNullExpressionValue((Object)client.field_1690.field_1839, (String)"allKeys");
            for (class_304 key : client.field_1690.field_1839) {
                if (Intrinsics.areEqual((Object)key, (Object)zoomKey) || !key.method_1435(zoomKey)) continue;
                client.field_1690.method_1641(key, class_3675.field_16237);
                Object[] objectArray = new Object[]{class_2561.method_43471((String)key.method_1431())};
                class_370 toast = class_370.method_29047((class_310)client, (class_370.class_371)class_370.class_371.field_2218, (class_2561)((class_2561)class_2561.method_43471((String)"zoomify.toast.unbindConflicting.name")), (class_2561)((class_2561)class_2561.method_43469((String)"zoomify.toast.unbindConflicting.description", (Object[])objectArray)));
                client.method_1566().method_1999((class_368)toast);
                return true;
            }
        }
        return false;
    }

    private final void detectConflictingToast() {
        boolean bl;
        class_310 client;
        block3: {
            client = class_310.method_1551();
            if (zoomKey.method_1415()) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)client.field_1690.field_1839, (String)"allKeys");
            Object[] $this$any$iv = client.field_1690.field_1839;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                class_304 it = (class_304)element$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)zoomKey) && it.method_1435(zoomKey))) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            Object[] objectArray = new Object[]{class_2561.method_43471((String)"zoomify.gui.category.misc")};
            class_370 toast = class_370.method_29047((class_310)client, (class_370.class_371)class_370.class_371.field_39915, (class_2561)((class_2561)class_2561.method_43471((String)"zoomify.toast.conflictingKeybind.title")), (class_2561)((class_2561)class_2561.method_43469((String)"zoomify.toast.conflictingKeybind.description", (Object[])objectArray)));
            client.method_1566().method_1999((class_368)toast);
        }
    }

    private static final int onInitializeClient$lambda$1$lambda$0(CommandContext it) {
        displayGui = true;
        return 0;
    }

    private static final void onInitializeClient$lambda$1(CommandDispatcher dispatcher, class_7157 class_71572) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"zoomify").executes(Zoomify::onInitializeClient$lambda$1$lambda$0));
    }

    private static final boolean handleSpyglass$lambda$3(class_1799 it) {
        return it.method_31574(class_1802.field_27070);
    }

    private static final boolean shouldRenderOverlay$lambda$4(class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return stack.method_31574(class_1802.field_27070);
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)"Zoomify");
        Intrinsics.checkNotNull((Object)logger);
        LOGGER = logger;
        zoomKey = new class_304("zoomify.key.zoom", class_3675.class_307.field_1668, 67, "zoomify.key.category");
        secondaryZoomKey = new class_304("zoomify.key.zoom.secondary", class_3675.class_307.field_1668, 295, "zoomify.key.category");
        scrollZoomIn = new class_304("zoomify.key.zoom.in", -1, "zoomify.key.category");
        scrollZoomOut = new class_304("zoomify.key.zoom.out", -1, "zoomify.key.category");
        zoomHelper = new ZoomHelper(new TransitionInterpolator((Function0<? extends TransitionType>)((Function0)new MutablePropertyReference0Impl((Object)ZoomifySettings.INSTANCE){

            @Nullable
            public Object get() {
                return ((ZoomifySettings)((Object)this.receiver)).getZoomInTransition();
            }

            public void set(@Nullable Object value) {
                ((ZoomifySettings)((Object)this.receiver)).setZoomInTransition((TransitionType)value);
            }
        }), (Function0<? extends TransitionType>)((Function0)new MutablePropertyReference0Impl((Object)ZoomifySettings.INSTANCE){

            @Nullable
            public Object get() {
                return ((ZoomifySettings)((Object)this.receiver)).getZoomOutTransition();
            }

            public void set(@Nullable Object value) {
                ((ZoomifySettings)((Object)this.receiver)).setZoomOutTransition((TransitionType)value);
            }
        }), (Function0<Double>)((Function0)new MutablePropertyReference0Impl((Object)ZoomifySettings.INSTANCE){

            @Nullable
            public Object get() {
                return ((ZoomifySettings)((Object)this.receiver)).getZoomInTime();
            }

            public void set(@Nullable Object value) {
                ((ZoomifySettings)((Object)this.receiver)).setZoomInTime(((Number)value).doubleValue());
            }
        }), (Function0<Double>)((Function0)new MutablePropertyReference0Impl((Object)ZoomifySettings.INSTANCE){

            @Nullable
            public Object get() {
                return ((ZoomifySettings)((Object)this.receiver)).getZoomOutTime();
            }

            public void set(@Nullable Object value) {
                ((ZoomifySettings)((Object)this.receiver)).setZoomOutTime(((Number)value).doubleValue());
            }
        })), new SmoothInterpolator((Function0<Double>)((Function0)zoomHelper.5.INSTANCE)), (Function0<Integer>)((Function0)new MutablePropertyReference0Impl((Object)ZoomifySettings.INSTANCE){

            @Nullable
            public Object get() {
                return ((ZoomifySettings)((Object)this.receiver)).getInitialZoom();
            }

            public void set(@Nullable Object value) {
                ((ZoomifySettings)((Object)this.receiver)).setInitialZoom(((Number)value).intValue());
            }
        }), (Function0<Integer>)((Function0)new MutablePropertyReference0Impl((Object)ZoomifySettings.INSTANCE){

            @Nullable
            public Object get() {
                return ((ZoomifySettings)((Object)this.receiver)).getScrollZoomAmount();
            }

            public void set(@Nullable Object value) {
                ((ZoomifySettings)((Object)this.receiver)).setScrollZoomAmount(((Number)value).intValue());
            }
        }), (Function0<Integer>)((Function0)new PropertyReference0Impl(INSTANCE){

            @Nullable
            public Object get() {
                return 30;
            }
        }), (Function0<Boolean>)((Function0)new MutablePropertyReference0Impl((Object)ZoomifySettings.INSTANCE){

            @Nullable
            public Object get() {
                return ((ZoomifySettings)((Object)this.receiver)).getLinearLikeSteps();
            }

            public void set(@Nullable Object value) {
                ((ZoomifySettings)((Object)this.receiver)).setLinearLikeSteps((Boolean)value);
            }
        }));
        secondaryZoomHelper = new ZoomHelper(new TimedInterpolator((Function0<Double>)((Function0)new MutablePropertyReference0Impl((Object)ZoomifySettings.INSTANCE){

            @Nullable
            public Object get() {
                return ((ZoomifySettings)((Object)this.receiver)).getSecondaryZoomInTime();
            }

            public void set(@Nullable Object value) {
                ((ZoomifySettings)((Object)this.receiver)).setSecondaryZoomInTime(((Number)value).doubleValue());
            }
        }), (Function0<Double>)((Function0)new MutablePropertyReference0Impl((Object)ZoomifySettings.INSTANCE){

            @Nullable
            public Object get() {
                return ((ZoomifySettings)((Object)this.receiver)).getSecondaryZoomOutTime();
            }

            public void set(@Nullable Object value) {
                ((ZoomifySettings)((Object)this.receiver)).setSecondaryZoomOutTime(((Number)value).doubleValue());
            }
        })), InstantInterpolator.INSTANCE, (Function0<Integer>)((Function0)new MutablePropertyReference0Impl((Object)ZoomifySettings.INSTANCE){

            @Nullable
            public Object get() {
                return ((ZoomifySettings)((Object)this.receiver)).getSecondaryZoomAmount();
            }

            public void set(@Nullable Object value) {
                ((ZoomifySettings)((Object)this.receiver)).setSecondaryZoomAmount(((Number)value).intValue());
            }
        }), (Function0<Integer>)((Function0)secondaryZoomHelper.4.INSTANCE), (Function0<Integer>)((Function0)secondaryZoomHelper.5.INSTANCE), (Function0<Boolean>)((Function0)secondaryZoomHelper.6.INSTANCE));
        previousZoomDivisor = 1.0;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[ZoomKeyBehaviour.values().length];
            try {
                nArray[ZoomKeyBehaviour.HOLD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomKeyBehaviour.TOGGLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SpyglassBehaviour.values().length];
            try {
                nArray[SpyglassBehaviour.ONLY_ZOOM_WHILE_HOLDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyglassBehaviour.ONLY_ZOOM_WHILE_CARRYING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyglassBehaviour.OVERRIDE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[SoundBehaviour.values().length];
            try {
                nArray[SoundBehaviour.NEVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SoundBehaviour.ALWAYS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SoundBehaviour.ONLY_SPYGLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SoundBehaviour.WITH_OVERLAY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[OverlayVisibility.values().length];
            try {
                nArray[OverlayVisibility.NEVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverlayVisibility.ALWAYS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverlayVisibility.HOLDING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverlayVisibility.CARRYING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

