/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.map_atlas_generation;

import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_22;
import net.minecraft.class_2960;
import net.minecraft.class_330;
import net.minecraft.class_3620;
import net.minecraft.class_4588;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.feature.map_atlas_generation.MapAtlasTexture;
import net.raphimc.immediatelyfast.injection.interfaces.IMapRenderer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_330.class_331.class}, priority=1100)
public abstract class MixinMapRenderer_MapTexture {
    @Shadow
    private class_22 field_2046;
    @Mutable
    @Shadow
    @Final
    private class_1043 field_2048;
    @Unique
    private static final class_1043 DUMMY_TEXTURE;
    @Unique
    private int atlasX;
    @Unique
    private int atlasY;
    @Unique
    private MapAtlasTexture atlasTexture;

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Ljava/lang/Object;<init>()V", shift=At.Shift.AFTER, remap=false)})
    private void initAtlasParameters(class_330 mapRenderer, int id, class_22 state, CallbackInfo ci) {
        int packedLocation = ((IMapRenderer)mapRenderer).getAtlasMapping(id);
        if (packedLocation == -1) {
            ImmediatelyFast.LOGGER.warn("Map " + id + " is not in an atlas");
            return;
        }
        this.atlasX = (packedLocation >> 8 & 0xFF) * 128;
        this.atlasY = (packedLocation & 0xFF) * 128;
        this.atlasTexture = ((IMapRenderer)mapRenderer).getMapAtlasTexture(packedLocation >> 16);
    }

    @Redirect(method={"<init>"}, at=@At(value="NEW", target="(IIZ)Lnet/minecraft/client/texture/NativeImageBackedTexture;"))
    private class_1043 dontAllocateTexture(int width, int height, boolean useMipmaps) {
        if (this.atlasTexture != null) {
            return DUMMY_TEXTURE;
        }
        return new class_1043(width, height, useMipmaps);
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/texture/TextureManager;registerDynamicTexture(Ljava/lang/String;Lnet/minecraft/client/texture/NativeImageBackedTexture;)Lnet/minecraft/util/Identifier;"))
    private class_2960 getAtlasTextureIdentifier(class_1060 textureManager, String id, class_1043 texture) {
        if (this.atlasTexture != null) {
            this.field_2048 = null;
            return this.atlasTexture.getIdentifier();
        }
        return textureManager.method_4617(id, texture);
    }

    @Inject(method={"updateTexture"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateAtlasTexture(CallbackInfo ci) {
        if (this.atlasTexture != null) {
            ci.cancel();
            class_1043 atlasTexture = this.atlasTexture.getTexture();
            class_1011 atlasImage = atlasTexture.method_4525();
            if (atlasImage == null) {
                throw new IllegalStateException("Atlas texture has already been closed");
            }
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    int i = x + y * 128;
                    atlasImage.method_4305(this.atlasX + x, this.atlasY + y, class_3620.method_38480((int)this.field_2046.field_122[i]));
                }
            }
            atlasTexture.method_23207();
            atlasImage.method_4312(0, this.atlasX, this.atlasY, this.atlasX, this.atlasY, 128, 128, false, false);
        }
    }

    @Redirect(method={"draw"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/VertexConsumer;texture(FF)Lnet/minecraft/client/render/VertexConsumer;"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/render/VertexConsumer;vertex(Lorg/joml/Matrix4f;FFF)Lnet/minecraft/client/render/VertexConsumer;", ordinal=0), to=@At(value="INVOKE", target="Lnet/minecraft/client/render/VertexConsumer;next()V", ordinal=3)))
    private class_4588 drawAtlasTexture(class_4588 instance, float u, float v) {
        if (this.atlasTexture != null) {
            if (u == 0.0f && v == 1.0f) {
                u = (float)this.atlasX / 4096.0f;
                v = (float)(this.atlasY + 128) / 4096.0f;
            } else if (u == 1.0f && v == 1.0f) {
                u = (float)(this.atlasX + 128) / 4096.0f;
                v = (float)(this.atlasY + 128) / 4096.0f;
            } else if (u == 1.0f && v == 0.0f) {
                u = (float)(this.atlasX + 128) / 4096.0f;
                v = (float)this.atlasY / 4096.0f;
            } else if (u == 0.0f && v == 0.0f) {
                u = (float)this.atlasX / 4096.0f;
                v = (float)this.atlasY / 4096.0f;
            }
        }
        return instance.method_22913(u, v);
    }

    @Inject(method={"close"}, at={@At(value="HEAD")}, cancellable=true)
    private void dontCloseDummyTexture(CallbackInfo ci) {
        if (this.atlasTexture != null) {
            ci.cancel();
        }
    }

    static {
        try {
            DUMMY_TEXTURE = (class_1043)ImmediatelyFast.UNSAFE.allocateInstance(class_1043.class);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

