/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.raphimc.immediatelyfast.compat.IrisCompat;
import net.raphimc.immediatelyfast.feature.core.ImmediatelyFastConfig;
import net.raphimc.immediatelyfast.feature.core.ImmediatelyFastRuntimeConfig;
import net.raphimc.immediatelyfast.feature.fast_buffer_upload.PersistentMappedStreamingBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GLCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public class ImmediatelyFast
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ImmediatelyFast");
    public static final Unsafe UNSAFE = ImmediatelyFast.getUnsafe();
    public static String VERSION;
    public static ImmediatelyFastConfig config;
    public static ImmediatelyFastRuntimeConfig runtimeConfig;
    public static PersistentMappedStreamingBuffer persistentMappedStreamingBuffer;

    public void onInitializeClient() {
        VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer("immediatelyfast").orElseThrow(NullPointerException::new)).getMetadata().getVersion().getFriendlyString();
        LOGGER.info("Loading ImmediatelyFast " + VERSION);
        if (!ImmediatelyFast.config.debug_only_and_not_recommended_disable_mod_conflict_handling) {
            FabricLoader.getInstance().getModContainer("iris").ifPresent(modContainer -> {
                LOGGER.info("Found Iris " + modContainer.getMetadata().getVersion().getFriendlyString() + ". Enabling compatibility.");
                IrisCompat.init();
            });
        }
        RenderSystem.recordRenderCall(() -> {
            GLCapabilities cap = GL.getCapabilities();
            String gpuVendor = GL11C.glGetString((int)7936);
            String gpuModel = GL11C.glGetString((int)7937);
            String glVersion = GL11C.glGetString((int)7938);
            LOGGER.info("Initializing IF on " + gpuModel + " (" + gpuVendor + ") with OpenGL " + glVersion);
            boolean isNvidia = false;
            boolean isAmd = false;
            boolean isIntel = false;
            if (gpuVendor != null) {
                String gpuVendorLower = gpuVendor.toLowerCase();
                isNvidia = gpuVendorLower.startsWith("nvidia");
                isAmd = gpuVendorLower.startsWith("ati") || gpuVendorLower.startsWith("amd");
                isIntel = gpuVendorLower.startsWith("intel");
            }
            if (ImmediatelyFast.config.fast_buffer_upload) {
                if (cap.GL_ARB_direct_state_access && cap.GL_ARB_buffer_storage && cap.glMemoryBarrier != 0L) {
                    if (isAmd && !ImmediatelyFast.config.debug_only_and_not_recommended_disable_hardware_conflict_handling) {
                        LOGGER.warn("AMD GPU detected. Enabling coherent buffer mapping.");
                        ImmediatelyFast.config.fast_buffer_upload_explicit_flush = false;
                    }
                    persistentMappedStreamingBuffer = new PersistentMappedStreamingBuffer(ImmediatelyFast.config.fast_buffer_upload_size_mb * 1024L * 1024L);
                } else {
                    LOGGER.warn("Your GPU doesn't support ARB_direct_state_access and/or ARB_buffer_storage and/or glMemoryBarrier. Falling back to legacy fast buffer upload method.");
                    if (!isNvidia && !ImmediatelyFast.config.debug_only_and_not_recommended_disable_hardware_conflict_handling) {
                        LOGGER.warn("Non NVIDIA GPU detected. Force disabling fast buffer upload optimization.");
                    } else {
                        ImmediatelyFast.runtimeConfig.legacy_fast_buffer_upload = true;
                    }
                }
            }
        });
    }

    public static void loadConfig() {
        File configFile = FabricLoader.getInstance().getConfigDir().resolve("immediatelyfast.json").toFile();
        if (configFile.exists()) {
            try {
                config = (ImmediatelyFastConfig)new Gson().fromJson((Reader)new FileReader(configFile), ImmediatelyFastConfig.class);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to load ImmediatelyFast config. Resetting it.", e);
            }
        }
        if (config == null) {
            config = new ImmediatelyFastConfig();
        }
        try {
            Files.writeString(configFile.toPath(), (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((Object)config), new OpenOption[0]);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to save ImmediatelyFast config.", e);
        }
    }

    public static void createRuntimeConfig() {
        runtimeConfig = new ImmediatelyFastRuntimeConfig(config);
    }

    private static Unsafe getUnsafe() {
        try {
            for (Field field : Unsafe.class.getDeclaredFields()) {
                if (!field.getType().equals(Unsafe.class)) continue;
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new IllegalStateException("Unable to get Unsafe instance");
    }
}

