/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.implementations.items.IFacadeItem;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.SelectedPart;
import appeng.core.AEConfig;
import appeng.core.definitions.AEParts;
import appeng.items.parts.FacadeItem;
import appeng.parts.BusCollisionHelper;
import appeng.parts.PartPlacement;
import appeng.parts.misc.CableAnchorPart;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_761;

public class RenderBlockOutlineHook {
    public static final class_1921.class_4687 LINES_BEHIND_BLOCK = class_1921.method_24048((String)"lines_behind_block", (class_293)class_290.field_29337, (class_293.class_5596)class_293.class_5596.field_27377, (int)256, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_4668.field_29433).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(class_4668.field_22241).method_23615(class_4668.field_21370).method_23604(new class_4668.class_4672(">", 516)).method_23610(class_4668.field_25643).method_23616(class_4668.field_21350).method_23603(class_4668.field_21345).method_23617(false));

    private RenderBlockOutlineHook() {
    }

    public static void install() {
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register((context, hitResult) -> {
            class_3965 blockHitResult;
            class_638 level = context.world();
            class_4587 poseStack = context.matrixStack();
            class_4597 buffers = context.consumers();
            class_4184 camera = context.camera();
            if (level == null || buffers == null) {
                return true;
            }
            if (!(hitResult instanceof class_3965) || (blockHitResult = (class_3965)hitResult).method_17783() != class_239.class_240.field_1332) {
                return true;
            }
            return !RenderBlockOutlineHook.replaceBlockOutline(level, poseStack, buffers, camera, blockHitResult);
        });
    }

    private static boolean replaceBlockOutline(class_638 level, class_4587 poseStack, class_4597 buffers, class_4184 camera, class_3965 hitResult) {
        class_2338 pos;
        class_2586 class_25862;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        if (AEConfig.instance().isPlacementPreviewEnabled()) {
            class_1799 itemInHand = player.method_5998(class_1268.field_5808);
            RenderBlockOutlineHook.showPartPlacementPreview((class_1657)player, poseStack, buffers, camera, hitResult, itemInHand, true);
            RenderBlockOutlineHook.showPartPlacementPreview((class_1657)player, poseStack, buffers, camera, hitResult, itemInHand, false);
        }
        if ((class_25862 = level.method_8321(pos = hitResult.method_17777())) instanceof IPartHost) {
            IPartHost partHost = (IPartHost)class_25862;
            if (AEConfig.instance().isPlacementPreviewEnabled()) {
                class_1799 itemInHand = player.method_5998(class_1268.field_5808);
                RenderBlockOutlineHook.showFacadePlacementPreview(poseStack, buffers, camera, hitResult, partHost, itemInHand, true);
                RenderBlockOutlineHook.showFacadePlacementPreview(poseStack, buffers, camera, hitResult, partHost, itemInHand, false);
            }
            SelectedPart selectedPart = partHost.selectPartWorld(hitResult.method_17784());
            if (selectedPart.facade != null) {
                RenderBlockOutlineHook.renderFacade(poseStack, buffers, camera, pos, selectedPart.facade, selectedPart.side, false, false);
                return true;
            }
            if (selectedPart.part != null) {
                RenderBlockOutlineHook.renderPart(poseStack, buffers, camera, pos, selectedPart.part, selectedPart.side, false, false);
                return true;
            }
        }
        return false;
    }

    private static boolean showFacadePlacementPreview(class_4587 poseStack, class_4597 buffers, class_4184 camera, class_3965 blockHitResult, IPartHost partHost, class_1799 itemInHand, boolean insideBlock) {
        class_2350 side;
        IFacadeItem facadeItem;
        IFacadePart facade;
        class_2338 pos = blockHitResult.method_17777();
        class_1792 class_17922 = itemInHand.method_7909();
        if (class_17922 instanceof IFacadeItem && (facade = (facadeItem = (IFacadeItem)class_17922).createPartFromItemStack(itemInHand, side = blockHitResult.method_17780())) != null && FacadeItem.canPlaceFacade(partHost, facade)) {
            if (partHost.getPart(side) == null) {
                CableAnchorPart cableAnchor = AEParts.CABLE_ANCHOR.method_8389().createPart();
                RenderBlockOutlineHook.renderPart(poseStack, buffers, camera, pos, cableAnchor, side, true, insideBlock);
            }
            RenderBlockOutlineHook.renderFacade(poseStack, buffers, camera, pos, facade, side, true, insideBlock);
            return true;
        }
        return false;
    }

    private static void showPartPlacementPreview(class_1657 player, class_4587 poseStack, class_4597 buffers, class_4184 camera, class_3965 blockHitResult, class_1799 itemInHand, boolean insideBlock) {
        class_1792 class_17922 = itemInHand.method_7909();
        if (class_17922 instanceof IPartItem) {
            IPartItem partItem = (IPartItem)class_17922;
            PartPlacement.Placement placement = PartPlacement.getPartPlacement(player, player.method_37908(), itemInHand, blockHitResult.method_17777(), blockHitResult.method_17780(), blockHitResult.method_17784());
            if (placement != null) {
                Object part = partItem.createPart();
                RenderBlockOutlineHook.renderPart(poseStack, buffers, camera, placement.pos(), part, placement.side(), true, insideBlock);
            }
        }
    }

    private static void renderPart(class_4587 poseStack, class_4597 buffers, class_4184 camera, class_2338 pos, IPart part, class_2350 side, boolean preview, boolean insideBlock) {
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        BusCollisionHelper helper = new BusCollisionHelper(boxes, side, true);
        part.getBoxes(helper);
        RenderBlockOutlineHook.renderBoxes(poseStack, buffers, camera, pos, boxes, preview, insideBlock);
    }

    private static void renderFacade(class_4587 poseStack, class_4597 buffers, class_4184 camera, class_2338 pos, IFacadePart facade, class_2350 side, boolean preview, boolean insideBlock) {
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        BusCollisionHelper helper = new BusCollisionHelper(boxes, side, true);
        facade.getBoxes(helper, false);
        RenderBlockOutlineHook.renderBoxes(poseStack, buffers, camera, pos, boxes, preview, insideBlock);
    }

    private static void renderBoxes(class_4587 poseStack, class_4597 buffers, class_4184 camera, class_2338 pos, List<class_238> boxes, boolean preview, boolean insideBlock) {
        class_1921.class_4687 renderType = insideBlock ? LINES_BEHIND_BLOCK : class_1921.method_23594();
        class_4588 buffer = buffers.getBuffer((class_1921)renderType);
        float alpha = insideBlock ? 0.2f : (preview ? 0.6f : 0.4f);
        for (class_238 box : boxes) {
            class_265 shape = class_259.method_1078((class_238)box);
            class_761.method_3291((class_4587)poseStack, (class_4588)buffer, (class_265)shape, (double)((double)pos.method_10263() - camera.method_19326().field_1352), (double)((double)pos.method_10264() - camera.method_19326().field_1351), (double)((double)pos.method_10260() - camera.method_19326().field_1350), (float)(preview ? 1.0f : 0.0f), (float)(preview ? 1.0f : 0.0f), (float)(preview ? 1.0f : 0.0f), (float)alpha);
        }
    }
}

