/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.storage;

import appeng.api.implementations.blockentities.IChestOrDrive;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.StorageCell;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.blockentity.inventory.AppEngCellInventory;
import appeng.client.render.model.DriveModelData;
import appeng.core.AELog;
import appeng.core.definitions.AEBlocks;
import appeng.helpers.IPriorityHost;
import appeng.me.storage.DriveWatcher;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.DriveMenu;
import appeng.menu.locator.MenuLocators;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class DriveBlockEntity
extends AENetworkInvBlockEntity
implements IChestOrDrive,
IPriorityHost,
IStorageProvider {
    private final AppEngCellInventory inv = new AppEngCellInventory(this, this.getCellCount());
    private final DriveWatcher[] invBySlot = new DriveWatcher[this.getCellCount()];
    private boolean isCached = false;
    private int priority = 0;
    private boolean wasOnline = false;
    private final class_1792[] clientSideCellItems = new class_1792[this.getCellCount()];
    private final CellState[] clientSideCellState = new CellState[this.getCellCount()];
    private boolean clientSideOnline;

    public DriveBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().addService(IStorageProvider.class, this).setFlags(GridFlags.REQUIRE_CHANNEL);
        this.inv.setFilter(new CellValidInventoryFilter());
        Arrays.fill((Object[])this.clientSideCellState, (Object)CellState.ABSENT);
    }

    @Override
    public Set<class_2350> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.complementOf(EnumSet.of(orientation.getSide(RelativeSide.FRONT)));
    }

    @Override
    protected void writeToStream(class_2540 data) {
        int i;
        super.writeToStream(data);
        this.updateClientSideState();
        int packedState = 0;
        for (i = 0; i < this.getCellCount(); ++i) {
            packedState |= this.clientSideCellState[i].ordinal() << i * 3;
        }
        if (this.clientSideOnline) {
            packedState |= Integer.MIN_VALUE;
        }
        data.writeInt(packedState);
        for (i = 0; i < this.getCellCount(); ++i) {
            data.method_10804(class_7923.field_41178.method_10206((Object)this.getCellItem(i)));
        }
    }

    @Override
    protected void saveVisualState(class_2487 data) {
        super.saveVisualState(data);
        data.method_10556("online", this.isPowered());
        for (int i = 0; i < this.getCellCount(); ++i) {
            class_1792 cellItem = this.getCellItem(i);
            if (cellItem == null) continue;
            class_2487 cellData = new class_2487();
            cellData.method_10582("id", class_7923.field_41178.method_10221((Object)cellItem).toString());
            CellState cellState = this.getCellStatus(i);
            cellData.method_10582("state", cellState.name().toLowerCase(Locale.ROOT));
            data.method_10566("cell" + i, (class_2520)cellData);
        }
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean online;
        boolean changed = super.readFromStream(data);
        int packedState = data.readInt();
        for (int i = 0; i < this.getCellCount(); ++i) {
            int cellStateOrdinal = packedState >> i * 3 & 7;
            CellState cellState = CellState.values()[cellStateOrdinal];
            if (this.clientSideCellState[i] == cellState) continue;
            this.clientSideCellState[i] = cellState;
            changed = true;
        }
        boolean bl = online = (packedState & Integer.MIN_VALUE) != 0;
        if (this.clientSideOnline != online) {
            this.clientSideOnline = online;
            changed = true;
        }
        for (int i = 0; i < this.getCellCount(); ++i) {
            class_1792 item;
            int itemId = data.method_10816();
            class_1792 class_17922 = item = itemId == 0 ? null : (class_1792)class_7923.field_41178.method_10200(itemId);
            if (itemId != 0 && item == class_1802.field_8162) {
                AELog.warn("Received unknown item id from server for disk drive %s: %d", this, itemId);
            }
            if (this.clientSideCellItems[i] == item) continue;
            this.clientSideCellItems[i] = item;
            changed = true;
        }
        return changed;
    }

    @Override
    protected void loadVisualState(class_2487 data) {
        super.loadVisualState(data);
        this.clientSideOnline = data.method_10577("online");
        for (int i = 0; i < this.getCellCount(); ++i) {
            this.clientSideCellItems[i] = null;
            this.clientSideCellState[i] = CellState.ABSENT;
            String tagName = "cell" + i;
            if (!data.method_10573(tagName, 10)) continue;
            class_2487 cellData = data.method_10562(tagName);
            class_2960 id = new class_2960(cellData.method_10558("id"));
            String cellStateName = cellData.method_10558("state");
            this.clientSideCellItems[i] = class_7923.field_41178.method_17966(id).orElse(null);
            try {
                this.clientSideCellState[i] = CellState.valueOf(cellStateName.toUpperCase(Locale.ROOT));
                continue;
            }
            catch (IllegalArgumentException e) {
                AELog.warn("Cannot parse cell state for cell %d: %s", i, cellStateName);
            }
        }
    }

    @Override
    public int getCellCount() {
        return 10;
    }

    @Override
    @Nullable
    public class_1792 getCellItem(int slot) {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return this.clientSideCellItems[slot];
        }
        class_1799 stackInSlot = this.inv.getStackInSlot(slot);
        if (!stackInSlot.method_7960()) {
            return stackInSlot.method_7909();
        }
        return null;
    }

    @Override
    public CellState getCellStatus(int slot) {
        if (this.isClientSide()) {
            return this.clientSideCellState[slot];
        }
        DriveWatcher handler = this.invBySlot[slot];
        if (handler == null) {
            return CellState.ABSENT;
        }
        return handler.getStatus();
    }

    @Override
    @Nullable
    public MEStorage getCellInventory(int slot) {
        return this.invBySlot[slot];
    }

    @Override
    @Nullable
    public StorageCell getOriginalCellInventory(int slot) {
        DriveWatcher handler = this.invBySlot[slot];
        if (handler != null) {
            return handler.getCell();
        }
        return null;
    }

    @Override
    public boolean isPowered() {
        if (this.isClientSide()) {
            return this.clientSideOnline;
        }
        return this.getMainNode().isOnline();
    }

    @Override
    public boolean isCellBlinking(int slot) {
        return false;
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.isCached = false;
        this.priority = data.method_10550("priority");
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10569("priority", this.priority);
    }

    private void updateVisualStateIfNeeded() {
        if (this.updateClientSideState()) {
            this.markForUpdate();
        }
    }

    private boolean updateClientSideState() {
        if (this.isClientSide()) {
            return false;
        }
        this.updateState();
        boolean changed = false;
        boolean online = this.getMainNode().isOnline();
        if (online != this.clientSideOnline) {
            this.clientSideOnline = online;
            changed = true;
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            CellState cellState;
            class_1792 cellItem = this.getCellItem(x);
            if (cellItem != this.clientSideCellItems[x]) {
                this.clientSideCellItems[x] = cellItem;
                changed = true;
            }
            if ((cellState = this.getCellStatus(x)) == this.clientSideCellState[x]) continue;
            this.clientSideCellState[x] = cellState;
            changed = true;
        }
        return changed;
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        boolean currentOnline = this.getMainNode().isOnline();
        if (this.wasOnline != currentOnline) {
            this.wasOnline = currentOnline;
            IStorageProvider.requestUpdate(this.getMainNode());
            this.updateVisualStateIfNeeded();
        }
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.SMART;
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
        }
        IStorageProvider.requestUpdate(this.getMainNode());
        this.markForUpdate();
    }

    private void updateState() {
        if (!this.isCached) {
            double power = 2.0;
            for (int slot = 0; slot < this.inv.size(); ++slot) {
                power += this.updateStateForSlot(slot);
            }
            this.getMainNode().setIdlePowerUsage(power);
            this.isCached = true;
        }
    }

    private double updateStateForSlot(int slot) {
        StorageCell cell;
        this.invBySlot[slot] = null;
        this.inv.setHandler(slot, null);
        class_1799 is = this.inv.getStackInSlot(slot);
        if (!is.method_7960() && (cell = StorageCells.getCellInventory(is, this::onCellContentChanged)) != null) {
            DriveWatcher driveWatcher;
            this.inv.setHandler(slot, cell);
            this.invBySlot[slot] = driveWatcher = new DriveWatcher(cell, () -> this.blinkCell(slot));
            return cell.getIdleDrain();
        }
        return 0.0;
    }

    @Override
    public void onReady() {
        super.onReady();
        this.updateState();
    }

    @Override
    public void mountInventories(IStorageMounts storageMounts) {
        if (this.getMainNode().isOnline()) {
            this.updateState();
            for (DriveWatcher inventory : this.invBySlot) {
                if (inventory == null) continue;
                storageMounts.mount(inventory, this.priority);
            }
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.saveChanges();
        this.isCached = false;
        this.updateState();
        IStorageProvider.requestUpdate(this.getMainNode());
    }

    private void blinkCell(int slot) {
        this.updateVisualStateIfNeeded();
    }

    private void onCellContentChanged() {
        this.field_11863.method_8524(this.field_11867);
    }

    @Override
    public DriveModelData getRenderAttachmentData() {
        class_1792[] cells = new class_1792[this.getCellCount()];
        for (int i = 0; i < this.getCellCount(); ++i) {
            cells[i] = this.getCellItem(i);
        }
        return new DriveModelData(cells);
    }

    public void openMenu(class_1657 player) {
        MenuOpener.open(DriveMenu.TYPE, player, MenuLocators.forBlockEntity(this));
    }

    @Override
    public void returnToMainMenu(class_1657 player, ISubMenu subMenu) {
        MenuOpener.returnTo(DriveMenu.TYPE, player, MenuLocators.forBlockEntity(this));
    }

    @Override
    public class_1799 getMainMenuIcon() {
        return AEBlocks.DRIVE.stack();
    }

    private static class CellValidInventoryFilter
    implements IAEItemFilter {
        private CellValidInventoryFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            return !stack.method_7960() && StorageCells.isCellHandled(stack);
        }
    }
}

