/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.spatial;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridMultiblock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.orientation.BlockOrientation;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.SpatialPylonCalculator;
import appeng.me.cluster.implementations.SpatialPylonCluster;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.util.iterators.ChainedIterator;
import com.google.common.collect.Iterators;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class SpatialPylonBlockEntity
extends AENetworkBlockEntity
implements IAEMultiBlock<SpatialPylonCluster> {
    private final SpatialPylonCalculator calc = new SpatialPylonCalculator(this);
    private SpatialPylonCluster cluster;
    private ClientState clientState = ClientState.DEFAULT;

    public SpatialPylonBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL, GridFlags.MULTIBLOCK).setIdlePowerUsage(0.5).addService(IGridMultiblock.class, this::getMultiblockNodes);
    }

    @Override
    public void onChunkUnloaded() {
        this.disconnect(false);
        super.onChunkUnloaded();
    }

    @Override
    public void onReady() {
        super.onReady();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.calc.calculateMultiblock(serverLevel, this.field_11867);
        }
    }

    @Override
    public void method_11012() {
        super.method_11012();
        this.disconnect(false);
    }

    public void neighborChanged(class_2338 changedPos) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.calc.updateMultiblockAfterNeighborUpdate(serverLevel, this.field_11867, changedPos);
        }
    }

    @Override
    public void disconnect(boolean b) {
        if (this.cluster != null) {
            this.cluster.destroy();
            this.updateStatus(null);
        }
    }

    @Override
    public SpatialPylonCluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public void updateStatus(SpatialPylonCluster c) {
        if (this.method_11015()) {
            return;
        }
        this.cluster = c;
        this.onGridConnectableSidesChanged();
        this.recalculateDisplay();
    }

    @Override
    public Set<class_2350> getGridConnectableSides(BlockOrientation orientation) {
        return this.cluster == null ? EnumSet.noneOf(class_2350.class) : EnumSet.allOf(class_2350.class);
    }

    public void recalculateDisplay() {
        ClientState state;
        AxisPosition pos = AxisPosition.NONE;
        class_2350.class_2351 axis = class_2350.class_2351.field_11048;
        boolean powered = false;
        boolean online = false;
        if (this.cluster != null) {
            pos = this.cluster.getBoundsMin().equals((Object)this.field_11867) ? AxisPosition.START : (this.cluster.getBoundsMax().equals((Object)this.field_11867) ? AxisPosition.END : AxisPosition.MIDDLE);
            switch (this.cluster.getCurrentAxis()) {
                case X: {
                    class_2350.class_2351 class_23512 = class_2350.class_2351.field_11048;
                    break;
                }
                case Y: {
                    class_2350.class_2351 class_23512 = class_2350.class_2351.field_11052;
                    break;
                }
                case Z: {
                    class_2350.class_2351 class_23512 = class_2350.class_2351.field_11051;
                    break;
                }
                default: {
                    class_2350.class_2351 class_23512 = axis = axis;
                }
            }
            if (this.getMainNode().isPowered()) {
                powered = true;
            }
            if (this.cluster.isValid() && this.getMainNode().isOnline()) {
                online = true;
            }
        }
        if (!this.clientState.equals(state = new ClientState(powered, online, pos, axis))) {
            this.clientState = state;
            this.markForUpdate();
        }
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        ClientState state = ClientState.readFromStream(data);
        if (!this.clientState.equals(state)) {
            this.clientState = state;
            return true;
        }
        return c;
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        this.clientState.writeToStream(data);
    }

    @Override
    protected void saveVisualState(class_2487 data) {
        super.saveVisualState(data);
        this.clientState.writeToNbt(data);
    }

    @Override
    protected void loadVisualState(class_2487 data) {
        super.loadVisualState(data);
        this.clientState = ClientState.readFromNbt(data);
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.recalculateDisplay();
        }
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    @Override
    public Object getRenderAttachmentData() {
        return this.getClientState();
    }

    private Iterator<IGridNode> getMultiblockNodes() {
        if (this.getCluster() == null) {
            return new ChainedIterator<IGridNode>(new IGridNode[0]);
        }
        return Iterators.transform(this.getCluster().getBlockEntities(), IGridConnectedBlockEntity::getGridNode);
    }

    public record ClientState(boolean powered, boolean online, AxisPosition axisPosition, class_2350.class_2351 axis) {
        public static final ClientState DEFAULT = new ClientState(false, false, AxisPosition.NONE, class_2350.class_2351.field_11048);

        public void writeToStream(class_2540 buf) {
            buf.writeBoolean(this.powered);
            buf.writeBoolean(this.online);
            buf.method_10817((Enum)this.axisPosition);
            buf.method_10817((Enum)this.axis);
        }

        public static ClientState readFromStream(class_2540 buf) {
            return new ClientState(buf.readBoolean(), buf.readBoolean(), (AxisPosition)buf.method_10818(AxisPosition.class), (class_2350.class_2351)buf.method_10818(class_2350.class_2351.class));
        }

        public void writeToNbt(class_2487 tag) {
            tag.method_10556("powered", this.powered);
            tag.method_10556("online", this.online);
            tag.method_10582("axisPosition", this.axisPosition.name());
            tag.method_10582("axis", this.axis.name());
        }

        public static ClientState readFromNbt(class_2487 tag) {
            class_2350.class_2351 axis;
            AxisPosition axisPosition;
            boolean powered = tag.method_10577("powered");
            boolean online = tag.method_10577("online");
            String axisPositionName = tag.method_10558("axisPosition");
            try {
                axisPosition = Enum.valueOf(AxisPosition.class, axisPositionName);
            }
            catch (IllegalArgumentException ignored) {
                axisPosition = ClientState.DEFAULT.axisPosition;
            }
            String axisName = tag.method_10558("axis");
            try {
                axis = Enum.valueOf(class_2350.class_2351.class, axisName);
            }
            catch (IllegalArgumentException ignored) {
                axis = ClientState.DEFAULT.axis;
            }
            return new ClientState(powered, online, axisPosition, axis);
        }
    }

    public static enum AxisPosition {
        NONE,
        START,
        MIDDLE,
        END;

    }
}

