/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.server.messages.persistentdata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.network.server.ClientToServerPacket;
import java.util.ArrayList;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class CMessageAddPersistentTrader
extends ClientToServerPacket {
    public static final class_2960 PACKET_ID = new class_2960("lightmanscurrency", "persistentdata_trader");
    private static final String GENERATE_ID_FORMAT = "trader_";
    private final long traderID;
    private final String id;
    private final String owner;

    public CMessageAddPersistentTrader(long traderID, String id, String owner) {
        super(PACKET_ID);
        this.traderID = traderID;
        this.id = id;
        this.owner = owner;
    }

    @Override
    protected void encode(LazyPacketData.Builder dataBuilder) {
        dataBuilder.setLong("trader", this.traderID).setString("id", this.id).setString("owner", this.owner);
    }

    private static JsonObject getTraderJson(TraderData trader, String id, String owner) throws Exception {
        JsonObject traderJson = trader.saveToJson();
        traderJson.addProperty("ID", id);
        traderJson.addProperty("OwnerName", owner);
        return traderJson;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, LazyPacketData data, PacketSender responseSender) {
        TraderData trader;
        if (CommandLCAdmin.isAdminPlayer((class_1657)player) && (trader = TraderSaveData.GetTrader(false, data.getLong("trader"))) != null && trader.canMakePersistent()) {
            String id = data.getString("id");
            String owner = data.getString("owner");
            boolean generateID = id.isBlank();
            if (!generateID) {
                try {
                    JsonObject traderJson = CMessageAddPersistentTrader.getTraderJson(trader, id, owner);
                    JsonArray persistentTraders = TraderSaveData.getPersistentTraderJson("Traders");
                    for (int i = 0; i < persistentTraders.size(); ++i) {
                        JsonObject traderData = persistentTraders.get(i).getAsJsonObject();
                        if ((!traderData.has("ID") || !traderData.get("ID").getAsString().equals(id)) && (!traderData.has("id") || !traderData.get("id").getAsString().equals(id))) continue;
                        persistentTraders.set(i, (JsonElement)traderJson);
                        TraderSaveData.setPersistentTraderSection("Traders", persistentTraders);
                        player.method_43496((class_2561)class_2561.method_43469((String)"lightmanscurrency.message.persistent.trader.overwrite", (Object[])new Object[]{id}));
                        return;
                    }
                    persistentTraders.add((JsonElement)traderJson);
                    TraderSaveData.setPersistentTraderSection("Traders", persistentTraders);
                    player.method_43496((class_2561)class_2561.method_43469((String)"lightmanscurrency.message.persistent.trader.add", (Object[])new Object[]{id}));
                    return;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                try {
                    int i;
                    ArrayList<String> knownIDs = new ArrayList<String>();
                    JsonArray persistentTraders = TraderSaveData.getPersistentTraderJson("Traders");
                    for (i = 0; i < persistentTraders.size(); ++i) {
                        JsonObject traderData = persistentTraders.get(i).getAsJsonObject();
                        if (traderData.has("id")) {
                            knownIDs.add(traderData.get("id").getAsString());
                        }
                        if (!traderData.has("ID")) continue;
                        knownIDs.add(traderData.get("ID").getAsString());
                    }
                    for (i = 1; i < Integer.MAX_VALUE; ++i) {
                        String genID = GENERATE_ID_FORMAT + String.valueOf(i);
                        if (!knownIDs.stream().noneMatch(ID -> ID.equals(genID))) continue;
                        persistentTraders.add((JsonElement)CMessageAddPersistentTrader.getTraderJson(trader, genID, owner));
                        TraderSaveData.setPersistentTraderSection("Traders", persistentTraders);
                        player.method_43496((class_2561)class_2561.method_43469((String)"lightmanscurrency.message.persistent.trader.add", (Object[])new Object[]{genID}));
                        return;
                    }
                    LightmansCurrency.LogError("Could not generate ID, as all trader_# ID's are somehow spoken for.");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

