/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.server.messages.persistentdata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.network.server.ClientToServerPacket;
import java.util.ArrayList;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class CMessageAddPersistentAuction
extends ClientToServerPacket {
    public static final class_2960 PACKET_ID = new class_2960("lightmanscurrency", "persistentdata_auction");
    private static final String GENERATE_ID_FORMAT = "auction_";
    private final class_2487 auctionData;
    private final String id;

    public CMessageAddPersistentAuction(class_2487 auctionData, String id) {
        super(PACKET_ID);
        this.auctionData = auctionData;
        this.id = id;
    }

    @Override
    protected void encode(LazyPacketData.Builder dataBuilder) {
        dataBuilder.setCompound("auction", this.auctionData).setString("id", this.id);
    }

    private static JsonObject getAuctionJson(class_2487 auctionData, String id) {
        AuctionTradeData auction = new AuctionTradeData(auctionData);
        JsonObject json = new JsonObject();
        json.addProperty("ID", id);
        json = auction.saveToJson(json);
        return json;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, LazyPacketData data, PacketSender responseSender) {
        if (CommandLCAdmin.isAdminPlayer((class_1657)player)) {
            int i;
            class_2487 auctionNbt = data.getCompound("auction");
            String id = data.getString("id");
            boolean generateID = id.isBlank();
            if (!generateID) {
                JsonObject auctionJson = CMessageAddPersistentAuction.getAuctionJson(auctionNbt, id);
                JsonArray persistentAuctions = TraderSaveData.getPersistentTraderJson("Auctions");
                for (int i2 = 0; i2 < persistentAuctions.size(); ++i2) {
                    JsonObject auctionData = persistentAuctions.get(i2).getAsJsonObject();
                    if ((!auctionData.has("ID") || !auctionData.get("ID").getAsString().equals(id)) && (!auctionData.has("id") || !auctionData.get("id").getAsString().equals(id))) continue;
                    persistentAuctions.set(i2, (JsonElement)auctionJson);
                    TraderSaveData.setPersistentTraderSection("Auctions", persistentAuctions);
                    player.method_43496((class_2561)class_2561.method_43469((String)"lightmanscurrency.message.persistent.auction.overwrite", (Object[])new Object[]{id}));
                    return;
                }
                persistentAuctions.add((JsonElement)auctionJson);
                TraderSaveData.setPersistentTraderSection("Auctions", persistentAuctions);
                player.method_43496((class_2561)class_2561.method_43469((String)"lightmanscurrency.message.persistent.auction.add", (Object[])new Object[]{id}));
                return;
            }
            ArrayList<String> knownIDs = new ArrayList<String>();
            JsonArray persistentAuctions = TraderSaveData.getPersistentTraderJson("Auctions");
            for (i = 0; i < persistentAuctions.size(); ++i) {
                JsonObject auctionData = persistentAuctions.get(i).getAsJsonObject();
                if (auctionData.has("ID")) {
                    knownIDs.add(auctionData.get("ID").getAsString());
                    continue;
                }
                if (!auctionData.has("id")) continue;
                knownIDs.add(auctionData.get("id").getAsString());
            }
            for (i = 1; i < Integer.MAX_VALUE; ++i) {
                String genID = GENERATE_ID_FORMAT + String.valueOf(i);
                if (!knownIDs.stream().noneMatch(kid -> kid.equals(genID))) continue;
                persistentAuctions.add((JsonElement)CMessageAddPersistentAuction.getAuctionJson(auctionNbt, genID));
                TraderSaveData.setPersistentTraderSection("Auctions", persistentAuctions);
                player.method_43496((class_2561)class_2561.method_43469((String)"lightmanscurrency.message.persistent.auction.add", (Object[])new Object[]{genID}));
                return;
            }
            LightmansCurrency.LogError("Could not generate ID, as all auction_# ID's are somehow spoken for.");
        }
    }
}

