/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.common.base.Supplier;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeInputWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.traders.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;

public class PriceFluctuation
extends TradeRule {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "price_fluctuation");
    long duration = 86400000L;
    int fluctuation = 10;
    private static final List<Long> debuggedSeeds = new ArrayList<Long>();
    private static final List<Long> debuggedTraderFactors = new ArrayList<Long>();

    public int getFluctuation() {
        return this.fluctuation;
    }

    public void setFluctuation(int percent) {
        this.fluctuation = MathUtil.clamp(percent, 0, 100);
    }

    public PriceFluctuation() {
        super(TYPE);
    }

    private static void debugTraderFactor(long factor, long traderID, int tradeIndex) {
        if (debuggedTraderFactors.contains(factor)) {
            return;
        }
        LightmansCurrency.LogDebug("Trader Seed Factor for trader with id '" + traderID + "' and trade index '" + tradeIndex + "' is " + factor);
        debuggedTraderFactors.add(factor);
    }

    private static void debugFlux(long seed, int maxFlux, int flux) {
        if (debuggedSeeds.contains(seed)) {
            return;
        }
        LightmansCurrency.LogDebug("Price Fluctuation for trade with seed '" + seed + "' and max fluctuation of " + maxFlux + "% is " + flux + "%");
        debuggedSeeds.add(seed);
    }

    private long getTraderSeedFactor(TradeEvent.TradeCostEvent event) {
        long traderID = event.getTrader().getID();
        int tradeIndex = event.getTradeIndex();
        long factor = (traderID + 1L << 32) + (long)tradeIndex;
        PriceFluctuation.debugTraderFactor(factor, traderID, tradeIndex);
        return factor;
    }

    private double randomizePriceMultiplier(long traderSeedFactor) {
        long seed = TimeUtil.getCurrentTime() / this.duration;
        int fluct = new Random(seed * traderSeedFactor).nextInt(-this.fluctuation, this.fluctuation + 1);
        PriceFluctuation.debugFlux(seed * traderSeedFactor, this.fluctuation, fluct);
        return 1.0 + (double)fluct / 100.0;
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        event.applyCostMultiplier(this.randomizePriceMultiplier(this.getTraderSeedFactor(event)));
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        compound.method_10544("Duration", this.duration);
        compound.method_10569("Fluctuation", this.fluctuation);
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        this.duration = compound.method_10537("Duration");
        if (this.duration <= 0L) {
            this.duration = 86400000L;
        }
        this.fluctuation = compound.method_10550("Fluctuation");
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("Duration", (Number)this.duration);
        json.addProperty("Fluctuation", (Number)this.fluctuation);
        return json;
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("Duration")) {
            this.duration = json.get("Duration").getAsLong();
        }
        if (json.has("Fluctuation")) {
            this.fluctuation = json.get("Fluctuation").getAsInt();
        }
    }

    @Override
    public class_2487 savePersistentData() {
        return null;
    }

    @Override
    public void loadPersistentData(class_2487 data) {
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_PRICE_FLUCTUATION;
    }

    @Override
    protected void handleUpdateMessage(class_2487 updateInfo) {
        if (updateInfo.method_10545("Duration")) {
            this.duration = updateInfo.method_10537("Duration");
        }
        if (updateInfo.method_10545("Fluctuation")) {
            this.fluctuation = updateInfo.method_10550("Fluctuation");
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GuiHandler(screen, rule);
    }

    @Environment(value=EnvType.CLIENT)
    private static class GuiHandler
    extends TradeRule.GUIHandler {
        class_342 fluctuationInput;
        class_4185 buttonSetFluctuation;
        TimeInputWidget durationInput;

        protected final PriceFluctuation getRule() {
            if (this.getRuleRaw() instanceof PriceFluctuation) {
                return (PriceFluctuation)this.getRuleRaw();
            }
            return null;
        }

        GuiHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            this.fluctuationInput = this.addCustomRenderable(new class_342(this.screen.getFont(), this.screen.guiLeft() + 10, this.screen.guiTop() + 9, 20, 20, (class_2561)class_2561.method_43473()));
            this.fluctuationInput.method_1880(2);
            this.fluctuationInput.method_1852(Integer.toString(this.getRule().fluctuation));
            this.buttonSetFluctuation = this.addCustomRenderable(new VanillaButton(this.screen.guiLeft() + 110, this.screen.guiTop() + 10, 50, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.discount.set"), this::PressSetFluctuationButton));
            this.durationInput = this.addCustomRenderable(new TimeInputWidget(this.screen.guiLeft() + 48, this.screen.guiTop() + 75, 10, TimeUtil.TimeUnit.DAY, TimeUtil.TimeUnit.MINUTE, this::addCustomRenderable, this::onTimeSet));
            this.durationInput.setTime(this.getRule().duration);
        }

        @Override
        public void renderTab(class_332 gui, int mouseX, int mouseY, float partialTicks) {
            if (this.getRule() == null) {
                return;
            }
            gui.method_51439(this.screen.getFont(), (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.fluctuation.tooltip"), this.fluctuationInput.method_46426() + this.fluctuationInput.method_25368() + 4, this.fluctuationInput.method_46427() + 3, 0xFFFFFF, false);
            class_5250 class_52502 = class_2561.method_43469((String)"gui.button.lightmanscurrency.price_fluctuation.info", (Object[])new Object[]{this.getRule().fluctuation, new TimeUtil.TimeData(this.getRule().duration).getShortString()});
            int n = this.screen.guiLeft() + 10;
            Objects.requireNonNull(this.screen);
            TextRenderUtil.drawCenteredMultilineText(gui, (class_2561)class_52502, n, 176 - 20, this.screen.guiTop() + 35, 0xFFFFFF);
        }

        @Override
        public void onScreenTick() {
            TextInputUtil.whitelistInteger(this.fluctuationInput, 0L, 99L);
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.fluctuationInput);
            this.removeCustomWidget(this.buttonSetFluctuation);
            this.durationInput.removeChildren(this::removeCustomWidget);
            this.removeCustomWidget(this.durationInput);
        }

        void PressSetFluctuationButton(class_4185 button) {
            int fluctuation;
            this.getRule().fluctuation = fluctuation = TextInputUtil.getIntegerValue(this.fluctuationInput, 1);
            class_2487 updateInfo = new class_2487();
            updateInfo.method_10569("Fluctuation", fluctuation);
            this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
        }

        public void onTimeSet(TimeUtil.TimeData newTime) {
            this.getRule().duration = newTime.miliseconds;
            class_2487 updateInfo = new class_2487();
            updateInfo.method_10544("Duration", newTime.miliseconds);
            this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
        }
    }
}

