/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;

public class PlayerDiscounts
extends TradeRule {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "discount_list");
    List<PlayerReference> playerList = new ArrayList<PlayerReference>();
    int discount = 10;

    public int getDiscountPercent() {
        return this.discount;
    }

    public void setDiscountPercent(int percent) {
        this.discount = MathUtil.clamp(percent, 0, 99);
    }

    private double getDiscountMult() {
        return 1.0 - (double)this.discount / 100.0;
    }

    private double getIncreaseMult() {
        return 1.0 + (double)this.discount / 100.0;
    }

    public PlayerDiscounts() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.isOnList(event.getPlayerReference())) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.addHelpful(class_2561.method_43469((String)"traderule.lightmanscurrency.discount_list.info.sale", (Object[])new Object[]{this.discount}));
                    break;
                }
                case PURCHASE: {
                    event.addHelpful(class_2561.method_43469((String)"traderule.lightmanscurrency.discount_list.info.purchase", (Object[])new Object[]{this.discount}));
                    break;
                }
            }
        }
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        if (this.isOnList(event.getPlayerReference())) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.applyCostMultiplier(this.getDiscountMult());
                    break;
                }
                case PURCHASE: {
                    event.applyCostMultiplier(this.getIncreaseMult());
                    break;
                }
            }
        }
    }

    public boolean isOnList(PlayerReference player) {
        for (PlayerReference playerReference : this.playerList) {
            if (!playerReference.is(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        class_2499 playerNameList = new class_2499();
        for (PlayerReference playerReference : this.playerList) {
            playerNameList.add((Object)playerReference.save());
        }
        compound.method_10566("Players", (class_2520)playerNameList);
        compound.method_10569("Discount", this.discount);
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        JsonArray playerList = new JsonArray();
        for (PlayerReference playerReference : this.playerList) {
            playerList.add((JsonElement)playerReference.saveAsJson());
        }
        json.add("Players", (JsonElement)playerList);
        json.addProperty("Discount", (Number)this.discount);
        return json;
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        if (compound.method_10573("Players", 9)) {
            this.playerList.clear();
            class_2499 playerNameList = compound.method_10554("Players", 10);
            for (int i = 0; i < playerNameList.size(); ++i) {
                class_2487 thisCompound = playerNameList.method_10602(i);
                PlayerReference reference = PlayerReference.load(thisCompound);
                if (reference == null) continue;
                this.playerList.add(reference);
            }
        }
        if (compound.method_10573("Discount", 3)) {
            this.discount = compound.method_10550("Discount");
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("Players")) {
            this.playerList.clear();
            JsonArray playerList = json.get("Players").getAsJsonArray();
            for (int i = 0; i < playerList.size(); ++i) {
                PlayerReference reference = PlayerReference.load(playerList.get(i));
                if (reference == null || this.isOnList(reference)) continue;
                this.playerList.add(reference);
            }
        }
        if (json.has("Discount")) {
            this.discount = json.get("Discount").getAsInt();
        }
    }

    @Override
    protected void handleUpdateMessage(class_2487 updateInfo) {
        if (updateInfo.method_10545("Discount")) {
            this.discount = updateInfo.method_10550("Discount");
        } else {
            boolean add = updateInfo.method_10577("Add");
            String name = updateInfo.method_10558("Name");
            PlayerReference player = PlayerReference.of(false, name);
            if (add && !this.isOnList(player)) {
                this.playerList.add(player);
            } else if (!add && this.isOnList(player)) {
                PlayerReference.removeFromList(this.playerList, player);
            }
        }
    }

    @Override
    public class_2487 savePersistentData() {
        return null;
    }

    @Override
    public void loadPersistentData(class_2487 data) {
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_DISCOUNT_LIST;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @Environment(value=EnvType.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        class_342 nameInput;
        class_342 discountInput;
        class_4185 buttonAddPlayer;
        class_4185 buttonRemovePlayer;
        class_4185 buttonSetDiscount;
        ScrollTextDisplay playerList;

        protected final PlayerDiscounts getRule() {
            if (this.getRuleRaw() instanceof PlayerDiscounts) {
                return (PlayerDiscounts)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            class_327 class_3272 = this.screen.getFont();
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 34;
            Objects.requireNonNull(this.screen);
            this.nameInput = this.addCustomRenderable(new class_342(class_3272, n, n2, 176 - 20, 20, (class_2561)class_2561.method_43473()));
            this.buttonAddPlayer = this.addCustomRenderable(new VanillaButton(this.screen.guiLeft() + 10, this.screen.guiTop() + 55, 78, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.discount.add"), this::PressAddButton));
            int n3 = this.screen.guiLeft();
            Objects.requireNonNull(this.screen);
            this.buttonRemovePlayer = this.addCustomRenderable(new VanillaButton(n3 + 176 - 88, this.screen.guiTop() + 55, 78, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.discount.remove"), this::PressForgetButton));
            this.discountInput = this.addCustomRenderable(new class_342(this.screen.getFont(), this.screen.guiLeft() + 10, this.screen.guiTop() + 9, 20, 20, (class_2561)class_2561.method_43473()));
            this.discountInput.method_1880(2);
            this.discountInput.method_1852(Integer.toString(this.getRule().discount));
            this.buttonSetDiscount = this.addCustomRenderable(new VanillaButton(this.screen.guiLeft() + 110, this.screen.guiTop() + 10, 50, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.discount.set"), this::PressSetDiscountButton));
            int n4 = this.screen.guiLeft() + 7;
            int n5 = this.screen.guiTop() + 78;
            Objects.requireNonNull(this.screen);
            this.playerList = this.addCustomRenderable(new ScrollTextDisplay(n4, n5, 176 - 14, 91, this.screen.getFont(), (Supplier<List<? extends class_2561>>)((Supplier)this::getPlayerList)));
            this.playerList.setColumnCount(2);
        }

        private List<class_2561> getPlayerList() {
            ArrayList playerList = Lists.newArrayList();
            if (this.getRule() == null) {
                return playerList;
            }
            for (PlayerReference player : this.getRule().playerList) {
                playerList.add(player.getNameComponent(true));
            }
            return playerList;
        }

        @Override
        public void renderTab(class_332 gui, int mouseX, int mouseY, float partialTicks) {
            if (this.getRule() == null) {
                return;
            }
            gui.method_25294(this.screen.guiLeft() + 7, this.screen.guiTop() + 78, this.screen.guiLeft() + this.screen.field_22789 - 7, this.screen.guiTop() + 78 + 91, 255);
            gui.method_51433(this.screen.getFont(), class_2561.method_43471((String)"gui.lightmanscurrency.discount.tooltip").getString(), this.discountInput.method_46426() + this.discountInput.method_25368() + 4, this.discountInput.method_46427() + 3, 0xFFFFFF, false);
        }

        @Override
        public void onScreenTick() {
            TextInputUtil.whitelistInteger(this.discountInput, 0L, 99L);
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.nameInput);
            this.removeCustomWidget(this.buttonAddPlayer);
            this.removeCustomWidget(this.buttonRemovePlayer);
            this.removeCustomWidget(this.discountInput);
            this.removeCustomWidget(this.buttonSetDiscount);
            this.removeCustomWidget(this.playerList);
        }

        void PressAddButton(class_4185 button) {
            String name = this.nameInput.method_1882();
            if (!name.isBlank()) {
                this.nameInput.method_1852("");
                class_2487 updateInfo = new class_2487();
                updateInfo.method_10556("Add", true);
                updateInfo.method_10582("Name", name);
                this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
            }
        }

        void PressForgetButton(class_4185 button) {
            String name = this.nameInput.method_1882();
            if (!name.isBlank()) {
                this.nameInput.method_1852("");
                class_2487 updateInfo = new class_2487();
                updateInfo.method_10556("Add", false);
                updateInfo.method_10582("Name", name);
                this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
            }
        }

        void PressSetDiscountButton(class_4185 button) {
            int discount;
            this.getRule().discount = discount = TextInputUtil.getIntegerValue(this.discountInput, 1);
            class_2487 updateInfo = new class_2487();
            updateInfo.method_10569("Discount", discount);
            this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
        }
    }
}

