/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.permissions.options;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public abstract class PermissionOption {
    public final String permission;
    protected TraderSettingsScreen screen;

    protected PermissionOption(String permission) {
        this.permission = permission;
    }

    public class_5250 widgetName() {
        return class_2561.method_43471((String)("permission." + this.permission));
    }

    protected final boolean hasPermission() {
        return this.permissionValue() > 0;
    }

    protected final int permissionValue() {
        if (this.screen.getTrader() == null) {
            return 0;
        }
        return this.screen.getTrader().getAllyPermissionLevel(this.permission);
    }

    public final void setValue(boolean newValue) {
        this.setValue(newValue ? 1 : 0);
    }

    public final void setValue(int newValue) {
        if (this.screen.getTrader() == null) {
            return;
        }
        this.screen.getTrader().setAllyPermissionLevel(this.screen.getPlayer(), this.permission, newValue);
        class_2487 message = new class_2487();
        message.method_10582("ChangeAllyPermissions", this.permission);
        message.method_10569("NewLevel", newValue);
        this.screen.getTrader().sendNetworkMessage(message);
    }

    public final OptionWidgets initWidgets(TraderSettingsScreen screen, int x, int y) {
        this.screen = screen;
        OptionWidgets widgets = new OptionWidgets();
        this.createWidget(x, y, widgets);
        return widgets;
    }

    protected abstract void createWidget(int var1, int var2, OptionWidgets var3);

    public abstract void tick();

    public void render(class_4587 pose, int mouseX, int mouseY) {
    }

    public abstract int widgetWidth();

    public static class OptionWidgets {
        List<class_339> buttons = Lists.newArrayList();
        List<class_364> listeners = Lists.newArrayList();

        public List<class_339> getRenderableWidgets() {
            return this.buttons;
        }

        public List<class_364> getListeners() {
            return this.listeners;
        }

        public <T extends class_339> T addRenderableWidget(T widget) {
            this.buttons.add(widget);
            return widget;
        }

        public <T extends class_364> T addListener(T listener) {
            this.listeners.add(listener);
            return listener;
        }
    }
}

