/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.AlertData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class PaygateTradeData
extends TradeData {
    int duration = 1;
    UUID ticketID = null;

    public PaygateTradeData() {
        super(true);
    }

    public int getDuration() {
        return Math.max(this.duration, 1);
    }

    public void setDuration(int duration) {
        this.duration = Math.max(duration, 1);
    }

    public boolean isTicketTrade() {
        return this.ticketID != null;
    }

    public UUID getTicketID() {
        return this.ticketID;
    }

    public void setTicketID(UUID ticketID) {
        this.ticketID = ticketID;
    }

    @Override
    public TradeData.TradeDirection getTradeDirection() {
        return TradeData.TradeDirection.SALE;
    }

    public boolean canAfford(TradeContext context) {
        if (this.isTicketTrade()) {
            return context.hasTicket(this.ticketID);
        }
        return context.hasFunds(this.cost);
    }

    @Override
    public boolean isValid() {
        return this.getDuration() >= 1 && (this.isTicketTrade() || super.isValid());
    }

    public static class_2487 saveAllData(class_2487 nbt, List<PaygateTradeData> data) {
        return PaygateTradeData.saveAllData(nbt, data, "Trades");
    }

    public static class_2487 saveAllData(class_2487 nbt, List<PaygateTradeData> data, String key) {
        class_2499 listNBT = new class_2499();
        for (int i = 0; i < data.size(); ++i) {
            listNBT.add((Object)data.get(i).getAsNBT());
        }
        if (listNBT.size() > 0) {
            nbt.method_10566(key, (class_2520)listNBT);
        }
        return nbt;
    }

    public static PaygateTradeData loadData(class_2487 nbt) {
        PaygateTradeData trade = new PaygateTradeData();
        trade.loadFromNBT(nbt);
        return trade;
    }

    public static List<PaygateTradeData> loadAllData(class_2487 nbt) {
        return PaygateTradeData.loadAllData("Trades", nbt);
    }

    public static List<PaygateTradeData> loadAllData(String key, class_2487 nbt) {
        class_2499 listNBT = nbt.method_10554(key, 10);
        List<PaygateTradeData> data = PaygateTradeData.listOfSize(listNBT.size());
        for (int i = 0; i < listNBT.size(); ++i) {
            data.get(i).loadFromNBT(listNBT.method_10602(i));
        }
        return data;
    }

    public static List<PaygateTradeData> listOfSize(int tradeCount) {
        ArrayList data = Lists.newArrayList();
        while (data.size() < tradeCount) {
            data.add(new PaygateTradeData());
        }
        return data;
    }

    @Override
    public class_2487 getAsNBT() {
        class_2487 compound = super.getAsNBT();
        compound.method_10569("Duration", this.getDuration());
        if (this.ticketID != null) {
            compound.method_25927("Ticket", this.ticketID);
        }
        return compound;
    }

    @Override
    protected void loadFromNBT(class_2487 compound) {
        super.loadFromNBT(compound);
        this.duration = compound.method_10550("Duration");
        this.ticketID = compound.method_10545("Ticket") ? compound.method_25926("Ticket") : null;
    }

    @Override
    public TradeData.TradeComparisonResult compare(TradeData otherTrade) {
        LightmansCurrency.LogWarning("Attempting to compare paygate trades, but paygate trades do not support this interaction.");
        return new TradeData.TradeComparisonResult();
    }

    @Override
    public boolean AcceptableDifferences(TradeData.TradeComparisonResult result) {
        LightmansCurrency.LogWarning("Attempting to determine if the paygate trades differences are acceptable, but paygate trades do not support this interaction.");
        return false;
    }

    @Override
    public List<class_2561> GetDifferenceWarnings(TradeData.TradeComparisonResult differences) {
        LightmansCurrency.LogWarning("Attempting to get warnings for different paygate trades, but paygate trades do not support this interaction.");
        return new ArrayList<class_2561>();
    }

    @Override
    public int tradeButtonWidth(TradeContext context) {
        return 94;
    }

    @Override
    public DisplayData inputDisplayArea(TradeContext context) {
        return new DisplayData(1, 1, 34, 16);
    }

    @Override
    public DisplayData outputDisplayArea(TradeContext context) {
        return new DisplayData(58, 1, 34, 16);
    }

    @Override
    public Pair<Integer, Integer> arrowPosition(TradeContext context) {
        return Pair.of((Object)36, (Object)1);
    }

    @Override
    public Pair<Integer, Integer> alertPosition(TradeContext context) {
        return Pair.of((Object)36, (Object)1);
    }

    @Override
    public List<DisplayEntry> getInputDisplays(TradeContext context) {
        if (this.isTicketTrade()) {
            return Lists.newArrayList((Object[])new DisplayEntry[]{DisplayEntry.of(TicketItem.CreateTicket(this.ticketID), 1, (List<class_2561>)Lists.newArrayList((Object[])new class_2561[]{class_2561.method_43469((String)"tooltip.lightmanscurrency.ticket.id", (Object[])new Object[]{this.ticketID})}))});
        }
        return Lists.newArrayList((Object[])new DisplayEntry[]{DisplayEntry.of(this.getCost(context), context.isStorageMode ? Lists.newArrayList((Object[])new class_2561[]{class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.price_edit")}) : null)});
    }

    @Override
    public List<DisplayEntry> getOutputDisplays(TradeContext context) {
        return Lists.newArrayList((Object[])new DisplayEntry[]{DisplayEntry.of((class_2561)PaygateTradeData.formatDurationDisplay(this.duration), TextRenderUtil.TextFormatting.create(), (List<class_2561>)Lists.newArrayList((Object[])new class_2561[]{PaygateTradeData.formatDuration(this.getDuration())}))});
    }

    public static class_5250 formatDurationShort(int duration) {
        int ticks = duration % 20;
        int seconds = duration / 20 % 60;
        int minutes = duration / 1200 % 60;
        int hours = duration / 72000;
        class_5250 result = class_2561.method_43473();
        if (hours > 0) {
            result.method_10852((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.hours.short", (Object[])new Object[]{hours}));
        }
        if (minutes > 0) {
            result.method_10852((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.minutes.short", (Object[])new Object[]{minutes}));
        }
        if (seconds > 0) {
            result.method_10852((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.seconds.short", (Object[])new Object[]{seconds}));
        }
        if (ticks > 0 || result.getString().isBlank()) {
            result.method_10852((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.ticks.short", (Object[])new Object[]{ticks}));
        }
        return result;
    }

    public static class_5250 formatDurationDisplay(int duration) {
        int ticks = duration % 20;
        int seconds = duration / 20 % 60;
        int minutes = duration / 1200 % 60;
        int hours = duration / 72000;
        if (hours > 0) {
            return class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.hours.short", (Object[])new Object[]{hours});
        }
        if (minutes > 0) {
            return class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.minutes.short", (Object[])new Object[]{minutes});
        }
        if (seconds > 0) {
            return class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.seconds.short", (Object[])new Object[]{seconds});
        }
        return class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.ticks.short", (Object[])new Object[]{ticks});
    }

    public static class_5250 formatDuration(int duration) {
        int ticks = duration % 20;
        int seconds = duration / 20 % 60;
        int minutes = duration / 1200 % 60;
        int hours = duration / 72000;
        class_5250 result = class_2561.method_43473();
        boolean addSpacer = false;
        if (hours > 0) {
            if (addSpacer) {
                result.method_10852((class_2561)class_2561.method_43470((String)" "));
            }
            addSpacer = true;
            if (hours > 1) {
                result.method_10852((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.hours", (Object[])new Object[]{hours}));
            } else {
                result.method_10852((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.hours.singular", (Object[])new Object[]{hours}));
            }
        }
        if (minutes > 0) {
            if (addSpacer) {
                result.method_10852((class_2561)class_2561.method_43470((String)" "));
            }
            addSpacer = true;
            if (minutes > 1) {
                result.method_10852((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.minutes", (Object[])new Object[]{minutes}));
            } else {
                result.method_10852((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.minutes.singular", (Object[])new Object[]{minutes}));
            }
        }
        if (seconds > 0) {
            if (addSpacer) {
                result.method_10852((class_2561)class_2561.method_43470((String)" "));
            }
            addSpacer = true;
            if (seconds > 1) {
                result.method_10852((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.seconds", (Object[])new Object[]{seconds}));
            } else {
                result.method_10852((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.seconds.singular", (Object[])new Object[]{seconds}));
            }
        }
        if (ticks > 0) {
            if (addSpacer) {
                result.method_10852((class_2561)class_2561.method_43470((String)" "));
            }
            addSpacer = true;
            if (ticks > 1) {
                result.method_10852((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.ticks", (Object[])new Object[]{ticks}));
            } else {
                result.method_10852((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.paygate.duration.ticks.singular", (Object[])new Object[]{ticks}));
            }
        }
        return result;
    }

    @Override
    protected void getAdditionalAlertData(TradeContext context, List<AlertData> alerts) {
        if (context.hasTrader() && context.getTrader() instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)context.getTrader();
            if (paygate.isActive()) {
                alerts.add(AlertData.warn(class_2561.method_43471((String)"tooltip.lightmanscurrency.paygate.active")));
            }
            if (!this.canAfford(context)) {
                alerts.add(AlertData.warn(class_2561.method_43471((String)"tooltip.lightmanscurrency.cannotafford")));
            }
        }
    }

    @Override
    public void onInputDisplayInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int index, int button, class_1799 heldItem) {
        if (tab.menu.getTrader() instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)tab.menu.getTrader();
            int tradeIndex = paygate.getAllTrades().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            if (heldItem.method_7909() == ModItems.TICKET_MASTER) {
                this.setTicketID(TicketItem.GetTicketID(heldItem));
                if (tab.menu.isClient()) {
                    tab.sendInputInteractionMessage(tradeIndex, 0, button, heldItem);
                }
            } else {
                class_2487 extraData = new class_2487();
                extraData.method_10569("TradeIndex", tradeIndex);
                tab.sendOpenTabMessage(2, extraData);
            }
        }
    }

    @Override
    public void onOutputDisplayInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int index, int button, class_1799 heldItem) {
        if (tab.menu.getTrader() instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)tab.menu.getTrader();
            int tradeIndex = paygate.getAllTrades().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            class_2487 extraData = new class_2487();
            extraData.method_10569("TradeIndex", tradeIndex);
            tab.sendOpenTabMessage(2, extraData);
        }
    }

    @Override
    public void onInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int mouseX, int mouseY, int button, class_1799 heldItem) {
        if (tab.menu.getTrader() instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)tab.menu.getTrader();
            int tradeIndex = paygate.getAllTrades().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            class_2487 extraData = new class_2487();
            extraData.method_10569("TradeIndex", tradeIndex);
            tab.sendOpenTabMessage(2, extraData);
        }
    }
}

