/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.item.ItemStorageTab;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.item.ItemTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.OutOfStockNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.item.ItemTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings.AddRemoveTradeNotification;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.ITradeSource;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.item.handler.TraderItemHandler;
import io.github.lightman314.lightmanscurrency.common.traders.item.storage.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class ItemTraderData
extends InputTraderData
implements TraderItemStorage.ITraderItemFilter,
ITradeSource<ItemTradeData> {
    public static final List<UpgradeType> ALLOWED_UPGRADES = Lists.newArrayList((Object[])new UpgradeType[]{UpgradeType.ITEM_CAPACITY});
    public static final int DEFAULT_STACK_LIMIT = 576;
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "item_trader");
    TraderItemHandler itemHandler = new TraderItemHandler(this);
    protected TraderItemStorage storage = new TraderItemStorage(this);
    protected List<ItemTradeData> trades;

    public final TraderItemStorage getStorage() {
        return this.storage;
    }

    public void markStorageDirty() {
        this.markDirty(this::saveStorage);
    }

    @Override
    public boolean allowAdditionalUpgradeType(UpgradeType type) {
        return ALLOWED_UPGRADES.contains(type);
    }

    public ItemTraderData() {
        this(TYPE);
    }

    protected ItemTraderData(class_2960 type) {
        super(type);
        this.trades = ItemTradeData.listOfSize(1, true);
        this.validateTradeRestrictions();
    }

    public ItemTraderData(int tradeCount, class_1937 level, class_2338 pos) {
        this(TYPE, tradeCount, level, pos);
    }

    protected ItemTraderData(class_2960 type, int tradeCount, class_1937 level, class_2338 pos) {
        super(type, level, pos);
        this.trades = ItemTradeData.listOfSize(tradeCount, true);
        this.validateTradeRestrictions();
    }

    @Override
    public void saveAdditional(class_2487 compound) {
        super.saveAdditional(compound);
        this.saveStorage(compound);
        this.saveTrades(compound);
    }

    protected final void saveStorage(class_2487 compound) {
        this.storage.save(compound, "ItemStorage");
    }

    @Override
    protected final void saveTrades(class_2487 compound) {
        ItemTradeData.saveAllData(compound, this.trades);
    }

    @Override
    public void loadAdditional(class_2487 compound) {
        super.loadAdditional(compound);
        if (compound.method_10545("ItemStorage")) {
            this.storage.load(compound, "ItemStorage");
        }
        if (compound.method_10545("Trades")) {
            this.trades = ItemTradeData.loadAllData(compound, !this.isPersistent());
            this.validateTradeRestrictions();
        }
    }

    @Override
    public int getTradeCount() {
        return this.trades.size();
    }

    @Override
    public void addTrade(class_1657 requestor) {
        if (this.isClient()) {
            return;
        }
        if (this.getTradeCount() >= 32) {
            return;
        }
        if (CommandLCAdmin.isAdminPlayer(requestor)) {
            this.overrideTradeCount(this.getTradeCount() + 1);
            this.pushLocalNotification(new AddRemoveTradeNotification(PlayerReference.of(requestor), true, this.getTradeCount()));
        } else {
            Permissions.PermissionWarning(requestor, "add a trade slot", "LC_ADMIN_MODE");
        }
    }

    @Override
    public void removeTrade(class_1657 requestor) {
        if (this.isClient()) {
            return;
        }
        if (this.getTradeCount() <= 1) {
            return;
        }
        if (CommandLCAdmin.isAdminPlayer(requestor)) {
            this.overrideTradeCount(this.getTradeCount() - 1);
            this.pushLocalNotification(new AddRemoveTradeNotification(PlayerReference.of(requestor), false, this.getTradeCount()));
        } else {
            Permissions.PermissionWarning(requestor, "remove a trade slot", "LC_ADMIN_MODE");
        }
    }

    public void overrideTradeCount(int newTradeCount) {
        if (this.getTradeCount() == MathUtil.clamp(newTradeCount, 1, 32)) {
            return;
        }
        int tradeCount = MathUtil.clamp(newTradeCount, 1, 32);
        List<ItemTradeData> oldTrades = this.trades;
        this.trades = ItemTradeData.listOfSize(tradeCount, !this.isPersistent());
        for (int i = 0; i < oldTrades.size() && i < this.trades.size(); ++i) {
            this.trades.set(i, oldTrades.get(i));
        }
        this.validateTradeRestrictions();
        if (this.isServer()) {
            this.markTradesDirty();
        }
    }

    public final void validateTradeRestrictions() {
        for (int i = 0; i < this.trades.size(); ++i) {
            ItemTradeData trade = this.trades.get(i);
            trade.setRestriction(this.getTradeRestriction(i));
        }
    }

    protected ItemTradeRestriction getTradeRestriction(int tradeIndex) {
        return ItemTradeRestriction.NONE;
    }

    @Override
    public ItemTradeData getTrade(int tradeSlot) {
        if (tradeSlot < 0 || tradeSlot >= this.trades.size()) {
            LightmansCurrency.LogError("Cannot get trade in index " + tradeSlot + " from a trader with only " + this.trades.size() + " trades.");
            return new ItemTradeData(false);
        }
        return this.trades.get(tradeSlot);
    }

    public List<ItemTradeData> getTradeData() {
        return new ArrayList<ItemTradeData>(this.trades);
    }

    @Override
    public int getTradeStock(int tradeSlot) {
        ItemTradeData trade = this.getTrade(tradeSlot);
        if (trade.sellItemsDefined()) {
            if (this.isCreative()) {
                return Integer.MAX_VALUE;
            }
            return trade.stockCount(this);
        }
        return 0;
    }

    @Override
    public Storage<ItemVariant> getItemStorage(class_2350 relativeSide) {
        return this.itemHandler.getHandler(relativeSide);
    }

    @Override
    public IconData inputSettingsTabIcon() {
        return IconData.of((class_1935)class_1802.field_8239);
    }

    @Override
    public class_5250 inputSettingsTabTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.settings.iteminput");
    }

    @Override
    public int inputSettingsTabColor() {
        return 48896;
    }

    @Override
    public int inputSettingsTextColor() {
        return 0xD0D0D0;
    }

    @Override
    public IconData getIcon() {
        return IconData.of((class_1935)ModItems.TRADING_CORE);
    }

    @Override
    public boolean hasValidTrade() {
        for (ItemTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void saveAdditionalToJson(JsonObject json) {
        JsonArray trades = new JsonArray();
        for (ItemTradeData trade : this.trades) {
            JsonArray ruleData;
            if (!trade.isValid()) continue;
            JsonObject tradeData = new JsonObject();
            tradeData.addProperty("TradeType", trade.getTradeType().name());
            if (trade.getSellItem(0).method_7960()) {
                tradeData.add("SellItem", (JsonElement)FileUtil.convertItemStack(trade.getSellItem(1)));
                if (trade.hasCustomName(1)) {
                    tradeData.addProperty("DisplayName", trade.getCustomName(1));
                }
            } else {
                tradeData.add("SellItem", (JsonElement)FileUtil.convertItemStack(trade.getSellItem(0)));
                if (trade.hasCustomName(0)) {
                    tradeData.addProperty("DisplayName", trade.getCustomName(0));
                }
                if (!trade.getSellItem(1).method_7960()) {
                    tradeData.add("SellItem2", (JsonElement)FileUtil.convertItemStack(trade.getSellItem(1)));
                    if (trade.hasCustomName(1)) {
                        tradeData.addProperty("DisplayName2", trade.getCustomName(1));
                    }
                }
            }
            if (trade.isSale() || trade.isPurchase()) {
                tradeData.add("Price", trade.getCost().toJson());
            }
            if (trade.isBarter()) {
                if (trade.getBarterItem(0).method_7960()) {
                    tradeData.add("BarterItem", (JsonElement)FileUtil.convertItemStack(trade.getBarterItem(1)));
                } else {
                    tradeData.add("BarterItem", (JsonElement)FileUtil.convertItemStack(trade.getBarterItem(0)));
                    if (!trade.getBarterItem(1).method_7960()) {
                        tradeData.add("BarterItem2", (JsonElement)FileUtil.convertItemStack(trade.getBarterItem(1)));
                    }
                }
            }
            if ((ruleData = TradeRule.saveRulesToJson(trade.getRules())).size() > 0) {
                tradeData.add("Rules", (JsonElement)ruleData);
            }
            trades.add((JsonElement)tradeData);
        }
        json.add("Trades", (JsonElement)trades);
    }

    @Override
    protected void loadAdditionalFromJson(JsonObject json) throws Exception {
        if (!json.has("Trades")) {
            throw new Exception("Item Trader must have a trade list.");
        }
        JsonArray trades = json.get("Trades").getAsJsonArray();
        this.trades = new ArrayList<ItemTradeData>();
        for (int i = 0; i < trades.size() && this.trades.size() < 32; ++i) {
            try {
                JsonObject tradeData = trades.get(i).getAsJsonObject();
                ItemTradeData newTrade = new ItemTradeData(false);
                newTrade.setItem(FileUtil.parseItemStack(tradeData.get("SellItem").getAsJsonObject()), 0);
                if (tradeData.has("SellItem2")) {
                    newTrade.setItem(FileUtil.parseItemStack(tradeData.get("SellItem2").getAsJsonObject()), 1);
                }
                if (tradeData.has("TradeType")) {
                    newTrade.setTradeType(ItemTradeData.loadTradeType(tradeData.get("TradeType").getAsString()));
                }
                if (tradeData.has("Price")) {
                    if (newTrade.isBarter()) {
                        LightmansCurrency.LogWarning("Price is being defined for a barter trade. Price will be ignored.");
                    } else {
                        newTrade.setCost(CoinValue.Parse(tradeData.get("Price")));
                    }
                } else if (!newTrade.isBarter()) {
                    LightmansCurrency.LogWarning("Price is not defined on a non-barter trade. Price will be assumed to be free.");
                    newTrade.getCost().setFree(true);
                }
                if (tradeData.has("BarterItem")) {
                    if (newTrade.isBarter()) {
                        newTrade.setItem(FileUtil.parseItemStack(tradeData.get("BarterItem").getAsJsonObject()), 2);
                        if (tradeData.has("BarterItem2")) {
                            newTrade.setItem(FileUtil.parseItemStack(tradeData.get("BarterItem2").getAsJsonObject()), 3);
                        }
                    } else {
                        LightmansCurrency.LogWarning("BarterItem is being defined for a non-barter trade. Barter item will be ignored.");
                    }
                }
                if (tradeData.has("DisplayName")) {
                    newTrade.setCustomName(0, tradeData.get("DisplayName").getAsString());
                }
                if (tradeData.has("DisplayName2")) {
                    newTrade.setCustomName(1, tradeData.get("DisplayName2").getAsString());
                }
                if (tradeData.has("Rules")) {
                    newTrade.setRules(TradeRule.Parse(tradeData.get("Rules").getAsJsonArray()));
                }
                this.trades.add(newTrade);
                continue;
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error parsing item trade at index " + i, e);
            }
        }
        if (this.trades.size() == 0) {
            throw new Exception("Trader has no valid trades!");
        }
        this.storage = new TraderItemStorage.LockedTraderStorage(this);
    }

    @Override
    protected void saveAdditionalPersistentData(class_2487 compound) {
        class_2499 tradePersistentData = new class_2499();
        boolean tradesAreRelevant = false;
        Iterator<ItemTradeData> iterator = this.trades.iterator();
        while (iterator.hasNext()) {
            class_2487 ptTag = new class_2487();
            ItemTradeData trade = iterator.next();
            if (TradeRule.savePersistentData(ptTag, trade.getRules(), "RuleData")) {
                tradesAreRelevant = true;
            }
            tradePersistentData.add((Object)ptTag);
        }
        if (tradesAreRelevant) {
            compound.method_10566("PersistentTradeData", (class_2520)tradePersistentData);
        }
    }

    @Override
    protected void loadAdditionalPersistentData(class_2487 compound) {
        if (compound.method_10545("PersistentTradeData")) {
            class_2499 tradePersistentData = compound.method_10554("PersistentTradeData", 10);
            for (int i = 0; i < tradePersistentData.size() && i < this.trades.size(); ++i) {
                ItemTradeData trade = this.trades.get(i);
                class_2487 ptTag = tradePersistentData.method_10602(i);
                TradeRule.loadPersistentData(ptTag, trade.getRules(), "RuleData");
            }
        }
    }

    @Override
    protected void getAdditionalContents(List<class_1799> results) {
        results.addAll(this.storage.getSplitContents());
    }

    @Override
    public TradeContext.TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        ItemTradeData trade = this.getTrade(tradeIndex);
        if (trade == null) {
            LightmansCurrency.LogError("Trade at index " + tradeIndex + " is null. Cannot execute trade!");
            return TradeContext.TradeResult.FAIL_INVALID_TRADE;
        }
        if (!trade.isValid()) {
            LightmansCurrency.LogWarning("Trade at index " + tradeIndex + " is not a valid trade. Cannot execute trade.");
            return TradeContext.TradeResult.FAIL_INVALID_TRADE;
        }
        if (!context.hasPlayerReference()) {
            return TradeContext.TradeResult.FAIL_NULL;
        }
        if (this.runPreTradeEvent(context.getPlayerReference(), trade).isCanceled()) {
            return TradeContext.TradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        CoinValue price = this.runTradeCostEvent(context.getPlayerReference(), trade).getCostResult();
        if (trade.isSale()) {
            if (!trade.hasStock(context) && !this.isCreative()) {
                LightmansCurrency.LogDebug("Not enough items in storage to carry out the trade at index " + tradeIndex + ". Cannot execute trade.");
                return TradeContext.TradeResult.FAIL_OUT_OF_STOCK;
            }
            if (!context.canFitItems(trade.getSellItem(0), trade.getSellItem(1))) {
                LightmansCurrency.LogDebug("Not enough room for the output item. Aborting trade!");
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.getPayment(price)) {
                LightmansCurrency.LogDebug("Not enough money is present for the trade at index " + tradeIndex + ". Cannot execute trade.");
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!context.putItem(trade.getSellItem(0))) {
                LightmansCurrency.LogError("Not enough room for the output item. Giving refund & aborting Trade!");
                context.givePayment(price);
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.putItem(trade.getSellItem(1))) {
                LightmansCurrency.LogError("Not enough room for the output item. Giving refund & aborting Trade!");
                context.collectItem(trade.getSellItem(0));
                context.givePayment(price);
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            this.pushNotification(() -> new ItemTradeNotification(trade, price, context.getPlayerReference(), this.getNotificationCategory()));
            if (!this.isCreative()) {
                trade.RemoveItemsFromStorage(this.getStorage());
                this.markStorageDirty();
                this.addStoredMoney(price);
                if (!trade.hasStock(this)) {
                    this.pushNotification(() -> new OutOfStockNotification(this.getNotificationCategory(), tradeIndex));
                }
            }
            this.runPostTradeEvent(context.getPlayerReference(), trade, price);
            return TradeContext.TradeResult.SUCCESS;
        }
        if (trade.isPurchase()) {
            if (!context.hasItems(trade.getSellItem(0), trade.getSellItem(1))) {
                LightmansCurrency.LogDebug("Not enough items in the item slots to make the purchase.");
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!trade.hasSpace(this) && !this.isCreative()) {
                LightmansCurrency.LogDebug("Not enough room in storage to store the purchased items.");
                return TradeContext.TradeResult.FAIL_NO_INPUT_SPACE;
            }
            if (!trade.hasStock(context) && !this.isCreative()) {
                LightmansCurrency.LogDebug("Not enough money in storage to pay for the purchased items.");
                return TradeContext.TradeResult.FAIL_OUT_OF_STOCK;
            }
            context.collectItem(trade.getSellItem(0));
            context.collectItem(trade.getSellItem(1));
            context.givePayment(price);
            this.pushNotification(() -> new ItemTradeNotification(trade, price, context.getPlayerReference(), this.getNotificationCategory()));
            if (!this.isCreative()) {
                this.getStorage().forceAddItem(trade.getSellItem(0));
                this.getStorage().forceAddItem(trade.getSellItem(1));
                this.markStorageDirty();
                this.removeStoredMoney(price);
                if (!trade.hasStock(this)) {
                    this.pushNotification(() -> new OutOfStockNotification(this.getNotificationCategory(), tradeIndex));
                }
            }
            this.runPostTradeEvent(context.getPlayerReference(), trade, price);
            return TradeContext.TradeResult.SUCCESS;
        }
        if (trade.isBarter()) {
            if (!context.hasItems(trade.getBarterItem(0), trade.getBarterItem(1))) {
                LightmansCurrency.LogDebug("Not enough items in the item slots to make the barter.");
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!trade.hasSpace(this) && !this.isCreative()) {
                LightmansCurrency.LogDebug("Not enough room in storage to store the purchased items.");
                return TradeContext.TradeResult.FAIL_NO_INPUT_SPACE;
            }
            if (!trade.hasStock(context) && !this.isCreative()) {
                LightmansCurrency.LogDebug("Not enough items in storage to carry out the trade at index " + tradeIndex + ". Cannot execute trade.");
                return TradeContext.TradeResult.FAIL_OUT_OF_STOCK;
            }
            context.collectItem(trade.getBarterItem(0));
            context.collectItem(trade.getBarterItem(1));
            if (!context.putItem(trade.getSellItem(0))) {
                LightmansCurrency.LogDebug("Not enough room for the output item. Aborting trade!");
                context.putItem(trade.getBarterItem(0));
                context.putItem(trade.getBarterItem(1));
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.putItem(trade.getSellItem(1))) {
                LightmansCurrency.LogDebug("Not enough room for the output item. Aborting trade!");
                context.collectItem(trade.getSellItem(0));
                context.putItem(trade.getBarterItem(0));
                context.putItem(trade.getBarterItem(1));
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            this.pushNotification(() -> new ItemTradeNotification(trade, price, context.getPlayerReference(), this.getNotificationCategory()));
            if (!this.isCreative()) {
                this.getStorage().forceAddItem(trade.getBarterItem(0));
                this.getStorage().forceAddItem(trade.getBarterItem(1));
                trade.RemoveItemsFromStorage(this.getStorage());
                this.markStorageDirty();
                if (!trade.hasStock(this)) {
                    this.pushNotification(() -> new OutOfStockNotification(this.getNotificationCategory(), tradeIndex));
                }
            }
            this.runPostTradeEvent(context.getPlayerReference(), trade, price);
            return TradeContext.TradeResult.SUCCESS;
        }
        return TradeContext.TradeResult.FAIL_INVALID_TRADE;
    }

    @Override
    public void addInteractionSlots(List<InteractionSlotData> interactionSlots) {
    }

    @Override
    public boolean canMakePersistent() {
        return true;
    }

    @Override
    public void initStorageTabs(TraderStorageMenu menu) {
        menu.setTab(1, new ItemStorageTab(menu));
        menu.setTab(2, new ItemTradeEditTab(menu));
    }

    @Override
    public boolean isItemRelevant(class_1799 item) {
        for (ItemTradeData trade : this.trades) {
            if (!trade.allowItemInStorage(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getStorageStackLimit() {
        int limit = 576;
        for (int i = 0; i < this.getUpgrades().method_5439(); ++i) {
            UpgradeItem upgradeItem;
            class_1799 stack = this.getUpgrades().method_5438(i);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)class_17922) || !(upgradeItem.getUpgradeType() instanceof CapacityUpgrade)) continue;
            limit += UpgradeItem.getUpgradeData(stack).getIntValue(CapacityUpgrade.CAPACITY);
        }
        return limit;
    }
}

